/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.util.xpath.EncryptFunction;

public class KeyStoreManager {
    private static final Log log = LogFactory.getLog(EncryptFunction.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore getKeyStore(String keyStoreFilePath, String keyStorePassword, String keyStoreType) throws KeyStoreException {
        String file = new File(keyStoreFilePath).getAbsolutePath();
        try (FileInputStream keyStoreFileInputStream = new FileInputStream(file);){
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(keyStoreFileInputStream, keyStorePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            String errorMessage = String.format("Keystore file does not exist in the path as configured in '%s' property.", keyStoreFilePath);
            throw new KeyStoreException(errorMessage);
        }
    }

    public static Certificate getCertificateFromStore(KeyStore keyStore, String keyAlias) throws KeyStoreException {
        return keyStore.getCertificate(keyAlias);
    }

    public static PrivateKey getPrivateKeyFromKeyStore(KeyStore keyStore, String keyPassword, String keyAlias) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        Key key = keyStore.getKey(keyAlias, keyPassword.toCharArray());
        return key instanceof PrivateKey ? (PrivateKey)key : null;
    }
}

