/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class HMACGenerateFunction
implements Function {
    private static final Log log = LogFactory.getLog(HMACGenerateFunction.class);
    private static final String DEFAULT_HMAC_SIGNATURE = "HmacSHA1";
    private static Map<String, Mac> macInstancesMap = new ConcurrentHashMap<String, Mac>();

    public Object call(Context context, List args) throws FunctionCallException {
        boolean debugOn = log.isDebugEnabled();
        if (args == null) {
            if (debugOn) {
                log.debug((Object)"Missing arguments in the function call");
            }
            return "";
        }
        int size = args.size();
        if (size == 2) {
            String payload = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String secret = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            return this.generateSignature(payload, secret, DEFAULT_HMAC_SIGNATURE);
        }
        if (size == 3) {
            String payload = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String secret = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            String algorithm = StringFunction.evaluate(args.get(2), (Navigator)context.getNavigator());
            return this.generateSignature(payload, secret, algorithm);
        }
        if (debugOn) {
            log.debug((Object)"Missing arguments in the function call");
        }
        return "";
    }

    private String generateSignature(String payload, String secret, String algorithm) throws FunctionCallException {
        try {
            Mac mac = this.getMacInstance(algorithm);
            SecretKeySpec signingKey = new SecretKeySpec(secret.getBytes(), algorithm);
            mac.init(signingKey);
            return HMACGenerateFunction.toHexString(mac.doFinal(payload.getBytes()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            String msg = "Error while generating HMAC signature";
            log.error((Object)msg, (Throwable)e);
            throw new FunctionCallException(msg, (Exception)e);
        }
    }

    private static String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private Mac getMacInstance(String algorithm) throws NoSuchAlgorithmException {
        Mac macInstance = macInstancesMap.get(algorithm);
        if (macInstance == null) {
            macInstance = Mac.getInstance(algorithm);
            macInstancesMap.put(algorithm, macInstance);
        }
        return macInstance;
    }
}

