/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.util.xpath.KeyStoreManager;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class DecryptFunction
implements Function {
    private static final Log log = LogFactory.getLog(DecryptFunction.class);
    private static final String DEFAULT_ALGORITHM = "RSA";
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static Map<String, Cipher> cipherInstancesMap = new ConcurrentHashMap<String, Cipher>();

    public Object call(Context context, List args) throws FunctionCallException {
        boolean debugOn = log.isDebugEnabled();
        if (args == null) {
            if (debugOn) {
                log.debug((Object)"Missing arguments in the function call");
            }
            return "";
        }
        int size = args.size();
        if (size == 4) {
            String encryptedText = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String keyStore = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            String keyStorePassword = StringFunction.evaluate(args.get(2), (Navigator)context.getNavigator());
            String keyStoreAlias = StringFunction.evaluate(args.get(3), (Navigator)context.getNavigator());
            return this.decrypt(encryptedText.getBytes(), keyStore, keyStorePassword, keyStoreAlias, DEFAULT_KEYSTORE_TYPE, DEFAULT_ALGORITHM);
        }
        if (size == 5) {
            String encryptedText = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String keyStore = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            String keyStorePassword = StringFunction.evaluate(args.get(2), (Navigator)context.getNavigator());
            String keyStoreAlias = StringFunction.evaluate(args.get(3), (Navigator)context.getNavigator());
            String keyStoreType = StringFunction.evaluate(args.get(4), (Navigator)context.getNavigator());
            return this.decrypt(encryptedText.getBytes(), keyStore, keyStorePassword, keyStoreAlias, keyStoreType, DEFAULT_ALGORITHM);
        }
        if (size == 6) {
            String encryptedText = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String keyStore = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            String keyStorePassword = StringFunction.evaluate(args.get(2), (Navigator)context.getNavigator());
            String keyStoreAlias = StringFunction.evaluate(args.get(3), (Navigator)context.getNavigator());
            String keyStoreType = StringFunction.evaluate(args.get(4), (Navigator)context.getNavigator());
            String algorithm = StringFunction.evaluate(args.get(5), (Navigator)context.getNavigator());
            return this.decrypt(encryptedText.getBytes(), keyStore, keyStorePassword, keyStoreAlias, keyStoreType, algorithm);
        }
        if (debugOn) {
            log.debug((Object)"Missing arguments in the function call");
        }
        return "";
    }

    private String decrypt(byte[] encryptedText, String keyStorePath, String keyStorePassword, String alias, String keyStoreType, String algorithm) throws FunctionCallException {
        if (encryptedText == null) {
            throw new FunctionCallException("Encrypted text can't be null.");
        }
        try {
            Cipher cipher = this.getCipherInstance(algorithm);
            KeyStore keyStore = KeyStoreManager.getKeyStore(keyStorePath, keyStorePassword, keyStoreType);
            Certificate certificate = KeyStoreManager.getCertificateFromStore(keyStore, alias);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Certificate used for encrypting : " + certificate));
            }
            cipher.init(2, KeyStoreManager.getPrivateKeyFromKeyStore(keyStore, keyStorePassword, alias));
            byte[] decodedText = Base64.getDecoder().decode(encryptedText);
            byte[] cipherText = cipher.doFinal(decodedText);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully encrypted data using the algorithm '%s'", algorithm));
            }
            return new String(cipherText);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new FunctionCallException("An error occurred while encrypting data.", (Exception)e);
        }
    }

    private Cipher getCipherInstance(String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipherInstance = cipherInstancesMap.get(algorithm);
        if (cipherInstance == null) {
            cipherInstance = Cipher.getInstance(algorithm);
            cipherInstancesMap.put(algorithm, cipherInstance);
        }
        return cipherInstance;
    }
}

