/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.streaming_xpath.custom.components;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.util.streaming_xpath.custom.components.ParserComponent;

public class GetChildrenWithChildParserComponent
extends ParserComponent {
    ParserComponent nextParserComponent;
    String localName;
    String nameSpacePrefix;
    QName childQName;

    public GetChildrenWithChildParserComponent(String localName, String nameSpacePrefix) {
        this.localName = localName;
        this.nameSpacePrefix = nameSpacePrefix;
    }

    @Override
    public String process(OMElement node) {
        this.childQName = new QName((String)prefixNameSpaceMap.get(this.nameSpacePrefix), this.localName);
        try {
            Iterator children = node.getChildElements();
            OMElement child = (OMElement)children.next();
            OMElement grandChild = child.getFirstChildWithName(this.childQName);
            if (grandChild != null) {
                if (this.nextParserComponent == null) {
                    return child.toString();
                }
                return this.nextParserComponent.process(child);
            }
            return "";
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    @Override
    public void setNext(ParserComponent parserComponent) {
        this.nextParserComponent = parserComponent;
    }

    @Override
    public ParserComponent getNext() {
        return this.nextParserComponent;
    }
}

