/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.streaming_xpath.custom.components;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.util.streaming_xpath.custom.components.ParserComponent;

public class GetChildrenWithAttributeValueParserComponent
extends ParserComponent {
    ParserComponent nextParserComponent;
    String localName;
    String nameSpacePrefix;
    QName attributeQName;
    String attributeValue;

    public GetChildrenWithAttributeValueParserComponent(String localName, String nameSpacePrefix, String value) {
        this.localName = localName;
        this.nameSpacePrefix = nameSpacePrefix;
        this.attributeValue = value;
    }

    @Override
    public String process(OMElement node) {
        this.attributeQName = new QName((String)prefixNameSpaceMap.get(this.nameSpacePrefix), this.localName);
        try {
            Iterator children = node.getChildElements();
            OMElement child = (OMElement)children.next();
            OMAttribute atr = child.getAttribute(this.attributeQName);
            if (atr != null) {
                if (this.attributeValue.equals(atr.getAttributeValue())) {
                    if (this.nextParserComponent == null) {
                        return child.toString();
                    }
                    return this.nextParserComponent.process(child);
                }
                return "";
            }
            return "";
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public void setNext(ParserComponent parserComponent) {
        this.nextParserComponent = parserComponent;
    }

    @Override
    public ParserComponent getNext() {
        return this.nextParserComponent;
    }
}

