/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.streaming_xpath.custom.components;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.util.streaming_xpath.custom.components.ParserComponent;

public class GetChildrenByNameRelativeParserComponent
extends ParserComponent {
    ParserComponent nextParserComponent;
    String localName;
    String nameSpacePrefix;
    QName childQName;

    public GetChildrenByNameRelativeParserComponent(String localName, String nameSpacePrefix) {
        this.localName = localName;
        this.nameSpacePrefix = nameSpacePrefix;
    }

    @Override
    public String process(OMElement node) {
        this.childQName = new QName((String)prefixNameSpaceMap.get(this.nameSpacePrefix), this.localName);
        OMElement result = this.findElement(node, this.childQName);
        if (result != null) {
            if (this.nextParserComponent == null) {
                return result.toString();
            }
            return this.nextParserComponent.process(result);
        }
        return "";
    }

    @Override
    public void setNext(ParserComponent parserComponent) {
        this.nextParserComponent = parserComponent;
    }

    @Override
    public ParserComponent getNext() {
        return this.nextParserComponent;
    }

    private OMElement findElement(OMElement node, QName childQName) {
        try {
            Iterator child = node.getChildrenWithName(childQName);
            return (OMElement)child.next();
        }
        catch (NoSuchElementException e) {
            Iterator children = node.getChildElements();
            while (children.hasNext()) {
                OMElement result = this.findElement((OMElement)children.next(), childQName);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }
}

