/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.resolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.resolver.CustomWSDLLocator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class SecureVaultResolver {
    private static Log log = LogFactory.getLog(CustomWSDLLocator.class);
    private static final String SECURE_VAULT_REGEX = "\\{(wso2:vault-lookup\\('(.*?)'\\))\\}";
    private static Pattern vaultLookupPattern = Pattern.compile("\\{(wso2:vault-lookup\\('(.*?)'\\))\\}");

    private SecureVaultResolver() {
    }

    public static boolean checkVaultLookupPattersExists(String aliasSecret) {
        Matcher lookupMatcher = vaultLookupPattern.matcher(aliasSecret);
        return lookupMatcher.find();
    }

    public static String resolve(SynapseEnvironment synapseEnvironment, String value) {
        if (value == null) {
            return null;
        }
        Matcher lookupMatcher = vaultLookupPattern.matcher(value);
        String resolvedValue = value;
        if (lookupMatcher.find()) {
            Value expression = null;
            String expressionStr = lookupMatcher.group(1);
            try {
                expression = new Value(new SynapseXPath(expressionStr));
            }
            catch (JaxenException e) {
                throw new SynapseException("Error while building the expression : " + expressionStr, e);
            }
            resolvedValue = expression.evaluateValue(synapseEnvironment.createMessageContext());
            if (StringUtils.isEmpty((String)resolvedValue)) {
                log.warn((Object)("Found Empty value for expression : " + (Object)((Object)expression.getExpression())));
                resolvedValue = "";
            }
        }
        return resolvedValue;
    }
}

