/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.mediators.Value;
import org.xml.sax.InputSource;

public class ResourceMap {
    private static final Log log = LogFactory.getLog(ResourceMap.class);
    private final List<Pair> resourceLocationList = new ArrayList<Pair>();

    public void addResource(Value location, Value key) {
        this.resourceLocationList.add(new Pair(location, key));
    }

    public void addResource(String location, String key) {
        this.addResource(new Value(location), new Value(key));
    }

    public Map<String, String> getResources() {
        LinkedHashMap<String, String> resourceMap = new LinkedHashMap<String, String>();
        for (Pair entry : this.resourceLocationList) {
            resourceMap.put(entry.getKey().getKeyValue() == null ? "{".concat(entry.getKey().getExpression().getExpression()).concat("}") : entry.getKey().getKeyValue(), entry.getValue().getKeyValue() == null ? "{".concat(entry.getValue().getExpression().getExpression()).concat("}") : entry.getValue().getKeyValue());
        }
        return Collections.unmodifiableMap(resourceMap);
    }

    public InputSource resolve(SynapseConfiguration synCfg, String location) {
        return this.resolve(synCfg, location, null);
    }

    public InputSource resolve(SynapseConfiguration synCfg, String location, MessageContext messageContext) {
        String key = null;
        HashMap<String, String> locationMap = new HashMap<String, String>();
        for (Pair entry : this.resourceLocationList) {
            if (messageContext != null) {
                locationMap.put(entry.getKey().evaluateValue(messageContext), entry.getValue().evaluateValue(messageContext));
                continue;
            }
            locationMap.put(entry.getKey().getKeyValue() == null ? entry.getKey().getExpression().getExpression() : entry.getKey().getKeyValue(), entry.getValue().getKeyValue() == null ? entry.getValue().getExpression().getExpression() : entry.getValue().getKeyValue());
        }
        if (locationMap.get(location) != null) {
            key = (String)locationMap.get(location);
        }
        if (key == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No resource mapping is defined for location '" + location + "'"));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving location '" + location + "' to registry item '" + key + "'"));
        }
        synCfg.getEntryDefinition(key);
        Object keyObject = synCfg.getEntry(key);
        if (keyObject instanceof OMElement) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((OMElement)keyObject).serialize((OutputStream)baos);
            }
            catch (XMLStreamException ex) {
                String msg = "Unable to serialize registry item '" + key + "' for location '" + location + "'";
                log.error((Object)msg);
                throw new SynapseException(msg, ex);
            }
            InputSource inputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            inputSource.setSystemId("synapse-reg:///" + key);
            return inputSource;
        }
        String msg = "Registry item '" + key + "' for location '" + location + "' is not an OMElement";
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    class Pair {
        private Value location;
        private Value key;

        Pair(Value location, Value key) {
            this.location = location;
            this.key = key;
        }

        public Value getKey() {
            return this.location;
        }

        public Value getValue() {
            return this.key;
        }
    }
}

