/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.resolver;

import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.util.resolver.ResourceMap;
import org.xml.sax.InputSource;

public class CustomWSDLLocator
implements WSDLLocator {
    private static Log log = LogFactory.getLog(CustomWSDLLocator.class);
    private final InputSource baseInputSource;
    private final String baseURI;
    private ResourceMap resourceMap;
    private SynapseConfiguration synCfg;
    private String latestImportURI;

    public CustomWSDLLocator(InputSource baseInputSource, String baseURI) {
        this.baseInputSource = baseInputSource;
        this.baseURI = baseURI;
    }

    public CustomWSDLLocator(InputSource baseInputSource, String baseURI, ResourceMap resourceMap, SynapseConfiguration synCfg) {
        this(baseInputSource, baseURI);
        this.resourceMap = resourceMap;
        this.synCfg = synCfg;
    }

    public InputSource getBaseInputSource() {
        return this.baseInputSource;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public InputSource getImportInputSource(String parentLocation, String relativeLocation) {
        InputSource result = null;
        if (this.resourceMap != null) {
            result = this.resourceMap.resolve(this.synCfg, relativeLocation);
        }
        if (result == null) {
            String location = SynapseConfigUtils.resolveRelativeURI(parentLocation, relativeLocation);
            try {
                result = SynapseConfigUtils.getInputSourceFormURI(new URI(location));
            }
            catch (URISyntaxException e) {
                log.error((Object)("Malformed URI " + location), (Throwable)e);
            }
            this.latestImportURI = location;
        } else {
            this.latestImportURI = relativeLocation;
        }
        return result;
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    public void close() {
    }
}

