/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.resolver;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.util.resolver.ResourceMap;
import org.xml.sax.InputSource;

public class CustomJAXPURIResolver
implements URIResolver {
    private final ResourceMap resourceMap;
    private final SynapseConfiguration synCfg;
    private final MessageContext messageContext;

    public CustomJAXPURIResolver(ResourceMap resourceMap, SynapseConfiguration synCfg, MessageContext messageContext) {
        this.resourceMap = resourceMap;
        this.synCfg = synCfg;
        this.messageContext = messageContext;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        InputSource is;
        StreamSource result = null;
        if (this.resourceMap != null && (is = this.resourceMap.resolve(this.synCfg, href, this.messageContext)) != null) {
            result = new StreamSource(is.getByteStream());
        }
        if (result == null) {
            result = new StreamSource(SynapseConfigUtils.resolveRelativeURI(base, href));
        }
        return result;
    }
}

