/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.logging;

import org.apache.synapse.MessageContext;

public class LoggingUtils {
    private static final String OPEN_BRACKETS = "{";
    private static final String CLOSE_BRACKETS = "}";

    private LoggingUtils() {
    }

    public static String getFormattedLog(MessageContext synCtx, Object msg) {
        Object artifactNameObject = synCtx.getProperty("ARTIFACT_NAME");
        if (artifactNameObject != null) {
            String artifactName = artifactNameObject.toString();
            if (artifactName.startsWith("proxy")) {
                return LoggingUtils.getFormattedLog("proxy", artifactName.substring("proxy".length()), msg);
            }
            if (artifactName.startsWith("api")) {
                return LoggingUtils.getFormattedLog("api", artifactName.substring("api".length()), msg);
            }
            if (artifactName.startsWith("inboundendpoint")) {
                return LoggingUtils.getFormattedLog("inboundendpoint", artifactName.substring("inboundendpoint".length()), msg);
            }
            return LoggingUtils.getFormattedString(artifactName, msg);
        }
        return msg.toString();
    }

    public static String getFormattedLog(String artifactType, Object artifactName, Object msg) {
        String name = artifactName != null ? artifactName.toString() : "";
        return LoggingUtils.getFormattedString(artifactType.concat(":").concat(name), msg);
    }

    private static String getFormattedString(String name, Object msg) {
        String message = msg != null ? msg.toString() : "";
        return OPEN_BRACKETS.concat(name).concat(CLOSE_BRACKETS).concat(" ").concat(message);
    }
}

