/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.synapse.util.concurrent.InboundThreadFactory;
import org.apache.synapse.util.concurrent.SynapseThreadFactory;

public class InboundThreadPool
extends ThreadPoolExecutor {
    public static final int INBOUND_CORE_THREADS = 20;
    public static final int INBOUND_MAX_THREADS = 100;
    public static final int INBOUND_KEEP_ALIVE = 1;
    public static final int INBOUND_THREAD_QLEN = 1;
    public static final String INBOUND_THREAD_GROUP = "inbound-thread-group";
    public static final String INBOUND_THREAD_ID_PREFIX = "InboundWorker";
    public static final String IB_THREAD_CORE = "inbound.threads.core";
    public static final String IB_THREAD_MAX = "inbound.threads.max";

    public InboundThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new InboundThreadFactory(new ThreadGroup(INBOUND_THREAD_GROUP), INBOUND_THREAD_ID_PREFIX));
    }

    public InboundThreadPool() {
        this(20, 100, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public InboundThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, int qlen, String threadGroup, String threadIdPrefix) {
        super(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, qlen > 0 ? new LinkedBlockingQueue<Runnable>(qlen) : new LinkedBlockingQueue(), new SynapseThreadFactory(new ThreadGroup(threadGroup), threadIdPrefix));
    }
}

