/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class InboundThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger count = new AtomicInteger(1);
    private final String namePrefix;

    public InboundThreadFactory(ThreadGroup group, String namePrefix) {
        this.group = group;
        this.namePrefix = namePrefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.namePrefix);
        buffer.append('-');
        buffer.append(this.count.getAndIncrement());
        Thread t = new Thread(this.group, runnable, buffer.toString(), 0L);
        t.setDaemon(false);
        t.setPriority(5);
        return t;
    }
}

