/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.description.AxisDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.SeqContinuationState;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.ResponseState;
import org.apache.synapse.debug.constructs.SynapseMediationFlowPoint;
import org.apache.synapse.mediators.template.TemplateContext;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class MessageHelper {
    private static Log log = LogFactory.getLog(MessageHelper.class);

    public static MessageContext cloneMessageContext(MessageContext synCtx, boolean cloneSoapEnvelope) throws AxisFault {
        return MessageHelper.cloneMessageContext(synCtx, cloneSoapEnvelope, true);
    }

    public static MessageContext cloneMessageContext(MessageContext synCtx, boolean cloneSoapEnvelope, boolean isCloneJson) throws AxisFault {
        return MessageHelper.cloneMessageContext(synCtx, cloneSoapEnvelope, isCloneJson, false, true);
    }

    public static MessageContext cloneMessageContext(MessageContext synCtx, boolean cloneSoapEnvelope, boolean isCloneJson, boolean isAggregate) throws AxisFault {
        return MessageHelper.cloneMessageContext(synCtx, cloneSoapEnvelope, isCloneJson, isAggregate, true);
    }

    public static MessageContext cloneMessageContext(MessageContext synCtx, boolean cloneSoapEnvelope, boolean isCloneJson, boolean isAggregate, boolean isCloneCorrelationId) throws AxisFault {
        Stack functionStack;
        MessageContext newCtx = synCtx.getEnvironment().createMessageContext();
        Axis2MessageContext axis2MC = (Axis2MessageContext)newCtx;
        axis2MC.setAxis2MessageContext(MessageHelper.cloneAxis2MessageContext(((Axis2MessageContext)synCtx).getAxis2MessageContext(), cloneSoapEnvelope, isCloneJson, isAggregate));
        newCtx.setConfiguration(synCtx.getConfiguration());
        newCtx.setEnvironment(synCtx.getEnvironment());
        newCtx.setContextEntries(synCtx.getContextEntries());
        org.apache.axis2.context.MessageContext originalAxis2Ctx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        if (originalAxis2Ctx.getProperty("correlation_id") != null && isCloneCorrelationId) {
            String originalCorrelationId = originalAxis2Ctx.getProperty("correlation_id").toString();
            axis2MC.getAxis2MessageContext().setProperty("correlation_id", (Object)((String)originalCorrelationId + "_" + UUID.randomUUID().toString()));
        }
        newCtx.setProperty("aggregateCorelation", synCtx.getMessageID());
        newCtx.setTo(synCtx.getTo());
        newCtx.setReplyTo(synCtx.getReplyTo());
        newCtx.setSoapAction(synCtx.getSoapAction());
        newCtx.setWSAAction(synCtx.getWSAAction());
        newCtx.setResponse(synCtx.isResponse());
        for (Object o : synCtx.getPropertyKeySet()) {
            if (!(o instanceof String)) continue;
            String strkey = (String)o;
            Object obj = synCtx.getProperty(strkey);
            if (!(obj instanceof String)) {
                if (obj instanceof ArrayList) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deep clone Started for  ArrayList property: " + (String)strkey + "."));
                    }
                    obj = MessageHelper.cloneArrayList((ArrayList)obj);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deep clone Ended for  ArrayList property: " + (String)strkey + "."));
                    }
                } else if (obj instanceof Stack && strkey.equals("_SYNAPSE_FUNCTION_STACK")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Deep clone for Template function stack");
                    }
                    obj = MessageHelper.getClonedTemplateStack((Stack)obj);
                } else if (obj instanceof OMElement) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Deep clone for OMElement");
                    }
                    obj = ((OMElement)obj).cloneOMElement();
                } else if (!(obj instanceof ResponseState) && log.isDebugEnabled()) {
                    log.warn((Object)("Deep clone not happened for property : " + (String)strkey + ". Class type : " + obj.getClass().getName()));
                }
            }
            newCtx.setProperty(strkey, obj);
        }
        Stack<FaultHandler> faultStack = synCtx.getFaultStack();
        if (!faultStack.isEmpty()) {
            ArrayList<FaultHandler> newFaultStack = new ArrayList<FaultHandler>();
            newFaultStack.addAll(faultStack);
            for (FaultHandler faultHandler : newFaultStack) {
                if (faultHandler == null) continue;
                newCtx.pushFaultHandler(faultHandler);
            }
        }
        if ((functionStack = (Stack)synCtx.getProperty("_SYNAPSE_FUNCTION_STACK")) != null) {
            newCtx.setProperty("_SYNAPSE_FUNCTION_STACK", functionStack.clone());
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("Parent's Fault Stack : " + faultStack + " : Child's Fault Stack :" + newCtx.getFaultStack()));
        }
        if (synCtx.isContinuationEnabled()) {
            Stack<ContinuationState> continuationStates = synCtx.getContinuationStateStack();
            newCtx.setContinuationEnabled(true);
            for (ContinuationState continuationState : continuationStates) {
                if (continuationState == null) continue;
                newCtx.pushContinuationState(ContinuationStackManager.getClonedSeqContinuationState((SeqContinuationState)continuationState));
            }
        }
        newCtx.setMessageFlowTracingState(synCtx.getMessageFlowTracingState());
        return newCtx;
    }

    public static MessageContext cloneMessageContext(MessageContext synCtx) throws AxisFault {
        return MessageHelper.cloneMessageContext(synCtx, true);
    }

    @Deprecated
    public static MessageContext cloneMessageContextForAggregateMediator(MessageContext synCtx) throws AxisFault {
        return MessageHelper.cloneMessageContext(synCtx, true, false, true, true);
    }

    public static Stack<TemplateContext> getClonedTemplateStack(Stack<TemplateContext> oriTemplateStack) {
        Stack<TemplateContext> clonedTemplateStack = new Stack<TemplateContext>();
        for (TemplateContext oriTemplateCtx : oriTemplateStack) {
            TemplateContext clonedTemplateCtx = new TemplateContext(oriTemplateCtx.getName(), oriTemplateCtx.getParameters());
            Map oriValueMap = oriTemplateCtx.getMappedValues();
            HashMap clonedValueMap = new HashMap();
            for (Object key : oriValueMap.keySet()) {
                Object value = oriValueMap.get(key);
                if (value instanceof ArrayList) {
                    value = MessageHelper.cloneArrayList((ArrayList)value);
                }
                clonedValueMap.put(key, value);
            }
            clonedTemplateCtx.setMappedValues(clonedValueMap);
            clonedTemplateStack.push(clonedTemplateCtx);
        }
        return clonedTemplateStack;
    }

    public static ArrayList<Object> cloneArrayList(ArrayList<Object> arrayList) {
        ArrayList<Object> newArrayList = null;
        if (arrayList != null) {
            newArrayList = new ArrayList<Object>();
            for (Object obj : arrayList) {
                if (obj instanceof SOAPHeaderBlock) {
                    SOAPFactory fac = (SOAPFactory)((SOAPHeaderBlock)obj).getOMFactory();
                    obj = ((SOAPHeaderBlock)obj).cloneOMElement();
                    try {
                        obj = ElementHelper.toSOAPHeaderBlock((OMElement)((OMElement)obj), (SOAPFactory)fac);
                    }
                    catch (Exception e) {
                        MessageHelper.handleException(e);
                    }
                } else if (obj instanceof SOAPEnvelope) {
                    SOAPEnvelope enve = (SOAPEnvelope)obj;
                    obj = MessageHelper.cloneSOAPEnvelope(enve);
                } else if (obj instanceof OMElement) {
                    obj = ((OMElement)obj).cloneOMElement();
                } else if (log.isDebugEnabled()) {
                    log.error((Object)("Array List deep clone not implemented for Class type : " + obj.getClass().getName()));
                }
                newArrayList.add(obj);
            }
        }
        return newArrayList;
    }

    public static org.apache.axis2.context.MessageContext cloneAxis2MessageContext(org.apache.axis2.context.MessageContext mc, boolean cloneSoapEnvelope) throws AxisFault {
        return MessageHelper.cloneAxis2MessageContext(mc, cloneSoapEnvelope, true);
    }

    public static org.apache.axis2.context.MessageContext cloneAxis2MessageContext(org.apache.axis2.context.MessageContext mc, boolean cloneSoapEnvelope, boolean isCloneJson) throws AxisFault {
        return MessageHelper.cloneAxis2MessageContext(mc, cloneSoapEnvelope, isCloneJson, false);
    }

    public static org.apache.axis2.context.MessageContext cloneAxis2MessageContext(org.apache.axis2.context.MessageContext mc, boolean cloneSoapEnvelope, boolean isCloneJson, boolean isAggregrate) throws AxisFault {
        try {
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)mc, (boolean)false);
        }
        catch (IOException e) {
            MessageHelper.handleException(e);
        }
        catch (XMLStreamException e) {
            MessageHelper.handleException(e);
        }
        org.apache.axis2.context.MessageContext newMC = MessageHelper.clonePartially(mc, isAggregrate);
        if (cloneSoapEnvelope) {
            newMC.setEnvelope(MessageHelper.cloneSOAPEnvelope(mc.getEnvelope()));
        }
        if (isCloneJson) {
            JsonUtil.cloneJsonPayload((org.apache.axis2.context.MessageContext)mc, (org.apache.axis2.context.MessageContext)newMC);
        }
        newMC.setOptions(MessageHelper.cloneOptions(mc.getOptions()));
        newMC.setServiceContext(mc.getServiceContext());
        newMC.setOperationContext(mc.getOperationContext());
        newMC.setAxisMessage(mc.getAxisMessage());
        if (newMC.getAxisMessage() != null) {
            newMC.getAxisMessage().setParent((AxisDescription)mc.getAxisOperation());
        }
        newMC.setAxisService(mc.getAxisService());
        newMC.setTransportIn(mc.getTransportIn());
        newMC.setTransportOut(mc.getTransportOut());
        newMC.setProperty("OutTransportInfo", mc.getProperty("OutTransportInfo"));
        newMC.setProperty("TRANSPORT_HEADERS", (Object)MessageHelper.getClonedTransportHeaders(mc));
        newMC.removeProperty("pass-through.pipe");
        return newMC;
    }

    public static org.apache.axis2.context.MessageContext cloneAxis2MessageContext(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        return MessageHelper.cloneAxis2MessageContext(mc, true);
    }

    @Deprecated
    private static org.apache.axis2.context.MessageContext cloneAxis2MessageContextForAggregate(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        return MessageHelper.cloneAxis2MessageContext(mc, true, false, true);
    }

    public static Map getClonedTransportHeaders(org.apache.axis2.context.MessageContext msgCtx) {
        Map headers = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        AbstractMap clonedHeaders = headers instanceof TreeMap ? new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        }) : new HashMap();
        if (headers != null && !headers.isEmpty()) {
            for (Object o : headers.keySet()) {
                String headerName = (String)o;
                clonedHeaders.put(headerName, headers.get(headerName));
            }
        }
        return clonedHeaders;
    }

    public static org.apache.axis2.context.MessageContext clonePartially(org.apache.axis2.context.MessageContext ori) throws AxisFault {
        return MessageHelper.clonePartially(ori, false);
    }

    public static org.apache.axis2.context.MessageContext clonePartially(org.apache.axis2.context.MessageContext ori, boolean isAggregate) throws AxisFault {
        org.apache.axis2.context.MessageContext newMC = new org.apache.axis2.context.MessageContext();
        newMC.setConfigurationContext(ori.getConfigurationContext());
        newMC.setMessageID(UIDGenerator.generateURNString());
        newMC.setTo(ori.getTo());
        newMC.setSoapAction(ori.getSoapAction());
        newMC.setProperty("CHARACTER_SET_ENCODING", ori.getProperty("CHARACTER_SET_ENCODING"));
        newMC.setProperty("enableMTOM", ori.getProperty("enableMTOM"));
        newMC.setProperty("enableSwA", ori.getProperty("enableSwA"));
        newMC.setProperty("HTTP_METHOD", ori.getProperty("HTTP_METHOD"));
        newMC.setProperty("messageType", ori.getProperty("messageType"));
        newMC.setDoingREST(ori.isDoingREST());
        newMC.setDoingMTOM(ori.isDoingMTOM());
        newMC.setDoingSwA(ori.isDoingSwA());
        Attachments attachments = ori.getAttachmentMap();
        if (attachments != null && attachments.getAllContentIDs().length > 0) {
            String[] cIDs = attachments.getAllContentIDs();
            String soapPart = attachments.getSOAPPartContentID();
            for (String cID : cIDs) {
                if (cID.equals(soapPart)) continue;
                newMC.addAttachment(cID, attachments.getDataHandler(cID));
            }
        }
        Iterator itr = ori.getPropertyNames();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (key == null) continue;
            newMC.setNonReplicableProperty(key, ori.getPropertyNonReplicable(key));
        }
        if (isAggregate) {
            newMC.setServerSide(ori.isServerSide());
        } else {
            newMC.setServerSide(false);
        }
        return newMC;
    }

    @Deprecated
    public static org.apache.axis2.context.MessageContext clonePartiallyForAggregate(org.apache.axis2.context.MessageContext ori) throws AxisFault {
        return MessageHelper.clonePartially(ori, true);
    }

    public static SOAPEnvelope cloneSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPHeader body;
        SOAPFactory fac = "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope newEnvelope = fac.getDefaultEnvelope();
        if (envelope.getHeader() != null) {
            body = envelope.getHeader();
            Iterator childIterator = body.getChildren();
            while (childIterator.hasNext()) {
                Object bodyNs = childIterator.next();
                if (bodyNs instanceof SOAPHeaderBlock) {
                    try {
                        newEnvelope.getHeader().addChild((OMNode)ElementHelper.toSOAPHeaderBlock((OMElement)((OMElement)bodyNs).cloneOMElement(), (SOAPFactory)fac));
                    }
                    catch (Exception e) {
                        MessageHelper.handleException(e);
                    }
                    continue;
                }
                if (!(bodyNs instanceof OMElement)) continue;
                newEnvelope.getHeader().addChild((OMNode)((OMElement)bodyNs).cloneOMElement());
            }
        }
        if (envelope.getBody() != null) {
            if (envelope.getBody().getFirstElement() instanceof SOAPFault && envelope.getBody().hasFault()) {
                SOAPFault fault = envelope.getBody().getFault();
                newEnvelope.getBody().addFault(MessageHelper.cloneSOAPFault(fault));
            } else {
                body = envelope.getBody().cloneOMElement();
                Iterator ns = body.getAllDeclaredNamespaces();
                OMNamespace bodyNs = body.getNamespace();
                String nsUri = bodyNs.getNamespaceURI();
                String nsPrefix = bodyNs.getPrefix();
                while (ns.hasNext()) {
                    OMNamespace namespace = (OMNamespace)ns.next();
                    if (nsUri != null && !nsUri.equals(namespace.getNamespaceURI()) && nsPrefix != null && !nsPrefix.equals(namespace.getPrefix())) {
                        newEnvelope.getBody().declareNamespace(namespace);
                    }
                    ns.remove();
                }
                Iterator attributes = body.getAllAttributes();
                while (attributes.hasNext()) {
                    OMAttribute attrb = (OMAttribute)attributes.next();
                    newEnvelope.getBody().addAttribute(attrb);
                    attributes.remove();
                }
                Iterator itr = body.getChildren();
                while (itr.hasNext()) {
                    OMNode node = (OMNode)itr.next();
                    itr.remove();
                    newEnvelope.getBody().addChild(node);
                }
                Iterator allDeclaredNamespaces = envelope.getAllDeclaredNamespaces();
                while (allDeclaredNamespaces.hasNext()) {
                    newEnvelope.declareNamespace((OMNamespace)allDeclaredNamespaces.next());
                }
            }
        }
        return newEnvelope;
    }

    public static Options cloneOptions(Options options) {
        Options clonedOptions = new Options(options.getParent());
        clonedOptions.setCallTransportCleanup(options.isCallTransportCleanup());
        clonedOptions.setExceptionToBeThrownOnSOAPFault(options.isExceptionToBeThrownOnSOAPFault());
        clonedOptions.setManageSession(options.isManageSession());
        clonedOptions.setSoapVersionURI(options.getSoapVersionURI());
        clonedOptions.setTimeOutInMilliSeconds(options.getTimeOutInMilliSeconds());
        clonedOptions.setUseSeparateListener(options.isUseSeparateListener());
        clonedOptions.setListener(options.getListener());
        clonedOptions.setTransportIn(options.getTransportIn());
        clonedOptions.setTransportInProtocol(options.getTransportInProtocol());
        clonedOptions.setTransportOut(options.getTransportOut());
        clonedOptions.setUserName(options.getUserName());
        clonedOptions.setPassword(options.getPassword());
        for (Object o : options.getProperties().keySet()) {
            String key = (String)o;
            clonedOptions.setProperty(key, options.getProperty(key));
        }
        return clonedOptions;
    }

    public static SOAPEnvelope removeAddressingHeaders(org.apache.axis2.context.MessageContext axisMsgCtx) {
        SOAPEnvelope env = axisMsgCtx.getEnvelope();
        SOAPHeader soapHeader = env.getHeader();
        if (soapHeader != null) {
            ArrayList addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            if (addressingHeaders != null && addressingHeaders.size() != 0) {
                MessageHelper.detachAddressingInformation(addressingHeaders);
            } else {
                addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://www.w3.org/2005/08/addressing");
                if (addressingHeaders != null && addressingHeaders.size() != 0) {
                    MessageHelper.detachAddressingInformation(addressingHeaders);
                }
            }
        }
        return env;
    }

    private static void detachAddressingInformation(ArrayList headerInformation) {
        for (Object o : headerInformation) {
            OMElement om;
            OMNamespace ns;
            if (o instanceof SOAPHeaderBlock) {
                SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                headerBlock.detach();
                continue;
            }
            if (!(o instanceof OMElement) || (ns = (om = (OMElement)o).getNamespace()) == null || !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns.getNamespaceURI()) && !"http://www.w3.org/2005/08/addressing".equals(ns.getNamespaceURI())) continue;
            om.detach();
        }
    }

    public static Policy getPolicy(MessageContext synCtx, String propertyKey) {
        Object property = synCtx.getEntry(propertyKey);
        if (property != null && property instanceof OMElement) {
            return PolicyEngine.getPolicy((OMElement)((OMElement)property));
        }
        MessageHelper.handleException("Cannot locate policy from the property : " + propertyKey);
        return null;
    }

    public static SOAPFault cloneSOAPFault(SOAPFault fault) {
        int soapVersion;
        SOAPFactory fac;
        boolean SOAP_11 = true;
        int SOAP_12 = 2;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(fault.getNamespace().getNamespaceURI())) {
            fac = OMAbstractFactory.getSOAP11Factory();
            soapVersion = 1;
        } else {
            fac = OMAbstractFactory.getSOAP12Factory();
            soapVersion = 2;
        }
        SOAPFault newFault = fac.createSOAPFault();
        SOAPFaultCode code = fac.createSOAPFaultCode();
        SOAPFaultReason reason = fac.createSOAPFaultReason();
        switch (soapVersion) {
            case 1: {
                code.setText(fault.getCode().getTextAsQName());
                reason.setText(fault.getReason().getText());
                break;
            }
            case 2: {
                SOAPFaultValue value = fac.createSOAPFaultValue(code);
                value.setText(fault.getCode().getTextAsQName());
                for (Object obj : fault.getReason().getAllSoapTexts()) {
                    SOAPFaultText text = fac.createSOAPFaultText();
                    text.setText(((SOAPFaultText)obj).getText());
                    reason.addSOAPText(text);
                }
                break;
            }
        }
        newFault.setCode(code);
        newFault.setReason(reason);
        if (fault.getNode() != null) {
            SOAPFaultNode soapfaultNode = fac.createSOAPFaultNode();
            soapfaultNode.setNodeValue(fault.getNode().getNodeValue());
            newFault.setNode(soapfaultNode);
        }
        if (fault.getRole() != null) {
            SOAPFaultRole soapFaultRole = fac.createSOAPFaultRole();
            soapFaultRole.setRoleValue(fault.getRole().getRoleValue());
            newFault.setRole(soapFaultRole);
        }
        if (fault.getDetail() != null) {
            SOAPFaultDetail soapFaultDetail = fac.createSOAPFaultDetail();
            Iterator itr = fault.getDetail().getAllDetailEntries();
            while (itr.hasNext()) {
                Object element = itr.next();
                if (!(element instanceof OMElement)) continue;
                soapFaultDetail.addDetailEntry(((OMElement)element).cloneOMElement());
            }
            newFault.setDetail(soapFaultDetail);
        }
        return newFault;
    }

    public static void removeProcessedHeaders(org.apache.axis2.context.MessageContext axisMsgCtx, boolean preserveAddressing) {
        SOAPEnvelope env = axisMsgCtx.getEnvelope();
        SOAPHeader soapHeader = env.getHeader();
        if (soapHeader != null) {
            Iterator it = soapHeader.getChildElements();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SOAPHeaderBlock)) continue;
                SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                if (!preserveAddressing) {
                    if (!headerBlock.isProcessed()) continue;
                    headerBlock.detach();
                    continue;
                }
                if (MessageHelper.isAddressingHeader(headerBlock) || !headerBlock.isProcessed()) continue;
                headerBlock.detach();
            }
        }
    }

    private static boolean isAddressingHeader(SOAPHeaderBlock headerBlock) {
        OMNamespace ns = headerBlock.getNamespace();
        return ns != null && ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns.getNamespaceURI()) || "http://www.w3.org/2005/08/addressing".equals(ns.getNamespaceURI()));
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(Exception e) {
        log.error((Object)e);
        throw new SynapseException(e);
    }

    public static void setWireLogHolderProperties(MessageContext synCtx, boolean isBreakPoint, SynapseMediationFlowPoint mediationFlowPoint) {
        if (isBreakPoint) {
            String mediatorId = synCtx.getEnvironment().getSynapseDebugManager().createDebugMediationFlowPointJSONForWireLogs(mediationFlowPoint).toString();
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("synapse.wire.log.mediator.id", (Object)mediatorId);
        } else {
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("synapse.wire.log.mediator.id", (Object)"{ \"dummyID\" : \"dummy\"}");
        }
    }

    public static String maskURLPassword(String url) {
        Matcher urlMatcher = SynapseConstants.URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            Matcher pwdMatcher = SynapseConstants.PASSWORD_PATTERN.matcher(url);
            String maskUrl = pwdMatcher.replaceFirst("\":***@\"");
            return maskUrl;
        }
        return url;
    }
}

