/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import org.apache.synapse.JSONObjectExtensionException;

public class JSONMergeUtils {
    public static void extendJSONObject(JsonObject destinationObject, ConflictStrategy conflictResolutionStrategy, JsonObject ... jsonObjects) throws JSONObjectExtensionException {
        for (JsonObject obj : jsonObjects) {
            JSONMergeUtils.extendJSONObject(destinationObject, obj, conflictResolutionStrategy);
        }
    }

    private static void extendJSONObject(JsonObject leftObj, JsonObject rightObj, ConflictStrategy conflictStrategy) throws JSONObjectExtensionException {
        for (Map.Entry rightEntry : rightObj.entrySet()) {
            String rightKey = (String)rightEntry.getKey();
            JsonElement rightVal = (JsonElement)rightEntry.getValue();
            if (leftObj.has(rightKey)) {
                JsonElement leftVal = leftObj.get(rightKey);
                if (leftVal.isJsonArray() && rightVal.isJsonArray()) {
                    JsonArray leftArr = leftVal.getAsJsonArray();
                    JsonArray rightArr = rightVal.getAsJsonArray();
                    for (int i = 0; i < rightArr.size(); ++i) {
                        leftArr.add(rightArr.get(i));
                    }
                    continue;
                }
                if (leftVal.isJsonObject() && rightVal.isJsonObject()) {
                    JSONMergeUtils.extendJSONObject(leftVal.getAsJsonObject(), rightVal.getAsJsonObject(), conflictStrategy);
                    continue;
                }
                JSONMergeUtils.handleMergeConflict(rightKey, leftObj, leftVal, rightVal, conflictStrategy);
                continue;
            }
            leftObj.add(rightKey, rightVal);
        }
    }

    public static JsonObject extendJSONObject(JsonObject sourceObj, JsonObject targetObj) {
        for (Map.Entry sourceEntry : sourceObj.entrySet()) {
            String key = (String)sourceEntry.getKey();
            JsonElement value = (JsonElement)sourceEntry.getValue();
            if (!targetObj.has(key)) {
                if (value.isJsonNull()) continue;
                targetObj.add(key, value);
                continue;
            }
            if (!value.isJsonNull()) {
                if (value.isJsonObject()) {
                    JSONMergeUtils.extendJSONObject(value.getAsJsonObject(), targetObj.get(key).getAsJsonObject());
                    continue;
                }
                targetObj.add(key, value);
                continue;
            }
            targetObj.remove(key);
        }
        return targetObj;
    }

    private static void handleMergeConflict(String key, JsonObject leftObject, JsonElement leftValue, JsonElement rightValue, ConflictStrategy conflictStrategy) throws JSONObjectExtensionException, UnsupportedOperationException {
        switch (conflictStrategy) {
            case PREFER_FIRST_OBJECT: {
                break;
            }
            case PREFER_SECOND_OBJECT: {
                leftObject.add(key, rightValue);
                break;
            }
            case MERGE_INTO_ARRAY: {
                if (leftValue.isJsonArray()) {
                    leftValue.getAsJsonArray().add(rightValue);
                    break;
                }
                JsonElement tempElement = leftValue;
                leftValue = new JsonArray();
                leftValue.getAsJsonArray().add(tempElement);
                leftValue.getAsJsonArray().add(rightValue);
                leftObject.add(key, leftValue);
                break;
            }
            case PREFER_NON_NULL: {
                if (!leftValue.isJsonNull() || rightValue.isJsonNull()) break;
                leftObject.add(key, rightValue);
                break;
            }
            case THROW_EXCEPTION: {
                throw new JSONObjectExtensionException("Key " + key + " exists in both objects and the conflict resolution strategy is " + (Object)((Object)conflictStrategy));
            }
            default: {
                throw new UnsupportedOperationException("The conflict strategy " + (Object)((Object)conflictStrategy) + " is unknown and cannot be processed");
            }
        }
    }

    public static JsonObject getJsonObject(String jsonString) {
        JsonObject jsonObject = new JsonObject();
        JsonParser parser = new JsonParser();
        if (jsonString != null) {
            jsonObject = parser.parse(jsonString).getAsJsonObject();
        }
        return jsonObject;
    }

    public static JsonArray getJsonArray(String jsonString) {
        JsonArray jsonArray = new JsonArray();
        JsonParser parser = new JsonParser();
        try {
            jsonArray = parser.parse(jsonString).getAsJsonArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonArray;
    }

    public static int count(JsonArray array, JsonElement element) {
        int count = 0;
        for (JsonElement currentElement : array) {
            if (currentElement.isJsonPrimitive() && currentElement.equals(element)) {
                ++count;
            }
            if (!currentElement.isJsonObject() && !currentElement.isJsonArray() || !currentElement.toString().equals(element.toString())) continue;
            ++count;
        }
        return count;
    }

    public static enum ConflictStrategy {
        THROW_EXCEPTION,
        PREFER_FIRST_OBJECT,
        PREFER_SECOND_OBJECT,
        MERGE_INTO_ARRAY,
        PREFER_NON_NULL;

    }
}

