/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public final class InlineExpressionUtil {
    private static final String EXPRESSION_JSON_EVAL = "json-eval(";
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("(\\{[^\\s\"][^,<>\n}\\]]*})");

    private InlineExpressionUtil() {
    }

    public static boolean checkForInlineExpressions(String inlineText) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(inlineText);
        return matcher.find();
    }

    public static String replaceDynamicValues(MessageContext messageContext, String inlineText) {
        inlineText = InlineExpressionUtil.replaceValue(messageContext, inlineText, true);
        return inlineText;
    }

    private static String replaceValue(MessageContext messageContext, String text, boolean isInline) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(text);
        while (matcher.find()) {
            String matchSeq = matcher.group();
            String value = InlineExpressionUtil.getDynamicValue(messageContext, matchSeq.substring(1, matchSeq.length() - 1));
            if (value == null) {
                value = "";
            }
            if (isInline && (value.isEmpty() && matchSeq.contains(EXPRESSION_JSON_EVAL) || !InlineExpressionUtil.isValidXML(value) && !InlineExpressionUtil.isValidJson(value))) {
                value = "\"" + value + "\"";
            }
            text = text.replace(matchSeq, value);
        }
        return text;
    }

    public static String replaceDynamicValuesForJSONPath(MessageContext messageContext, String inlineText) {
        if ((inlineText = InlineExpressionUtil.replaceValue(messageContext, inlineText, false)).startsWith(EXPRESSION_JSON_EVAL)) {
            inlineText = inlineText.substring(10, inlineText.length() - 1);
        }
        return inlineText;
    }

    public static String getDynamicValue(MessageContext messageContext, String expression) {
        SynapsePath path;
        try {
            path = expression.startsWith(EXPRESSION_JSON_EVAL) ? new SynapseJsonPath(expression.substring(10, expression.length() - 1)) : new SynapseXPath(expression);
        }
        catch (JaxenException e) {
            throw new SynapseException("Invalid expression for inline source format.");
        }
        return ((SynapsePath)path).stringValueOf(messageContext);
    }

    private static boolean isValidJson(String stringToValidate) {
        JsonParser parser = new JsonParser();
        boolean isValidJson = true;
        try {
            JsonElement element = parser.parse(stringToValidate);
            if (!(element instanceof JsonObject || element instanceof JsonArray || element instanceof JsonPrimitive || "null".equalsIgnoreCase(stringToValidate))) {
                isValidJson = false;
            }
        }
        catch (JsonSyntaxException ex) {
            isValidJson = false;
        }
        return isValidJson;
    }

    private static boolean isValidXML(String stringToValidate) {
        try {
            AXIOMUtil.stringToOM((String)stringToValidate);
            return true;
        }
        catch (XMLStreamException | OMException throwable) {
            return false;
        }
    }
}

