/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.IOException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CustomNTLMAuthScheme
implements AuthScheme {
    private static final Log logger = LogFactory.getLog(CustomNTLMAuthScheme.class);
    private String ntlmChallenge = null;
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private int state;

    public CustomNTLMAuthScheme() {
        this.state = 0;
    }

    public CustomNTLMAuthScheme(String challenge) throws MalformedChallengeException {
        this.processChallenge(challenge);
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String s;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[CustomNTLMAuthScheme] processChallenge Invoked.");
        }
        if (!(s = AuthChallengeParser.extractScheme((String)challenge)).equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("[CustomNTLMAuthScheme] Invalid NTLM challenge: " + challenge);
        }
        int i = challenge.indexOf(32);
        if (i != -1) {
            s = challenge.substring(i, challenge.length());
            this.ntlmChallenge = s.trim();
            this.state = 3;
        } else {
            this.ntlmChallenge = "";
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public String getRealm() {
        return null;
    }

    public String getID() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public static String authenticate(NTCredentials credentials, String challenge) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    public static String authenticate(NTCredentials credentials, String challenge, String charset) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    public abstract String getNTLMVersion();

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[CustomNTLMAuthScheme] NTLM Scheme Authentication Method Invoked.");
        }
        if (this.state == 0) {
            throw new IllegalStateException("[CustomNTLMAuthScheme] NTLM authentication process has not been initiated");
        }
        String ntlmVersion = this.getNTLMVersion();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[CustomNTLMAuthScheme] The NTLM version going to use is: " + ntlmVersion));
        }
        int flags = 0;
        if (ntlmVersion.toUpperCase().equals("V1")) {
            flags = 512;
        } else if (ntlmVersion.toUpperCase().equals("V2")) {
            flags = 524288;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"[CustomNTLMAuthScheme] NTLM Version not specified.");
        }
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("[CustomNTLMAuthScheme] Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        byte[] msgBytes = null;
        String response = null;
        if (this.state == 1) {
            Type1Message type1Message = new Type1Message(flags, ntcredentials.getDomain(), ntcredentials.getHost());
            msgBytes = type1Message.toByteArray();
            this.state = 2;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[CustomNTLMAuthScheme] Type1Message Generated.");
            }
        } else if (this.state == 3) {
            Type2Message type2Message;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[CustomNTLMAuthScheme] Type2Message Received.");
            }
            try {
                type2Message = new Type2Message(jcifs.util.Base64.decode((String)this.ntlmChallenge));
            }
            catch (IOException e) {
                throw new RuntimeException("[CustomNTLMAuthScheme] Invalid Type2 message", e);
            }
            Type3Message type3Message = new Type3Message(type2Message, ntcredentials.getPassword(), ntcredentials.getDomain(), ntcredentials.getUserName(), ntcredentials.getHost(), flags);
            msgBytes = type3Message.toByteArray();
            this.state = 4;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[CustomNTLMAuthScheme] Type3Message Generated.");
            }
        } else {
            throw new RuntimeException("[CustomNTLMAuthScheme] Failed to Authenticate");
        }
        response = EncodingUtil.getAsciiString((byte[])Base64.encodeBase64((byte[])msgBytes));
        return "NTLM " + response;
    }
}

