/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessReplicator;

public class ConcurrencyThrottlingUtils {
    private static final Log log = LogFactory.getLog(ConcurrencyThrottlingUtils.class);

    public static void decrementConcurrencyThrottleAccessController(MessageContext synCtx) {
        Boolean isConcurrencyThrottleEnabled = (Boolean)synCtx.getProperty("synapse.concurrency.throttle");
        if (isConcurrencyThrottleEnabled != null && isConcurrencyThrottleEnabled.booleanValue()) {
            ConcurrentAccessController concurrentAccessController = (ConcurrentAccessController)synCtx.getProperty("synapse.concurrent.access.controller");
            int available = concurrentAccessController.incrementAndGet();
            int concurrentLimit = concurrentAccessController.getLimit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of" + concurrentLimit + " connections"));
            }
            ConcurrentAccessReplicator concurrentAccessReplicator = (ConcurrentAccessReplicator)synCtx.getProperty("synapse.concurrent.access.replicator");
            String throttleKey = (String)synCtx.getProperty("synapse.concurrency.throttle.key");
            if (concurrentAccessReplicator != null) {
                concurrentAccessReplicator.replicate(throttleKey, Boolean.valueOf(true));
            }
            synCtx.setProperty("synapse.concurrency.throttle", false);
        }
    }
}

