/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.MediatorLog;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.jaxen.JaxenException;

public class CallMediatorEnrichUtil {
    public static final String CUSTOM = "custom";
    public static final String PROPERTY = "property";
    public static final String ENVELOPE = "envelope";
    public static final String BODY = "body";
    public static final String INLINE = "inline";
    public static final String JSON_TYPE = "application/json";
    public static final String TEXT_TYPE = "text/plain";
    public static final Log log = LogFactory.getLog(CallMediatorEnrichUtil.class);
    private static final QName TEXT_ELEMENT = new QName("http://ws.apache.org/commons/ns/payload", "text");

    public static int convertTypeToInt(String type) {
        if (type.equals(ENVELOPE)) {
            return 1;
        }
        if (type.equals(BODY)) {
            return 2;
        }
        if (type.equals(PROPERTY)) {
            return 3;
        }
        if (type.equals(CUSTOM)) {
            return 0;
        }
        if (type.equals(INLINE)) {
            return 4;
        }
        return -1;
    }

    public static void doEnrich(MessageContext synCtx, Source source, Target target, String sourceContentType) {
        block28: {
            Object sourceProperty = synCtx.getProperty(source.getProperty());
            JsonParser jsonParser = new JsonParser();
            JsonElement sourcePropertyJson = CallMediatorEnrichUtil.getJsonElement(sourceProperty, jsonParser);
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            if (JSON_TYPE.equals(sourceContentType)) {
                try {
                    JsonElement sourceNode = source.evaluateJson(synCtx, CallMediatorEnrichUtil.getLog(synCtx), sourcePropertyJson);
                    if (sourceNode == null) {
                        CallMediatorEnrichUtil.handleException("Failed to get the source for Enriching : ", synCtx);
                        break block28;
                    }
                    target.insertJson(synCtx, sourceNode, CallMediatorEnrichUtil.getLog(synCtx));
                }
                catch (JaxenException e) {
                    CallMediatorEnrichUtil.handleException("Failed to get the source for Enriching", (Exception)((Object)e), synCtx);
                }
            } else if (TEXT_TYPE.equals(sourceContentType)) {
                String payload = null;
                if (source.getSourceType() == 0) {
                    try {
                        ArrayList<OMNode> sourceNodeList = source.evaluate(synCtx, CallMediatorEnrichUtil.getLog(synCtx));
                        if (sourceNodeList.get(0) instanceof OMText) {
                            payload = ((OMText)sourceNodeList.get(0)).getText();
                            CallMediatorEnrichUtil.enrichTextToBody(axis2MessageContext, payload);
                            break block28;
                        }
                        CallMediatorEnrichUtil.handleException("Custum path value must be a string for text/plain", synCtx);
                    }
                    catch (JaxenException e) {
                        CallMediatorEnrichUtil.handleException("Failed to get the source for Enriching", (Exception)((Object)e), synCtx);
                    }
                } else if (source.getSourceType() == 3) {
                    Object sourcePropertyValue = synCtx.getProperty(source.getProperty());
                    if (sourcePropertyValue instanceof String) {
                        CallMediatorEnrichUtil.enrichTextToBody(axis2MessageContext, (String)sourcePropertyValue);
                    } else {
                        CallMediatorEnrichUtil.handleException("Property value must be a string for text/plain", synCtx);
                    }
                } else if (source.getSourceType() == 4) {
                    if (source.getInlineOMNode() instanceof OMText) {
                        payload = ((OMTextImpl)source.getInlineOMNode()).getText();
                        CallMediatorEnrichUtil.enrichTextToBody(axis2MessageContext, payload);
                    } else {
                        CallMediatorEnrichUtil.handleException("Inline value must be a string for text/plain", synCtx);
                    }
                } else {
                    String textValue = null;
                    try {
                        ArrayList<OMNode> sourceNodeList = source.evaluate(synCtx, CallMediatorEnrichUtil.getLog(synCtx));
                        textValue = ((OMElement)sourceNodeList.get(0)).getText();
                    }
                    catch (JaxenException e) {
                        CallMediatorEnrichUtil.handleException("Failed to get the source for Enriching", (Exception)((Object)e), synCtx);
                    }
                    if (textValue != null) {
                        synCtx.setProperty(target.getProperty(), textValue);
                    } else {
                        CallMediatorEnrichUtil.handleException("text/plain must contain a text value", synCtx);
                    }
                }
            } else {
                try {
                    ArrayList<OMNode> sourceNodeList = source.evaluate(synCtx, CallMediatorEnrichUtil.getLog(synCtx));
                    if (sourceNodeList == null) {
                        CallMediatorEnrichUtil.handleException("Failed to get the source for Enriching : ", synCtx);
                    } else {
                        target.insert(synCtx, sourceNodeList, CallMediatorEnrichUtil.getLog(synCtx));
                    }
                }
                catch (JaxenException e) {
                    CallMediatorEnrichUtil.handleException("Failed to get the source for Enriching", (Exception)((Object)e), synCtx);
                }
            }
        }
    }

    public static void enrichTextToBody(org.apache.axis2.context.MessageContext axis2MessageContext, String content) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement textElement = factory.createOMElement(TEXT_ELEMENT);
        if (content == null) {
            content = "";
        }
        textElement.setText(content);
        SOAPEnvelope env = axis2MessageContext.getEnvelope();
        SOAPBody body = env.getBody();
        OMElement e = body.getFirstElement();
        e.insertSiblingBefore((OMNode)textElement);
        e.detach();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonElement getJsonElement(Object sourceProperty, JsonParser jsonParser) {
        JsonElement sourcePropertyJson = null;
        if (sourceProperty instanceof JsonElement) {
            return (JsonElement)sourceProperty;
        }
        if (sourceProperty instanceof OMElement) return sourcePropertyJson;
        if (sourceProperty instanceof ArrayList) {
            Iterator iterator = ((ArrayList)sourceProperty).iterator();
            while (iterator.hasNext()) {
                Object node = iterator.next();
                if (node instanceof OMText) {
                    String propertyString = ((OMTextImpl)node).getText();
                    try {
                        sourcePropertyJson = jsonParser.parse(propertyString);
                        if (sourcePropertyJson instanceof JsonObject || sourcePropertyJson instanceof JsonArray) continue;
                        return sourcePropertyJson;
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        continue;
                    }
                }
                if (node instanceof OMElement) return sourcePropertyJson;
            }
            return sourcePropertyJson;
        }
        if (!(sourceProperty instanceof String)) return sourcePropertyJson;
        try {
            sourcePropertyJson = jsonParser.parse((String)sourceProperty);
            if (sourcePropertyJson instanceof JsonObject) return sourcePropertyJson;
            if (sourcePropertyJson instanceof JsonArray) return sourcePropertyJson;
            if (sourcePropertyJson instanceof JsonPrimitive) return sourcePropertyJson;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return sourcePropertyJson;
    }

    public static void preservetransportHeaders(MessageContext synMsgCtx, Map originalTransportHeaders) {
        ((Axis2MessageContext)synMsgCtx).getAxis2MessageContext().removeProperty("TRANSPORT_HEADERS");
        ((Axis2MessageContext)synMsgCtx).getAxis2MessageContext().setProperty("TRANSPORT_HEADERS", (Object)originalTransportHeaders);
    }

    public static void setContentType(MessageContext synCtx, String targetMessageType, String targetContentType) {
        org.apache.axis2.context.MessageContext a2mc = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        a2mc.setProperty("messageType", (Object)targetMessageType);
        a2mc.setProperty("ContentType", (Object)targetContentType);
        CallMediatorEnrichUtil.handleTransportHeaders(targetContentType, a2mc);
    }

    public static void handleTransportHeaders(Object resultValue, org.apache.axis2.context.MessageContext axis2MessageCtx) {
        Object o = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
        Map headers = (Map)o;
        if (headers != null) {
            headers.remove("Content-Type");
            headers.put("Content-Type", resultValue);
        }
    }

    public static void buildMessage(MessageContext synCtx) {
        try {
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
        }
        catch (Exception e) {
            CallMediatorEnrichUtil.handleException("Error while building message. " + e.getMessage(), e, synCtx);
        }
    }

    public static Source createSourceWithProperty(String propertyName) {
        Source source = new Source();
        source.setSourceType(CallMediatorEnrichUtil.convertTypeToInt(PROPERTY));
        source.setProperty(propertyName);
        source.setClone(false);
        return source;
    }

    public static Source createSourceWithBody() {
        Source source = new Source();
        source.setClone(false);
        source.setSourceType(CallMediatorEnrichUtil.convertTypeToInt(BODY));
        return source;
    }

    public static Target createTargetWithProperty(String propertyName) {
        Target target = new Target();
        target.setTargetType(CallMediatorEnrichUtil.convertTypeToInt(PROPERTY));
        target.setProperty(propertyName);
        target.setAction("replace");
        return target;
    }

    public static Target createTargetWithBody() {
        Target target = new Target();
        target.setAction("replace");
        target.setTargetType(CallMediatorEnrichUtil.convertTypeToInt(BODY));
        return target;
    }

    public static void handleException(String msg, Exception e, MessageContext msgContext) {
        log.error((Object)msg, (Throwable)e);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg, (Throwable)e);
        }
        throw new SynapseException(msg, e);
    }

    public static void handleException(String msg, MessageContext msgContext) {
        log.error((Object)msg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg);
        }
        throw new SynapseException(msg);
    }

    public static SynapseLog getLog(MessageContext synCtx) {
        return new MediatorLog(log, false, synCtx);
    }
}

