/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.unittest.TestMediationRegistryEntryImpl;
import org.apache.synapse.unittest.testcase.data.classes.RegistryResource;
import org.apache.synapse.util.SynapseBinaryDataSource;

public class UnitTestMockRegistry
extends AbstractRegistry {
    private static final Log log = LogFactory.getLog(UnitTestMockRegistry.class);
    protected final Properties properties = new Properties();
    private Map<String, RegistryResource> testMockRegistry = new HashMap<String, RegistryResource>();
    private static final String LOCAL_REGISTRY_PATH = "/_system/local";
    private static final String CONFIGURATION_REGISTRY_PATH = "/_system/config";
    private static final String GOVERNANCE_REGISTRY_PATH = "/_system/governance";
    private static final String FILE = "http://wso2.org/projects/esb/registry/types/file";
    private static UnitTestMockRegistry initializeRegistry = new UnitTestMockRegistry();

    public static synchronized UnitTestMockRegistry getInstance() {
        return initializeRegistry;
    }

    public void addResource(String key, RegistryResource resource) {
        this.testMockRegistry.put(key, resource);
    }

    public void clearResources() {
        this.testMockRegistry.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMNode lookup(String key) {
        String resourcePath;
        if (key == null) {
            this.handleException("Resource cannot be found.");
        }
        if (key.isEmpty()) {
            this.handleException("Resource cannot be empty");
        }
        if ((resourcePath = this.getAbsolutePathToRegistry(key)) != null && this.testMockRegistry.containsKey(resourcePath)) {
            RegistryResource resource = this.testMockRegistry.get(resourcePath);
            String sourceOfResource = resource.getArtifact();
            OMNode omNode = null;
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(sourceOfResource.getBytes());
                try {
                    XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                    StAXOMBuilder builder = new StAXOMBuilder(parser);
                    omNode = builder.getDocumentElement();
                }
                catch (OMException ignored) {
                    omNode = this.readNonXML(resource);
                }
                catch (XMLStreamException ignored) {
                    omNode = this.readNonXML(resource);
                }
                catch (Exception e) {
                    log.error((Object)("Error while reading the resource '" + key + "'"), (Throwable)e);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing the input stream", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Creating OMNode from registry resource artifact failed", (Throwable)e);
            }
            return omNode;
        }
        return null;
    }

    private String getAbsolutePathToRegistry(String key) {
        String resourcePath;
        if (!key.contains(":")) {
            return key;
        }
        String[] entryArray = key.split(":");
        String entryType = entryArray[0];
        String entryPath = entryArray[1];
        if (!entryPath.startsWith("/")) {
            entryPath = "/" + entryPath;
        }
        if (entryType.equals("local")) {
            resourcePath = LOCAL_REGISTRY_PATH + entryPath;
        } else if (entryType.equals("conf")) {
            resourcePath = CONFIGURATION_REGISTRY_PATH + entryPath;
        } else if (entryType.equals("gov")) {
            resourcePath = GOVERNANCE_REGISTRY_PATH + entryPath;
        } else {
            return null;
        }
        return resourcePath;
    }

    @Override
    public Properties getResourceProperties(String entryKey) {
        Properties propertySet = new Properties();
        String filePathAsKey = entryKey.substring(0, entryKey.length() - 1) + ".properties";
        String resourcePath = this.getAbsolutePathToRegistry(filePathAsKey);
        boolean isFoundPropertyFile = false;
        if (resourcePath != null && this.testMockRegistry.containsKey(resourcePath)) {
            isFoundPropertyFile = true;
        } else {
            filePathAsKey = entryKey.substring(0, entryKey.length() - 1);
            resourcePath = this.getAbsolutePathToRegistry(filePathAsKey);
            if (resourcePath != null && this.testMockRegistry.containsKey(resourcePath)) {
                isFoundPropertyFile = true;
            }
        }
        if (!isFoundPropertyFile) {
            return null;
        }
        RegistryResource resource = this.testMockRegistry.get(resourcePath);
        String sourceOfResource = resource.getArtifact().trim();
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(sourceOfResource.getBytes(StandardCharsets.UTF_8));
            propertySet.load(input);
        }
        catch (IOException e) {
            log.error((Object)"Error in loading properties from registry resource", (Throwable)e);
        }
        return propertySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OMNode readNonXML(RegistryResource resource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"The resource at the specified path does not contain well-formed XML - Processing as text");
        }
        if (resource != null) {
            if (resource.getMediaType() == null || resource.getMediaType().equals("text/plain")) {
                return OMAbstractFactory.getOMFactory().createOMText(resource.getArtifact());
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getArtifact().getBytes());
            try {
                OMFactory omFactory = OMAbstractFactory.getOMFactory();
                OMText oMText = omFactory.createOMText((Object)new DataHandler((DataSource)new SynapseBinaryDataSource(inputStream, resource.getMediaType())), true);
                return oMText;
            }
            catch (IOException e) {
                log.error((Object)"Error while getting a stream from resource content ", (Throwable)e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the input stream", (Throwable)e);
                }
            }
        }
        return null;
    }

    private void handleException(String msg) {
        throw new SynapseException(msg);
    }

    @Override
    public RegistryEntry getRegistryEntry(String key) {
        TestMediationRegistryEntryImpl entryEmbedded = new TestMediationRegistryEntryImpl();
        String resourcePath = this.getAbsolutePathToRegistry(key);
        RegistryResource resource = this.testMockRegistry.get(resourcePath);
        if (resourcePath != null && this.testMockRegistry.containsKey(resourcePath)) {
            String resourceName = resource.getRegistryPath() + resource.getRegistryResourceName();
            Date date = new Date();
            long timestamp = date.getTime();
            entryEmbedded.setKey(key);
            entryEmbedded.setName(resourceName);
            entryEmbedded.setType(FILE);
            entryEmbedded.setDescription("Resource at : " + resourceName);
            entryEmbedded.setLastModified(timestamp);
            entryEmbedded.setVersion(timestamp);
            entryEmbedded.setCachableDuration(15000L);
            return entryEmbedded;
        }
        return null;
    }

    @Override
    public OMNode lookupFormat(String key) {
        return null;
    }

    @Override
    public RegistryEntry[] getChildren(RegistryEntry entry) {
        return new RegistryEntry[0];
    }

    @Override
    public RegistryEntry[] getDescendants(RegistryEntry entry) {
        return new RegistryEntry[0];
    }

    @Override
    public void delete(String path) {
    }

    @Override
    public void newResource(String path, boolean isDirectory) {
    }

    @Override
    public void newNonEmptyResource(String path, boolean isDirectory, String contentType, String content, String propertyName) {
    }

    @Override
    public void updateResource(String path, Object value) {
    }

    @Override
    public void updateRegistryEntry(RegistryEntry entry) {
    }

    @Override
    public boolean isResourceExists(String path) {
        return false;
    }
}

