/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.http.HttpResponse;
import org.apache.log4j.Logger;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.deployers.APIDeployer;
import org.apache.synapse.deployers.EndpointDeployer;
import org.apache.synapse.deployers.LocalEntryDeployer;
import org.apache.synapse.deployers.ProxyServiceDeployer;
import org.apache.synapse.deployers.SequenceDeployer;
import org.apache.synapse.deployers.TemplateDeployer;
import org.apache.synapse.unittest.Assertor;
import org.apache.synapse.unittest.CommonUtils;
import org.apache.synapse.unittest.ConfigurationDeployer;
import org.apache.synapse.unittest.TestCasesMediator;
import org.apache.synapse.unittest.UnitTestingExecutor;
import org.apache.synapse.unittest.testcase.data.classes.SynapseTestCase;
import org.apache.synapse.unittest.testcase.data.classes.TestCase;
import org.apache.synapse.unittest.testcase.data.classes.TestCaseSummary;
import org.apache.synapse.unittest.testcase.data.classes.TestSuiteSummary;

class TestingAgent {
    private Logger log = Logger.getLogger((String)TestingAgent.class.getName());
    private SynapseConfiguration synapseConfiguration = new SynapseConfiguration();
    private String mainTestArtifactType = null;
    private String proxyTransportMethod = null;
    private String key = null;
    private OMElement artifactNode = null;
    private String exception = null;
    private Map<String, String> deploymentStats = new HashMap<String, String>();

    TestingAgent() {
    }

    Map.Entry<Boolean, TestSuiteSummary> processTestArtifact(SynapseTestCase synapseTestCase, TestSuiteSummary testSuiteSummary) {
        this.mainTestArtifactType = synapseTestCase.getArtifacts().getTestArtifact().getArtifactType();
        this.proxyTransportMethod = synapseTestCase.getArtifacts().getTestArtifact().getTransportMethod();
        String artifactNameOrKey = synapseTestCase.getArtifacts().getTestArtifact().getArtifactNameOrKey();
        OMElement artifact = synapseTestCase.getArtifacts().getTestArtifact().getArtifact();
        boolean isArtifactDeployed = false;
        ConfigurationDeployer config = new ConfigurationDeployer();
        try {
            switch (this.mainTestArtifactType) {
                case "sequence": {
                    Map.Entry<SynapseConfiguration, String> pairOfSequenceDeployment = config.deploySequenceArtifact(artifact, artifactNameOrKey);
                    this.synapseConfiguration = pairOfSequenceDeployment.getKey();
                    this.key = pairOfSequenceDeployment.getValue();
                    if (this.key.contains(artifactNameOrKey)) {
                        isArtifactDeployed = true;
                        this.deploymentStats.put(this.key, "sequence");
                        testSuiteSummary.setDeploymentStatus("PASSED");
                        this.log.info((Object)"Primary test Sequence artifact deployed successfully");
                        break;
                    }
                    String errorMessage = "Sequence " + artifactNameOrKey + " deployment failed";
                    this.log.error((Object)errorMessage);
                    testSuiteSummary.setDeploymentStatus("FAILED");
                    testSuiteSummary.setDeploymentException(errorMessage);
                    break;
                }
                case "proxy": {
                    Map.Entry<SynapseConfiguration, String> pairOfProxyDeployment = config.deployProxyArtifact(artifact, artifactNameOrKey);
                    this.synapseConfiguration = pairOfProxyDeployment.getKey();
                    this.key = pairOfProxyDeployment.getValue();
                    if (this.key.contains(artifactNameOrKey)) {
                        isArtifactDeployed = true;
                        this.deploymentStats.put(this.key, "proxy");
                        testSuiteSummary.setDeploymentStatus("PASSED");
                        this.log.info((Object)"Primary test Proxy artifact deployed successfully");
                        break;
                    }
                    String errorMessage = "Proxy " + artifactNameOrKey + " deployment failed";
                    this.log.error((Object)errorMessage);
                    testSuiteSummary.setDeploymentStatus("FAILED");
                    testSuiteSummary.setDeploymentException(errorMessage);
                    break;
                }
                case "api": {
                    Map.Entry<SynapseConfiguration, String> pairofApiDeployment = config.deployApiArtifact(artifact, artifactNameOrKey);
                    this.synapseConfiguration = pairofApiDeployment.getKey();
                    this.key = pairofApiDeployment.getValue();
                    this.artifactNode = artifact;
                    if (this.key.contains(artifactNameOrKey)) {
                        isArtifactDeployed = true;
                        this.deploymentStats.put(this.key, "api");
                        testSuiteSummary.setDeploymentStatus("PASSED");
                        this.log.info((Object)"Primary test API artifact deployed successfully");
                        break;
                    }
                    String errorMessage = "API " + artifactNameOrKey + " deployment failed";
                    this.log.error((Object)errorMessage);
                    testSuiteSummary.setDeploymentStatus("FAILED");
                    testSuiteSummary.setDeploymentException(errorMessage);
                    break;
                }
                default: {
                    throw new IOException("Undefined operation type for <test-artifact> given in unit testing agent");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Primary test artifact " + this.mainTestArtifactType + " deployment failed"), (Throwable)e);
            this.exception = CommonUtils.stackTraceToString(e);
            testSuiteSummary.setDeploymentStatus("FAILED");
            testSuiteSummary.setDeploymentException(this.exception);
        }
        return new AbstractMap.SimpleEntry<Boolean, TestSuiteSummary>(isArtifactDeployed, testSuiteSummary);
    }

    Map.Entry<Boolean, TestSuiteSummary> processSupportiveArtifacts(SynapseTestCase synapseTestCase, TestSuiteSummary testSuiteSummary) {
        boolean isArtifactDeployed = true;
        for (int x = 0; x < synapseTestCase.getArtifacts().getSupportiveArtifactCount(); ++x) {
            if (isArtifactDeployed) {
                try {
                    isArtifactDeployed = this.processForArtifactTypes(synapseTestCase, x);
                }
                catch (Exception e) {
                    this.log.error((Object)"Supportive test artifact deployment failed", (Throwable)e);
                    this.exception = CommonUtils.stackTraceToString(e);
                    testSuiteSummary.setDeploymentStatus("FAILED");
                    testSuiteSummary.setDeploymentException(this.exception);
                }
                continue;
            }
            this.log.error((Object)(synapseTestCase.getArtifacts().getSupportiveArtifact(x).getArtifactType() + " primary test artifact deployment failed"));
            break;
        }
        return new AbstractMap.SimpleEntry<Boolean, TestSuiteSummary>(isArtifactDeployed, testSuiteSummary);
    }

    private boolean processForArtifactTypes(SynapseTestCase synapseTestCase, int index) throws IOException {
        String supportiveArtifactType = synapseTestCase.getArtifacts().getSupportiveArtifact(index).getArtifactType();
        String artifactNameOrKey = synapseTestCase.getArtifacts().getSupportiveArtifact(index).getArtifactNameOrKey();
        OMElement artifact = synapseTestCase.getArtifacts().getSupportiveArtifact(index).getArtifact();
        ConfigurationDeployer config = new ConfigurationDeployer();
        switch (supportiveArtifactType) {
            case "sequence": {
                Map.Entry<SynapseConfiguration, String> pairOfSequenceDeployment = config.deploySequenceArtifact(artifact, artifactNameOrKey);
                this.synapseConfiguration = pairOfSequenceDeployment.getKey();
                this.key = pairOfSequenceDeployment.getValue();
                break;
            }
            case "proxy": {
                Map.Entry<SynapseConfiguration, String> pairofProxyDeployment = config.deployProxyArtifact(artifact, artifactNameOrKey);
                this.synapseConfiguration = pairofProxyDeployment.getKey();
                this.key = pairofProxyDeployment.getValue();
                break;
            }
            case "api": {
                Map.Entry<SynapseConfiguration, String> pairofApiDeployment = config.deployApiArtifact(artifact, artifactNameOrKey);
                this.synapseConfiguration = pairofApiDeployment.getKey();
                this.key = pairofApiDeployment.getValue();
                break;
            }
            case "endpoint": {
                Map.Entry<SynapseConfiguration, String> pairOfEndpointDeployment = config.deployEndpointArtifact(artifact, artifactNameOrKey);
                this.synapseConfiguration = pairOfEndpointDeployment.getKey();
                this.key = pairOfEndpointDeployment.getValue();
                break;
            }
            case "localEntry": {
                Map.Entry<SynapseConfiguration, String> pairOfLocalEntryDeployment = config.deployLocalEntryArtifact(artifact, artifactNameOrKey);
                this.synapseConfiguration = pairOfLocalEntryDeployment.getKey();
                this.key = pairOfLocalEntryDeployment.getValue();
                break;
            }
            case "template": {
                Map.Entry<SynapseConfiguration, String> pairOfTemplateDeployment = config.deployTemplateArtifact(artifact, artifactNameOrKey);
                this.synapseConfiguration = pairOfTemplateDeployment.getKey();
                this.key = pairOfTemplateDeployment.getValue();
                break;
            }
            default: {
                throw new IOException("Undefined operation type for <test-artifact> given in unit testing agent");
            }
        }
        if (this.key.contains(artifactNameOrKey)) {
            this.log.info((Object)(this.key + " - " + supportiveArtifactType + " supportive artifact deployed successfully"));
            this.deploymentStats.put(this.key, supportiveArtifactType);
            return true;
        }
        this.log.info((Object)(this.key + " - " + supportiveArtifactType + " supportive artifact deployment failed"));
        return false;
    }

    void processTestCases(SynapseTestCase synapseTestCase, TestSuiteSummary testSuiteSummary) {
        int testCaseCount = synapseTestCase.getTestCases().getTestCaseCount();
        this.log.info((Object)(testCaseCount + " Test case(s) ready to execute"));
        String currentTestCaseName = null;
        try {
            for (int i = 0; i < testCaseCount; ++i) {
                TestCaseSummary testSummary = new TestCaseSummary();
                TestCase currentTestCase = synapseTestCase.getTestCases().getTestCase(i);
                currentTestCaseName = currentTestCase.getTestCaseName();
                testSummary.setTestCaseName(currentTestCaseName);
                testSuiteSummary.setRecentTestCaseName(currentTestCaseName);
                switch (this.mainTestArtifactType) {
                    case "sequence": {
                        Map.Entry<Boolean, MessageContext> mediateResult = TestCasesMediator.sequenceMediate(currentTestCase, this.synapseConfiguration, this.key);
                        testSuiteSummary.setMediationStatus("PASSED");
                        Boolean mediationResult = mediateResult.getKey();
                        MessageContext resultedMessageContext = mediateResult.getValue();
                        this.checkAssertionWithSequenceMediation(mediationResult, resultedMessageContext, currentTestCase, testSummary);
                        break;
                    }
                    case "proxy": {
                        Map.Entry<String, HttpResponse> invokedProxyResult = TestCasesMediator.proxyServiceExecutor(currentTestCase, this.proxyTransportMethod, this.key);
                        testSuiteSummary.setMediationStatus("PASSED");
                        this.checkAssertionWithProxyMediation(invokedProxyResult, currentTestCase, testSummary);
                        break;
                    }
                    case "api": {
                        String context = this.artifactNode.getAttributeValue(new QName("context"));
                        String resourceMethod = currentTestCase.getRequestMethod();
                        Map.Entry<String, HttpResponse> invokedApiResult = TestCasesMediator.apiResourceExecutor(currentTestCase, context, resourceMethod);
                        testSuiteSummary.setMediationStatus("PASSED");
                        this.checkAssertionWithAPIMediation(invokedApiResult, currentTestCase, testSummary);
                        break;
                    }
                }
                testSuiteSummary.addTestCaseSumamry(testSummary);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occurred while running test cases", (Throwable)e);
            this.exception = CommonUtils.stackTraceToString(e);
            testSuiteSummary.setRecentTestCaseName(currentTestCaseName);
            testSuiteSummary.setMediationStatus("FAILED");
            testSuiteSummary.setMediationException(this.exception);
        }
    }

    private void checkAssertionWithSequenceMediation(boolean mediationResult, MessageContext resultedMessageContext, TestCase currentTestCase, TestCaseSummary testSummary) {
        if (mediationResult) {
            testSummary.setMediationStatus("PASSED");
            Assertor.doAssertionSequence(currentTestCase, resultedMessageContext, testSummary);
        } else {
            String assertMessage = "Sequence mediation failed, check the server logs for more details";
            this.log.error((Object)assertMessage);
            testSummary.setMediationStatus("FAILED");
            testSummary.setTestException(assertMessage);
        }
    }

    private void checkAssertionWithProxyMediation(Map.Entry<String, HttpResponse> invokedProxyResult, TestCase currentTestCase, TestCaseSummary testSummary) {
        if (invokedProxyResult.getValue() != null) {
            testSummary.setMediationStatus("PASSED");
            Assertor.doAssertionService(currentTestCase, invokedProxyResult, testSummary);
        } else {
            String assertMessage = "Proxy service invoked URL - " + invokedProxyResult.getKey() + "\nProxy service mediation phase failed due to respond of the proxy service was null, check the server logs for more details";
            this.log.error((Object)assertMessage);
            testSummary.setMediationStatus("FAILED");
            testSummary.setTestException(assertMessage);
        }
    }

    private void checkAssertionWithAPIMediation(Map.Entry<String, HttpResponse> invokedApiResult, TestCase currentTestCase, TestCaseSummary testSummary) {
        if (invokedApiResult.getValue() != null) {
            testSummary.setMediationStatus("PASSED");
            Assertor.doAssertionService(currentTestCase, invokedApiResult, testSummary);
        } else {
            String assertMessage = "API invoked URL - " + invokedApiResult.getKey() + "\nAPI mediation phase failed due to respond of the API resource was null, check the server logs for more details";
            this.log.error((Object)assertMessage);
            testSummary.setMediationStatus("FAILED");
            testSummary.setTestException(assertMessage);
        }
    }

    void artifactUndeployer() {
        try {
            SynapseConfiguration synapseConfig = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
            AxisConfiguration axisConfiguration = synapseConfig.getAxisConfiguration();
            ConfigurationContext configurationContext = new ConfigurationContext(axisConfiguration);
            Axis2SynapseEnvironment synapseEnvironment = new Axis2SynapseEnvironment(configurationContext, synapseConfig);
            axisConfiguration.addParameter(new Parameter("synapse.env", (Object)synapseEnvironment));
            axisConfiguration.addParameter(new Parameter("synapse.config", (Object)synapseConfig));
            configurationContext.setAxisConfiguration(axisConfiguration);
            for (Map.Entry<String, String> unDeployEntry : this.deploymentStats.entrySet()) {
                String unDeployableArtifactType;
                String artifactName = unDeployEntry.getKey();
                switch (unDeployableArtifactType = unDeployEntry.getValue()) {
                    case "sequence": {
                        SequenceDeployer sequenceDeployer = new SequenceDeployer();
                        sequenceDeployer.init(configurationContext);
                        sequenceDeployer.undeploySynapseArtifact(artifactName);
                        break;
                    }
                    case "proxy": {
                        ProxyServiceDeployer proxyDeployer = new ProxyServiceDeployer();
                        proxyDeployer.init(configurationContext);
                        proxyDeployer.undeploySynapseArtifact(artifactName);
                        break;
                    }
                    case "api": {
                        APIDeployer apiDeployer = new APIDeployer();
                        apiDeployer.init(configurationContext);
                        apiDeployer.undeploySynapseArtifact(artifactName);
                        break;
                    }
                    case "endpoint": {
                        EndpointDeployer endpointDeployer = new EndpointDeployer();
                        endpointDeployer.init(configurationContext);
                        endpointDeployer.undeploySynapseArtifact(artifactName);
                        break;
                    }
                    case "localEntry": {
                        LocalEntryDeployer localEntryDeployer = new LocalEntryDeployer();
                        localEntryDeployer.init(configurationContext);
                        localEntryDeployer.undeploySynapseArtifact(artifactName);
                        break;
                    }
                    case "template": {
                        TemplateDeployer templateDeployer = new TemplateDeployer();
                        templateDeployer.init(configurationContext);
                        templateDeployer.undeploySynapseArtifact(artifactName);
                        break;
                    }
                }
            }
            this.log.info((Object)"Undeployed all the deployed test and supportive artifacts");
        }
        catch (AxisFault e) {
            this.log.error((Object)"Error while undeploying the artifacts", (Throwable)e);
        }
    }
}

