/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.unittest.CommonUtils;
import org.apache.synapse.unittest.UnitTestingExecutor;
import org.apache.synapse.unittest.testcase.data.classes.TestCase;

public class TestCasesMediator {
    private static Logger log = Logger.getLogger((String)UnitTestingExecutor.class.getName());
    private static int httpPassThruOperatingPort = Integer.parseInt(System.getProperty("http.nio.port"));
    private static int httpsPassThruOperatingPort = Integer.parseInt(System.getProperty("https.nio.port"));

    private TestCasesMediator() {
    }

    static Map.Entry<Boolean, MessageContext> sequenceMediate(TestCase currentTestCase, SynapseConfiguration synConfig, String key) {
        Mediator sequenceMediator = synConfig.getSequence(key);
        MessageContext msgCtxt = TestCasesMediator.createSynapseMessageContext(currentTestCase.getInputPayload(), synConfig);
        boolean mediationResult = false;
        if (msgCtxt != null) {
            mediationResult = sequenceMediator.mediate(TestCasesMediator.setInputMessageProperties(msgCtxt, currentTestCase.getPropertyMap()));
        }
        return new AbstractMap.SimpleEntry<Boolean, MessageContext>(mediationResult, msgCtxt);
    }

    static Map.Entry<String, HttpResponse> proxyServiceExecutor(TestCase currentTestCase, String proxyTransportMethod, String key) throws IOException {
        HttpResponse response;
        String url;
        if (proxyTransportMethod.equals("http")) {
            url = "http://localhost:" + httpPassThruOperatingPort + "/services/" + key;
        } else if (proxyTransportMethod.equals("https")) {
            url = "https://localhost:" + httpsPassThruOperatingPort + "/services/" + key;
        } else {
            return new AbstractMap.SimpleEntry<String, Object>("'" + proxyTransportMethod + "' transport is not supported", null);
        }
        log.info((Object)("Invoking URI - " + url));
        CloseableHttpClient clientConnector = HttpClientBuilder.create().build();
        HttpPost httpPost = TestCasesMediator.setPostHeaders(currentTestCase, url);
        try {
            if (currentTestCase.getInputPayload() != null) {
                StringEntity postEntity = new StringEntity(currentTestCase.getInputPayload().trim());
                httpPost.setEntity((HttpEntity)postEntity);
            }
            response = clientConnector.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            throw new IOException("Proxy service invoked URL - " + url + "\n" + e);
        }
        return new AbstractMap.SimpleEntry<String, HttpResponse>(url, response);
    }

    static Map.Entry<String, HttpResponse> apiResourceExecutor(TestCase currentTestCase, String context, String resourceMethod) throws IOException {
        HttpResponse response;
        String url = currentTestCase.getRequestPath() != null ? (currentTestCase.getRequestPath().startsWith("/") ? "http://localhost:" + httpPassThruOperatingPort + context + currentTestCase.getRequestPath() : "http://localhost:" + httpPassThruOperatingPort + context + "/" + currentTestCase.getRequestPath()) : "http://localhost:" + httpPassThruOperatingPort + context;
        log.info((Object)("Invoking URI - " + url));
        CloseableHttpClient clientConnector = HttpClientBuilder.create().build();
        String resourceHTTPMethod = resourceMethod.toUpperCase(Locale.ENGLISH);
        String invokeUrlWithMethod = resourceHTTPMethod + ": " + url;
        try {
            switch (resourceHTTPMethod) {
                case "GET": {
                    response = clientConnector.execute((HttpUriRequest)TestCasesMediator.setGetHeaders(currentTestCase, url));
                    break;
                }
                case "POST": {
                    HttpPost httpPost = TestCasesMediator.setPostHeaders(currentTestCase, url);
                    String postPayload = currentTestCase.getInputPayload();
                    if (postPayload == null) {
                        postPayload = "";
                    }
                    StringEntity postEntity = new StringEntity(postPayload);
                    httpPost.setEntity((HttpEntity)postEntity);
                    response = clientConnector.execute((HttpUriRequest)httpPost);
                    break;
                }
                case "PUT": {
                    HttpPut httpPut = TestCasesMediator.setPutHeaders(currentTestCase, url);
                    String putPayload = currentTestCase.getInputPayload();
                    if (putPayload == null) {
                        putPayload = "";
                    }
                    StringEntity putEntity = new StringEntity(putPayload);
                    httpPut.setEntity((HttpEntity)putEntity);
                    response = clientConnector.execute((HttpUriRequest)httpPut);
                    break;
                }
                case "DELETE": {
                    HttpDeleteWithBody httpDelete = TestCasesMediator.setDeleteWithBody(currentTestCase, url);
                    response = clientConnector.execute((HttpUriRequest)httpDelete);
                    break;
                }
                default: {
                    throw new ClientProtocolException("HTTP client can't find proper request method");
                }
            }
        }
        catch (IOException e) {
            throw new IOException("API invoked URL - " + invokeUrlWithMethod + "\n" + e);
        }
        return new AbstractMap.SimpleEntry<String, HttpResponse>(invokeUrlWithMethod, response);
    }

    private static HttpGet setGetHeaders(TestCase currentTestCase, String url) {
        HttpGet httpGet = new HttpGet(url);
        for (Map<String, String> property : currentTestCase.getPropertyMap()) {
            String scope = property.get("scope");
            if (!scope.equals("transport")) continue;
            httpGet.setHeader(property.get("name"), property.get("value"));
        }
        return httpGet;
    }

    private static HttpPost setPostHeaders(TestCase currentTestCase, String url) {
        HttpPost httpPost = new HttpPost(url);
        for (Map<String, String> property : currentTestCase.getPropertyMap()) {
            String scope = property.get("scope");
            if (!scope.equals("transport")) continue;
            httpPost.setHeader(property.get("name"), property.get("value"));
        }
        return httpPost;
    }

    private static HttpPut setPutHeaders(TestCase currentTestCase, String url) {
        HttpPut httpPut = new HttpPut(url);
        for (Map<String, String> property : currentTestCase.getPropertyMap()) {
            String scope = property.get("scope");
            if (!scope.equals("transport")) continue;
            httpPut.setHeader(property.get("name"), property.get("value"));
        }
        return httpPut;
    }

    private static HttpDeleteWithBody setDeleteWithBody(TestCase currentTestCase, String url) throws IOException {
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(url);
        for (Map<String, String> property : currentTestCase.getPropertyMap()) {
            String scope = property.get("scope");
            if (!scope.equals("transport")) continue;
            httpDelete.setHeader(property.get("name"), property.get("value"));
        }
        String deletePayload = currentTestCase.getInputPayload();
        if (deletePayload == null) {
            deletePayload = "";
        }
        StringEntity deleteEntity = new StringEntity(deletePayload);
        httpDelete.setEntity((HttpEntity)deleteEntity);
        return httpDelete;
    }

    private static MessageContext createSynapseMessageContext(String payload, SynapseConfiguration synapseConfig) {
        Axis2MessageContext synapseMessageContext = null;
        try {
            org.apache.axis2.context.MessageContext messageContext = new org.apache.axis2.context.MessageContext();
            AxisConfiguration axisConfig = synapseConfig.getAxisConfiguration();
            if (axisConfig == null) {
                axisConfig = new AxisConfiguration();
                synapseConfig.setAxisConfiguration(axisConfig);
            }
            ConfigurationContext configurationContext = new ConfigurationContext(axisConfig);
            Axis2SynapseEnvironment env = new Axis2SynapseEnvironment(configurationContext, synapseConfig);
            synapseMessageContext = new Axis2MessageContext(messageContext, synapseConfig, env);
            synapseMessageContext.setContinuationEnabled(true);
            synapseMessageContext.setMessageID(UIDGenerator.generateURNString());
            synapseMessageContext.setEnvelope(OMAbstractFactory.getSOAP11Factory().createSOAPEnvelope());
            SOAPEnvelope envelope = synapseMessageContext.getEnvelope();
            envelope.addChild((OMNode)OMAbstractFactory.getSOAP12Factory().createSOAPBody());
            synapseMessageContext.getAxis2MessageContext().setConfigurationContext(configurationContext);
            synapseMessageContext.getAxis2MessageContext().setOperationContext(new OperationContext((AxisOperation)new InOutAxisOperation(), new ServiceContext()));
            if (payload != null) {
                Map.Entry<String, String> inputPayload = CommonUtils.checkInputStringFormat(payload);
                String inputPayloadType = inputPayload.getKey();
                String trimmedInputPayload = inputPayload.getValue();
                if (inputPayloadType.equals("XML")) {
                    envelope.getBody().addChild((OMNode)TestCasesMediator.createOMElement(trimmedInputPayload));
                } else if (inputPayloadType.equals("JSON")) {
                    org.apache.axis2.context.MessageContext axis2MessageContext = synapseMessageContext.getAxis2MessageContext();
                    envelope.getBody().addChild((OMNode)JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)axis2MessageContext, (String)trimmedInputPayload, (boolean)true, (boolean)true));
                } else if (inputPayloadType.equals("TEXT")) {
                    envelope.getBody().addChild((OMNode)TestCasesMediator.getTextElement(trimmedInputPayload));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception while creating synapse message context", (Throwable)e);
        }
        return synapseMessageContext;
    }

    public static OMElement createOMElement(String xml) {
        return SynapseConfigUtils.stringToOM(xml);
    }

    private static MessageContext setInputMessageProperties(MessageContext messageContext, List<Map<String, String>> properties) {
        try {
            block12: for (Map<String, String> property : properties) {
                String scope = property.get("scope");
                Axis2MessageContext axis2MessageContext = (Axis2MessageContext)messageContext;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2MessageContext.getAxis2MessageContext();
                switch (scope) {
                    case "default": {
                        messageContext.setProperty(property.get("name"), property.get("value"));
                        continue block12;
                    }
                    case "axis2": {
                        axis2MessageCtx.setProperty(property.get("name"), (Object)property.get("value"));
                        continue block12;
                    }
                    case "transport": {
                        TreeMap<String, String> headersMap;
                        Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
                        if (headers != null) {
                            headersMap = (TreeMap<String, String>)headers;
                            headersMap.put(property.get("name"), property.get("value"));
                        }
                        if (headers != null) continue block12;
                        headersMap = new TreeMap<String, String>(new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                return o1.compareToIgnoreCase(o2);
                            }
                        });
                        headersMap.put(property.get("name"), property.get("value"));
                        axis2MessageContext.setProperty("TRANSPORT_HEADERS", headersMap);
                        continue block12;
                    }
                }
                throw new IOException("Property scope not defined for sequences");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while setting properties to the Message Context", (Throwable)e);
        }
        return messageContext;
    }

    private static OMElement getTextElement(String content) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement textElement = factory.createOMElement(new QName("http://ws.apache.org/commons/ns/payload", "text"));
        if (content == null) {
            content = "";
        }
        textElement.setText(content);
        return textElement;
    }

    @Contract(threading=ThreadingBehavior.UNSAFE)
    static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }
    }
}

