/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.synapse.unittest.RequestHandler;
import org.apache.synapse.unittest.UnitTestingExecutor;

public class TCPServer {
    private static Logger log = Logger.getLogger((String)UnitTestingExecutor.class.getName());
    private ServerSocket serverSocket;
    private boolean isUnitTestingOver = false;

    public void initialize() {
        String requestPort = System.getProperty("synapseTestPort");
        if (requestPort == null || requestPort.isEmpty()) {
            requestPort = "9008";
        }
        try {
            int unitTestingAgentPort = Integer.parseInt(requestPort);
            this.serverSocket = new ServerSocket(unitTestingAgentPort);
            log.info((Object)("Synapse unit testing agent has been established on port " + unitTestingAgentPort));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for client request");
            }
            this.acceptConnection();
        }
        catch (NumberFormatException e) {
            log.error((Object)("Given TCP port \"" + requestPort + "\" is not in valid format, failed to start unit testing framework"), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error in initializing TCP connection in given port " + requestPort), (Throwable)e);
        }
    }

    private void acceptConnection() throws IOException {
        this.shutDown();
        while (!this.isUnitTestingOver) {
            Socket socket = this.serverSocket.accept();
            RequestHandler requestHandler = new RequestHandler(socket);
            Thread threadForClient = new Thread(requestHandler);
            threadForClient.start();
        }
    }

    private void shutDown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info((Object)"Shutting down unit testing framework");
                TCPServer.this.isUnitTestingOver = true;
            }
        });
    }
}

