/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.log4j.Logger;
import org.apache.synapse.unittest.testcase.data.classes.Artifact;
import org.apache.synapse.unittest.testcase.data.classes.AssertEqual;
import org.apache.synapse.unittest.testcase.data.classes.AssertNotNull;
import org.apache.synapse.unittest.testcase.data.classes.MockService;
import org.apache.synapse.unittest.testcase.data.classes.RegistryResource;
import org.apache.synapse.unittest.testcase.data.classes.ServiceResource;
import org.apache.synapse.unittest.testcase.data.classes.TestCase;
import org.apache.synapse.unittest.testcase.data.holders.ArtifactData;
import org.apache.synapse.unittest.testcase.data.holders.MockServiceData;
import org.apache.synapse.unittest.testcase.data.holders.TestCaseData;

class SynapseTestcaseDataReader {
    private static Logger log = Logger.getLogger((String)SynapseTestcaseDataReader.class.getName());
    private OMElement importXMLFile = null;

    SynapseTestcaseDataReader(String descriptorData) {
        try {
            this.importXMLFile = AXIOMUtil.stringToOM((String)descriptorData);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    ArtifactData readAndStoreArtifactData() throws XMLStreamException, IOException {
        ArtifactData artifactDataHolder = new ArtifactData();
        Artifact testArtifact = new Artifact();
        QName qualifiedArtifacts = new QName("", "artifacts", "");
        OMElement artifactsNode = this.importXMLFile.getFirstChildWithName(qualifiedArtifacts);
        QName qualifiedTestArtifact = new QName("", "test-artifact", "");
        OMElement testArtifactNode = artifactsNode.getFirstChildWithName(qualifiedTestArtifact);
        QName qualifiedArtifact = new QName("", "artifact", "");
        OMElement testArtifactDataNode = testArtifactNode.getFirstChildWithName(qualifiedArtifact);
        String testArtifactData = testArtifactDataNode.getFirstElement().toString();
        testArtifact.setArtifact(testArtifactData);
        String testArtifactType = testArtifactDataNode.getFirstElement().getLocalName();
        testArtifact.setArtifactType(testArtifactType);
        String testArtifactNameOrKey = testArtifactType.equals("localEntry") ? testArtifactDataNode.getFirstElement().getAttributeValue(new QName("key")) : testArtifactDataNode.getFirstElement().getAttributeValue(new QName("name"));
        testArtifact.setArtifactNameOrKey(testArtifactNameOrKey);
        if (testArtifact.getArtifactType().equals("proxy")) {
            String transport = testArtifactDataNode.getFirstElement().getAttributeValue(new QName("transports"));
            if (transport == null) {
                throw new IOException("Local transport method for proxy currently not supported");
            }
            String[] transportMethods = transport.split(" ");
            if (Arrays.asList(transportMethods).contains("http")) {
                testArtifact.setTransportMethod("http");
            } else if (Arrays.asList(transportMethods).contains("https")) {
                testArtifact.setTransportMethod("https");
            } else {
                throw new IOException("Defined transport method for proxy currently not supported");
            }
        }
        artifactDataHolder.setTestArtifact(testArtifact);
        QName qualifiedSupportiveTestArtifact = new QName("", "supportive-artifacts", "");
        OMElement supportiveArtifactsNode = artifactsNode.getFirstChildWithName(qualifiedSupportiveTestArtifact);
        Iterator artifactIterator = Collections.emptyIterator();
        int supportiveArtifactCount = 0;
        if (supportiveArtifactsNode != null) {
            artifactIterator = supportiveArtifactsNode.getChildElements();
        }
        while (artifactIterator.hasNext()) {
            OMElement artifact = (OMElement)artifactIterator.next();
            Artifact supportiveArtifact = new Artifact();
            String supportiveArtifactData = artifact.getFirstElement().toString();
            supportiveArtifact.setArtifact(supportiveArtifactData);
            String supportiveArtifactType = artifact.getFirstElement().getLocalName();
            supportiveArtifact.setArtifactType(supportiveArtifactType);
            String supportiveArtifactNameOrKey = supportiveArtifactType.equals("localEntry") ? artifact.getFirstElement().getAttributeValue(new QName("key")) : artifact.getFirstElement().getAttributeValue(new QName("name"));
            supportiveArtifact.setArtifactNameOrKey(supportiveArtifactNameOrKey);
            artifactDataHolder.addSupportiveArtifact(supportiveArtifact);
            ++supportiveArtifactCount;
        }
        artifactDataHolder.setSupportiveArtifactCount(supportiveArtifactCount);
        QName qualifiedRegistryArtifact = new QName("", "registry-resources", "");
        OMElement registryArtifactsNode = artifactsNode.getFirstChildWithName(qualifiedRegistryArtifact);
        Iterator registryIterator = Collections.emptyIterator();
        if (registryArtifactsNode != null) {
            registryIterator = registryArtifactsNode.getChildElements();
        }
        while (registryIterator.hasNext()) {
            OMElement resource = (OMElement)registryIterator.next();
            QName qualifiedRegistryArtifactFileName = new QName("", "file-name", "");
            OMElement registryArtifactsNameNode = resource.getFirstChildWithName(qualifiedRegistryArtifactFileName);
            String resourceName = registryArtifactsNameNode.getText();
            QName qualifiedRegistryArtifactFilePath = new QName("", "registry-path", "");
            OMElement registryArtifactsPathNode = resource.getFirstChildWithName(qualifiedRegistryArtifactFilePath);
            String resourcePath = registryArtifactsPathNode.getText();
            QName qualifiedRegistryArtifactFile = new QName("", "artifact", "");
            OMElement registryArtifactsFileNode = resource.getFirstChildWithName(qualifiedRegistryArtifactFile);
            String resourceArtifact = registryArtifactsFileNode.getText();
            if (resourceArtifact.isEmpty()) {
                resourceArtifact = registryArtifactsFileNode.getFirstOMChild().toString();
            }
            QName qualifiedRegistryArtifactMediaType = new QName("", "media-type", "");
            OMElement registryArtifactsMediaTypeNode = resource.getFirstChildWithName(qualifiedRegistryArtifactMediaType);
            String resourceMediaType = registryArtifactsMediaTypeNode.getText();
            RegistryResource registryResource = new RegistryResource();
            registryResource.setRegistryResourceName(resourceName);
            registryResource.setArtifact(resourceArtifact);
            registryResource.setRegistryPath(resourcePath);
            registryResource.setMediaType(resourceMediaType);
            String registryKey = resourcePath + "/" + resourceName;
            artifactDataHolder.addRegistryResource(registryKey, registryResource);
        }
        QName qualifiedConnectorResources = new QName("", "connector-resources", "");
        OMElement connectorResourcesNode = artifactsNode.getFirstChildWithName(qualifiedConnectorResources);
        Iterator connectorIterator = Collections.emptyIterator();
        if (connectorResourcesNode != null) {
            connectorIterator = connectorResourcesNode.getChildElements();
        }
        while (connectorIterator.hasNext()) {
            OMElement resource = (OMElement)connectorIterator.next();
            String connectorResourceFileBase64 = resource.getText();
            artifactDataHolder.addConnectorResource(connectorResourceFileBase64);
        }
        log.info((Object)"Artifact data from descriptor data read successfully");
        return artifactDataHolder;
    }

    TestCaseData readAndStoreTestCaseData() {
        TestCaseData testCaseDataHolder = new TestCaseData();
        int testCasesCount = 0;
        QName qualifiedTestCases = new QName("", "test-cases", "");
        OMElement testCasesNode = this.importXMLFile.getFirstChildWithName(qualifiedTestCases);
        Iterator testCaseIterator = Collections.emptyIterator();
        if (testCasesNode != null) {
            testCaseIterator = testCasesNode.getChildElements();
        }
        while (testCaseIterator.hasNext()) {
            TestCase testCase = new TestCase();
            OMElement testCaseNode = (OMElement)testCaseIterator.next();
            String testCaseName = testCaseNode.getAttributeValue(new QName("name"));
            testCase.setTestCaseName(testCaseName);
            QName qualifiedInput = new QName("", "input", "");
            OMElement testCaseInputNode = testCaseNode.getFirstChildWithName(qualifiedInput);
            if (testCaseInputNode != null) {
                this.readTestCaseInputData(testCaseInputNode, testCase);
            }
            QName qualifiedAssertions = new QName("", "assertions", "");
            OMElement testCaseAssertionNode = testCaseNode.getFirstChildWithName(qualifiedAssertions);
            ArrayList<AssertEqual> assertEquals = new ArrayList<AssertEqual>();
            ArrayList<AssertNotNull> assertNotNulls = new ArrayList<AssertNotNull>();
            this.readTestCaseAssertions(testCaseAssertionNode, assertEquals, assertNotNulls);
            testCase.setAssertEquals(assertEquals);
            testCase.setAssertNotNull(assertNotNulls);
            testCaseDataHolder.setTestCases(testCase);
            ++testCasesCount;
        }
        testCaseDataHolder.setTestCaseCount(testCasesCount);
        log.info((Object)"Test case data from descriptor data read successfully");
        return testCaseDataHolder;
    }

    private void readTestCaseInputData(OMElement testCaseInputNode, TestCase testCase) {
        QName qualifiedInputProperties;
        OMElement testCaseInputPropertyNode;
        QName qualifiedInputRequestMethod;
        OMElement testCaseRequestMethodNode;
        QName qualifiedInputRequestPath;
        OMElement testCaseRequestPathNode;
        QName qualifiedInputPayload = new QName("", "payload", "");
        OMElement testCaseInputPayloadNode = testCaseInputNode.getFirstChildWithName(qualifiedInputPayload);
        if (testCaseInputPayloadNode != null) {
            String inputPayload = testCaseInputPayloadNode.getText();
            testCase.setInputPayload(inputPayload);
        }
        if ((testCaseRequestPathNode = testCaseInputNode.getFirstChildWithName(qualifiedInputRequestPath = new QName("", "request-path", ""))) != null) {
            String requestPath = testCaseRequestPathNode.getText();
            testCase.setRequestPath(requestPath);
        }
        if ((testCaseRequestMethodNode = testCaseInputNode.getFirstChildWithName(qualifiedInputRequestMethod = new QName("", "request-method", ""))) != null) {
            String requestMethod = testCaseRequestMethodNode.getText();
            testCase.setRequestMethod(requestMethod);
        }
        if ((testCaseInputPropertyNode = testCaseInputNode.getFirstChildWithName(qualifiedInputProperties = new QName("", "properties", ""))) != null) {
            Iterator propertyIterator = testCaseInputPropertyNode.getChildElements();
            ArrayList<Map<String, String>> properties = new ArrayList<Map<String, String>>();
            while (propertyIterator.hasNext()) {
                OMElement propertyNode = (OMElement)propertyIterator.next();
                String propName = propertyNode.getAttributeValue(new QName("name"));
                String propValue = propertyNode.getAttributeValue(new QName("value"));
                String propScope = "default";
                if (propertyNode.getAttributeValue(new QName("scope")) != null) {
                    propScope = propertyNode.getAttributeValue(new QName("scope"));
                }
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                propertyMap.put("name", propName);
                propertyMap.put("value", propValue);
                propertyMap.put("scope", propScope);
                properties.add(propertyMap);
            }
            testCase.setPropertyMap(properties);
        }
    }

    private void readTestCaseAssertions(OMElement testCaseAssertionNode, ArrayList<AssertEqual> assertEquals, ArrayList<AssertNotNull> assertNotNulls) {
        Iterator assertEqualsIterator = testCaseAssertionNode.getChildrenWithName(new QName("assertEquals"));
        while (assertEqualsIterator.hasNext()) {
            AssertEqual assertion = new AssertEqual();
            OMElement assertEqualNode = (OMElement)assertEqualsIterator.next();
            QName qualifiedAssertActual = new QName("", "actual", "");
            OMElement assertActualNode = assertEqualNode.getFirstChildWithName(qualifiedAssertActual);
            String actual = assertActualNode.getText();
            assertion.setActual(actual);
            QName qualifiedAssertMessage = new QName("", "message", "");
            OMElement assertMessageNode = assertEqualNode.getFirstChildWithName(qualifiedAssertMessage);
            String message = assertMessageNode.getText();
            assertion.setMessage(message);
            QName qualifiedExpectedMessage = new QName("", "expected", "");
            OMElement assertExpectedNode = assertEqualNode.getFirstChildWithName(qualifiedExpectedMessage);
            String expected = assertExpectedNode.getText();
            assertion.setExpected(expected);
            assertEquals.add(assertion);
        }
        Iterator assertNotNullIterator = testCaseAssertionNode.getChildrenWithName(new QName("assertNotNull"));
        while (assertNotNullIterator.hasNext()) {
            AssertNotNull assertion = new AssertNotNull();
            OMElement assertEqualNode = (OMElement)assertNotNullIterator.next();
            QName qualifiedAssertActual = new QName("", "actual", "");
            OMElement assertActualNode = assertEqualNode.getFirstChildWithName(qualifiedAssertActual);
            String actual = assertActualNode.getText();
            assertion.setActual(actual);
            QName qualifiedAssertMessage = new QName("", "message", "");
            OMElement assertMessageNode = assertEqualNode.getFirstChildWithName(qualifiedAssertMessage);
            String message = assertMessageNode.getText();
            assertion.setMessage(message);
            assertNotNulls.add(assertion);
        }
    }

    MockServiceData readAndStoreMockServiceData() {
        MockServiceData mockServiceDataHolder = new MockServiceData();
        int mockServiceCount = 0;
        QName qualifiedMockServices = new QName("", "mock-services", "");
        OMElement mockServicesNode = this.importXMLFile.getFirstChildWithName(qualifiedMockServices);
        if (mockServicesNode != null) {
            Iterator iterator = mockServicesNode.getChildElements();
            while (iterator.hasNext()) {
                OMElement mockServiceNode = (OMElement)iterator.next();
                MockService service = new MockService();
                QName qualifiedServiceName = new QName("", "service-name", "");
                OMElement serviceNameNode = mockServiceNode.getFirstChildWithName(qualifiedServiceName);
                String serviceName = serviceNameNode.getText();
                service.setServiceName(serviceName);
                QName qualifiedServicePort = new QName("", "port", "");
                OMElement servicePortNode = mockServiceNode.getFirstChildWithName(qualifiedServicePort);
                int servicePort = Integer.parseInt(servicePortNode.getText());
                service.setPort(servicePort);
                QName qualifiedServicePath = new QName("", "context", "");
                OMElement servicePathNode = mockServiceNode.getFirstChildWithName(qualifiedServicePath);
                String servicePath = servicePathNode.getText();
                service.setContext(servicePath);
                QName qualifiedServiceResources = new QName("", "resources", "");
                OMElement serviceResourcesNode = mockServiceNode.getFirstChildWithName(qualifiedServiceResources);
                Iterator resourceIterator = serviceResourcesNode.getChildElements();
                ArrayList<ServiceResource> resources = new ArrayList<ServiceResource>();
                while (resourceIterator.hasNext()) {
                    OMElement mockServiceResourceNode = (OMElement)resourceIterator.next();
                    ServiceResource resource = new ServiceResource();
                    QName qualifiedServiceMethod = new QName("", "method", "");
                    OMElement serviceMethodNode = mockServiceResourceNode.getFirstChildWithName(qualifiedServiceMethod);
                    String serviceMethod = serviceMethodNode.getText();
                    resource.setMethod(serviceMethod);
                    QName qualifiedServiceSubContext = new QName("", "sub-context", "");
                    OMElement serviceMethodSubContextNode = mockServiceResourceNode.getFirstChildWithName(qualifiedServiceSubContext);
                    String serviceSubContext = serviceMethodSubContextNode.getText();
                    resource.setSubContext(serviceSubContext);
                    this.readMockServicesRequest(mockServiceResourceNode, resource);
                    this.readMockServicesResponse(mockServiceResourceNode, resource);
                    resources.add(resource);
                }
                service.setResources(resources);
                mockServiceDataHolder.setServiceNameIndex(service.getServiceName(), mockServiceCount);
                mockServiceDataHolder.addMockServices(service);
                ++mockServiceCount;
            }
        }
        mockServiceDataHolder.setMockServicesCount(mockServiceCount);
        log.info((Object)"Mock service data from descriptor data read successfully");
        return mockServiceDataHolder;
    }

    private void readMockServicesRequest(OMElement serviceResourceNode, ServiceResource mockService) {
        QName qualifiedServiceRequest = new QName("", "request", "");
        OMElement serviceRequestNode = serviceResourceNode.getFirstChildWithName(qualifiedServiceRequest);
        if (serviceRequestNode != null) {
            QName qualifiedServiceRequestHeaders;
            OMElement serviceRequestHeaders;
            QName qualifiedServiceRequestPayload = new QName("", "payload", "");
            OMElement serviceRequestPayloadNode = serviceRequestNode.getFirstChildWithName(qualifiedServiceRequestPayload);
            if (serviceRequestPayloadNode != null) {
                String serviceRequestPayload = serviceRequestPayloadNode.getText();
                mockService.setRequestPayload(serviceRequestPayload);
            }
            if ((serviceRequestHeaders = serviceRequestNode.getFirstChildWithName(qualifiedServiceRequestHeaders = new QName("", "headers", ""))) != null) {
                Iterator iterateHeaders = serviceRequestHeaders.getChildElements();
                ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
                while (iterateHeaders.hasNext()) {
                    OMElement mockServiceRequestHeader = (OMElement)iterateHeaders.next();
                    String headerName = mockServiceRequestHeader.getAttributeValue(new QName("name"));
                    String headerValue = mockServiceRequestHeader.getAttributeValue(new QName("value"));
                    headers.add(new AbstractMap.SimpleEntry<String, String>(headerName, headerValue));
                }
                mockService.setRequestHeaders(headers);
            }
        }
    }

    private void readMockServicesResponse(OMElement serviceResourceNode, ServiceResource mockService) {
        QName qualifiedServiceResponse = new QName("", "response", "");
        OMElement serviceResponseNode = serviceResourceNode.getFirstChildWithName(qualifiedServiceResponse);
        if (serviceResponseNode != null) {
            QName qualifiedServiceResponseHeaders;
            OMElement serviceResponseHeaders;
            QName qualifiedServiceResponsePayload;
            OMElement serviceResponsePayloadNode;
            QName qualifiedServiceResponseStatusCode = new QName("", "status-code", "");
            OMElement serviceResponseStatusCodeNode = serviceResponseNode.getFirstChildWithName(qualifiedServiceResponseStatusCode);
            if (serviceResponseStatusCodeNode != null) {
                String serviceResponseStatusCode = serviceResponseStatusCodeNode.getText();
                mockService.setStatusCode(Integer.parseInt(serviceResponseStatusCode));
            }
            if ((serviceResponsePayloadNode = serviceResponseNode.getFirstChildWithName(qualifiedServiceResponsePayload = new QName("", "payload", ""))) != null) {
                String serviceResponsePayload = serviceResponsePayloadNode.getText();
                mockService.setResponsePayload(serviceResponsePayload);
            }
            if ((serviceResponseHeaders = serviceResponseNode.getFirstChildWithName(qualifiedServiceResponseHeaders = new QName("", "headers", ""))) != null) {
                Iterator iterateHeaders = serviceResponseHeaders.getChildElements();
                ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
                while (iterateHeaders.hasNext()) {
                    OMElement mockServiceResponseHeader = (OMElement)iterateHeaders.next();
                    String headerName = mockServiceResponseHeader.getAttributeValue(new QName("name"));
                    String headerValue = mockServiceResponseHeader.getAttributeValue(new QName("value"));
                    headers.add(new AbstractMap.SimpleEntry<String, String>(headerName, headerValue));
                }
                mockService.setResponseHeaders(headers);
            }
        }
    }
}

