/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.unittest.CommonUtils;
import org.apache.synapse.unittest.ConfigModifier;
import org.apache.synapse.unittest.ConnectorDeployer;
import org.apache.synapse.unittest.MockServiceCreator;
import org.apache.synapse.unittest.SynapseTestcaseDataReader;
import org.apache.synapse.unittest.TestingAgent;
import org.apache.synapse.unittest.UnitTestMockRegistry;
import org.apache.synapse.unittest.UnitTestingExecutor;
import org.apache.synapse.unittest.testcase.data.classes.RegistryResource;
import org.apache.synapse.unittest.testcase.data.classes.SynapseTestCase;
import org.apache.synapse.unittest.testcase.data.classes.TestCaseAssertionSummary;
import org.apache.synapse.unittest.testcase.data.classes.TestCaseSummary;
import org.apache.synapse.unittest.testcase.data.classes.TestSuiteSummary;
import org.apache.synapse.unittest.testcase.data.holders.ArtifactData;
import org.apache.synapse.unittest.testcase.data.holders.MockServiceData;
import org.apache.synapse.unittest.testcase.data.holders.TestCaseData;

public class RequestHandler
implements Runnable {
    private static Logger log = Logger.getLogger((String)UnitTestingExecutor.class.getName());
    private Socket socket;
    private boolean isTransportPassThroughPortChecked = false;
    private String exception;
    private TestSuiteSummary testSuiteSummary = new TestSuiteSummary();

    RequestHandler(Socket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.info((Object)"Start processing test-case handler");
            this.checkTransportPassThroughPortAvailability();
            String receivedData = this.readData();
            SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
            synapseConfiguration.setProperty("IS_RUNNING_AS_UNIT_TEST", "true");
            SynapseTestCase synapseTestCases = this.preProcessingData(receivedData);
            if (synapseTestCases != null) {
                this.runTestingAgent(synapseTestCases);
                this.clearRegistryAndConnectorResources(synapseTestCases);
            } else {
                log.error((Object)"Reading Synapse testcase data failed");
                this.testSuiteSummary.setDescription("Failed while reading synapseTestCase data");
                this.testSuiteSummary.setDeploymentStatus("SKIPPED");
                this.testSuiteSummary.setDeploymentException(this.exception);
            }
            this.writeData(this.testSuiteSummary);
            MockServiceCreator.stopServices();
            log.info((Object)"End processing test-case handler");
        }
        catch (Exception e) {
            log.error((Object)"Error while running client request in test agent", (Throwable)e);
        }
        finally {
            this.closeSocket();
        }
    }

    private String readData() {
        String inputFromClient = null;
        try {
            InputStream inputStream = this.socket.getInputStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            inputFromClient = (String)objectInputStream.readObject();
        }
        catch (Exception e) {
            log.error((Object)"Failed to get input stream from TCP connection", (Throwable)e);
        }
        return inputFromClient;
    }

    private SynapseTestCase preProcessingData(String receivedMessage) {
        try {
            SynapseTestcaseDataReader synapseTestcaseDataReader = new SynapseTestcaseDataReader(receivedMessage);
            ArtifactData readArtifactData = synapseTestcaseDataReader.readAndStoreArtifactData();
            TestCaseData readTestCaseData = synapseTestcaseDataReader.readAndStoreTestCaseData();
            MockServiceData readMockServiceData = synapseTestcaseDataReader.readAndStoreMockServiceData();
            if (!readArtifactData.getConnectorResources().isEmpty()) {
                ConnectorDeployer.deployConnectorResources(readArtifactData.getConnectorResources());
            }
            if (!readArtifactData.getRegistryResources().isEmpty()) {
                this.addRegistryResourcesToMockRegistry(readArtifactData.getRegistryResources());
            }
            String exceptionWhileMocking = null;
            if (readMockServiceData.getMockServicesCount() > 0) {
                exceptionWhileMocking = ConfigModifier.mockServiceLoader(readMockServiceData);
            }
            if (exceptionWhileMocking != null) {
                this.exception = exceptionWhileMocking;
                return null;
            }
            SynapseTestCase synapseTestCases = new SynapseTestCase();
            synapseTestCases.setArtifacts(readArtifactData);
            synapseTestCases.setTestCases(readTestCaseData);
            return synapseTestCases;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading data from received message", (Throwable)e);
            this.exception = CommonUtils.stackTraceToString(e);
            return null;
        }
    }

    private void runTestingAgent(SynapseTestCase synapseTestCase) {
        TestingAgent agent = new TestingAgent();
        Map.Entry<Boolean, Object> supportiveArtifactDeployment = new AbstractMap.SimpleEntry<Boolean, Object>(false, null);
        Map.Entry<Boolean, Object> testArtifactDeployment = new AbstractMap.SimpleEntry<Boolean, Object>(false, null);
        if (synapseTestCase.getArtifacts().getSupportiveArtifactCount() > 0) {
            log.info((Object)"Supportive artifacts deployment started");
            supportiveArtifactDeployment = agent.processSupportiveArtifacts(synapseTestCase, this.testSuiteSummary);
        }
        if (((Boolean)supportiveArtifactDeployment.getKey()).booleanValue() || synapseTestCase.getArtifacts().getSupportiveArtifactCount() == 0) {
            log.info((Object)"Main test artifact deployment started");
            this.testSuiteSummary.setDeploymentStatus("PASSED");
            testArtifactDeployment = agent.processTestArtifact(synapseTestCase, this.testSuiteSummary);
        } else if (!supportiveArtifactDeployment.getKey().booleanValue() && ((TestSuiteSummary)supportiveArtifactDeployment.getValue()).getDeploymentException() != null) {
            this.testSuiteSummary.setDeploymentStatus("FAILED");
        } else {
            this.testSuiteSummary.setDeploymentStatus("FAILED");
            this.testSuiteSummary.setDescription("Supportive artifact deployment failed");
        }
        if (testArtifactDeployment.getKey().booleanValue()) {
            log.info((Object)"Synapse testing agent ready to mediate test cases through deployments");
            agent.processTestCases(synapseTestCase, this.testSuiteSummary);
        } else if (testArtifactDeployment.getValue() != null) {
            this.testSuiteSummary.setDeploymentStatus("FAILED");
        } else {
            this.testSuiteSummary.setDeploymentStatus("FAILED");
            this.testSuiteSummary.setDescription("test artifact deployment failed");
        }
        agent.artifactUndeployer();
        ConfigModifier.unitTestMockEndpointMap.clear();
        UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration().setProperty("IS_RUNNING_AS_UNIT_TEST", "false");
    }

    private void writeData(TestSuiteSummary testSummary) throws IOException {
        JsonObject jsonObject = this.createResponseJSON(testSummary);
        OutputStream out = this.socket.getOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(out);
        o.writeObject(jsonObject.toString());
        out.flush();
    }

    private JsonObject createResponseJSON(TestSuiteSummary testSummary) {
        JsonObject jsonResponse = new JsonObject();
        jsonResponse.addProperty("deploymentStatus", testSummary.getDeploymentStatus());
        jsonResponse.addProperty("deploymentException", testSummary.getDeploymentException());
        jsonResponse.addProperty("deploymentDescription", testSummary.getDescription());
        jsonResponse.addProperty("mediationStatus", testSummary.getMediationStatus());
        jsonResponse.addProperty("currentTestCase", testSummary.getRecentTestCaseName());
        jsonResponse.addProperty("mediationException", testSummary.getMediationException());
        JsonArray jsonArray = new JsonArray();
        for (TestCaseSummary summary : testSummary.getTestCaseSumamryList()) {
            JsonObject testObject = new JsonObject();
            testObject.addProperty("testCaseName", summary.getTestCaseName());
            testObject.addProperty("mediationStatus", summary.getMediationStatus());
            testObject.addProperty("assertionStatus", summary.getAssertionStatus());
            testObject.addProperty("exception", summary.getTestException());
            JsonArray jsonFailedAssertionArray = new JsonArray();
            for (TestCaseAssertionSummary assertionFailure : summary.getTestCaseAssertionList()) {
                JsonObject failedAssertionObject = new JsonObject();
                failedAssertionObject.addProperty("assertionType", assertionFailure.getAssertionType());
                failedAssertionObject.addProperty("assertionExpression", assertionFailure.getAssertionExpression());
                failedAssertionObject.addProperty("actual", assertionFailure.getAssertionActualValue());
                failedAssertionObject.addProperty("expected", assertionFailure.getAssertionExpectedValue());
                failedAssertionObject.addProperty("assertionDescription", assertionFailure.getAssertionDescription());
                failedAssertionObject.addProperty("message", assertionFailure.getAssertionErrorMessage());
                jsonFailedAssertionArray.add((JsonElement)failedAssertionObject);
            }
            if (jsonFailedAssertionArray.size() > 0) {
                testObject.add("failureAssertions", (JsonElement)jsonFailedAssertionArray);
            }
            jsonArray.add((JsonElement)testObject);
        }
        jsonResponse.add("testCases", (JsonElement)jsonArray);
        return jsonResponse;
    }

    private void checkTransportPassThroughPortAvailability() throws IOException {
        if (!this.isTransportPassThroughPortChecked) {
            log.info((Object)"Unit testing agent checks transport Pass-through HTTP Listener port");
            boolean isPassThroughPortNotOccupied = true;
            int transportPassThroughPort = Integer.parseInt(System.getProperty("http.nio.port"));
            long timeoutExpiredMs = System.currentTimeMillis() + 10000L;
            while (isPassThroughPortNotOccupied) {
                long waitMillis = timeoutExpiredMs - System.currentTimeMillis();
                isPassThroughPortNotOccupied = this.checkPortAvailability(transportPassThroughPort);
                if (waitMillis > 0L) continue;
                throw new IOException("Connection refused for http Pass-through HTTP Listener port - " + transportPassThroughPort);
            }
            this.isTransportPassThroughPortChecked = true;
        }
    }

    private void addRegistryResourcesToMockRegistry(Map<String, RegistryResource> resourceMap) {
        SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
        UnitTestMockRegistry mockRegistry = (UnitTestMockRegistry)synapseConfiguration.getRegistry();
        for (Map.Entry<String, RegistryResource> resource : resourceMap.entrySet()) {
            mockRegistry.addResource(resource.getKey(), resource.getValue());
        }
    }

    private void clearRegistryAndConnectorResources(SynapseTestCase synapseTestCases) {
        ArtifactData readArtifactData = synapseTestCases.getArtifacts();
        try {
            if (!readArtifactData.getConnectorResources().isEmpty()) {
                String connectorDestination = System.getProperty("java.io.tmpdir") + File.separator + "test";
                FileUtils.deleteDirectory((File)new File(connectorDestination));
                log.info((Object)"Removed connector resources from the temp directory");
            }
            if (!readArtifactData.getRegistryResources().isEmpty()) {
                SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
                UnitTestMockRegistry mockRegistry = (UnitTestMockRegistry)synapseConfiguration.getRegistry();
                mockRegistry.clearResources();
                log.info((Object)"Clear registry resources from the UnitTestMockRegistry");
            }
        }
        catch (IOException e) {
            log.error((Object)"Exception while removing mock connector directory in temp", (Throwable)e);
        }
    }

    private boolean checkPortAvailability(int port) {
        boolean isPortAvailable;
        try (Socket socketTester = new Socket();){
            socketTester.connect(new InetSocketAddress("127.0.0.1", port));
            isPortAvailable = false;
        }
        catch (IOException e) {
            isPortAvailable = true;
        }
        return isPortAvailable;
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            log.error((Object)"Error when closing socket connection", (Throwable)e);
        }
    }
}

