/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.synapse.commons.emulator.RequestProcessor;
import org.apache.synapse.commons.emulator.core.Emulator;
import org.apache.synapse.commons.emulator.http.HTTPProtocolEmulator;
import org.apache.synapse.commons.emulator.http.dsl.HttpConsumerContext;
import org.apache.synapse.commons.emulator.http.dsl.dto.consumer.IncomingMessage;
import org.apache.synapse.commons.emulator.http.dsl.dto.consumer.OutgoingMessage;
import org.apache.synapse.unittest.testcase.data.classes.ServiceResource;

class MockServiceCreator {
    private static Logger log = Logger.getLogger((String)MockServiceCreator.class.getName());
    private static List<HTTPProtocolEmulator> emulatorServiceList = new ArrayList<HTTPProtocolEmulator>();

    private MockServiceCreator() {
    }

    static void startMockServiceServer(String mockServiceName, String host, int port, String context, List<ServiceResource> resources) {
        try {
            HTTPProtocolEmulator httpEmulator = new Emulator().getHttpProtocolEmulator();
            emulatorServiceList.add(httpEmulator);
            HttpConsumerContext emulator = httpEmulator.consumer().host(host).port(port).context(context);
            for (ServiceResource resource : resources) {
                MockServiceCreator.routeThroughResourceMethod(resource, emulator);
            }
            emulator.operations().start();
            log.info((Object)("Mock service started for " + mockServiceName + " in - http://" + host + ":" + port + context));
        }
        catch (Exception e) {
            log.error((Object)("Error in initiating mock service named " + mockServiceName), (Throwable)e);
        }
    }

    private static void routeThroughResourceMethod(ServiceResource resource, HttpConsumerContext emulator) {
        int serviceResponseStatusCode = resource.getStatusCode();
        HttpResponseStatus responseStatus = HttpResponseStatus.valueOf((int)serviceResponseStatusCode);
        String serviceMethod = resource.getMethod();
        String serviceSubContext = resource.getSubContext();
        Map.Entry<String, Map<String, String>> checkQueryParamEntry = MockServiceCreator.splitQueryParams(serviceSubContext);
        serviceSubContext = checkQueryParamEntry.getKey();
        Map<String, String> queryParams = checkQueryParamEntry.getValue();
        String serviceRequestPayload = "";
        if (resource.getRequestPayload() != null) {
            serviceRequestPayload = RequestProcessor.trimStrings((String)resource.getRequestPayload());
        }
        String serviceResponsePayload = resource.getResponsePayload();
        List<Object> requestHeaders = new ArrayList();
        List<Object> responseHeaders = new ArrayList();
        if (resource.getRequestHeaders() != null) {
            requestHeaders = resource.getRequestHeaders();
        }
        if (resource.getResponseHeaders() != null) {
            responseHeaders = resource.getResponseHeaders();
        }
        switch (serviceMethod.toUpperCase()) {
            case "GET": {
                IncomingMessage incomingMessage = IncomingMessage.request().withMethod(HttpMethod.GET).withPath(serviceSubContext);
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    incomingMessage.withQueryParameter(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : requestHeaders) {
                    incomingMessage.withHeader((String)entry.getKey(), (String)entry.getValue());
                }
                emulator.when(incomingMessage);
                OutgoingMessage outGoingMessage = OutgoingMessage.response().withBody(serviceResponsePayload).withStatusCode(responseStatus);
                for (Map.Entry entry : responseHeaders) {
                    outGoingMessage.withHeader((String)entry.getKey(), (String)entry.getValue());
                }
                emulator.respond(outGoingMessage);
                break;
            }
            case "POST": {
                IncomingMessage incomingMessage = IncomingMessage.request().withMethod(HttpMethod.POST).withBody(serviceRequestPayload).withPath(serviceSubContext);
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    incomingMessage.withQueryParameter(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : requestHeaders) {
                    incomingMessage.withHeader((String)entry.getKey(), (String)entry.getValue());
                }
                emulator.when(incomingMessage);
                OutgoingMessage outGoingMessage = OutgoingMessage.response().withBody(serviceResponsePayload).withStatusCode(responseStatus);
                for (Map.Entry entry : responseHeaders) {
                    outGoingMessage.withHeader((String)entry.getKey(), (String)entry.getValue());
                }
                emulator.respond(outGoingMessage);
                break;
            }
            default: {
                IncomingMessage incomingMessage = IncomingMessage.request().withMethod(HttpMethod.GET).withPath(serviceSubContext);
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    incomingMessage.withQueryParameter(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : requestHeaders) {
                    incomingMessage.withHeader((String)entry.getKey(), (String)entry.getValue());
                }
                emulator.when(incomingMessage);
                OutgoingMessage outGoingMessage = OutgoingMessage.response().withBody(serviceResponsePayload).withStatusCode(responseStatus);
                for (Map.Entry entry : responseHeaders) {
                    outGoingMessage.withHeader((String)entry.getKey(), (String)entry.getValue());
                }
                emulator.respond(outGoingMessage);
            }
        }
    }

    static void stopServices() {
        for (HTTPProtocolEmulator emulatorService : emulatorServiceList) {
            emulatorService.shutdown();
        }
        emulatorServiceList.clear();
    }

    private static Map.Entry<String, Map<String, String>> splitQueryParams(String serviceSubContext) {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        try {
            String[] pairs;
            URL url = new URL("http://localhost" + serviceSubContext);
            String query = url.getQuery();
            serviceSubContext = url.getPath();
            if (query == null) {
                return new AbstractMap.SimpleEntry<String, Map<String, String>>(serviceSubContext, queryParams);
            }
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf(61);
                queryParams.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Error while checking query params", (Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error while creating URL of the mock service sub context", (Throwable)e);
        }
        return new AbstractMap.SimpleEntry<String, Map<String, String>>(serviceSubContext, queryParams);
    }
}

