/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.SynapseImportFactory;
import org.apache.synapse.config.xml.SynapseImportSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.deployers.LibraryArtifactDeployer;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.apache.synapse.unittest.UnitTestingExecutor;

class ConnectorDeployer {
    private static Logger log = Logger.getLogger((String)ConnectorDeployer.class.getName());
    private static final String SYNAPSE_CONFIG_LOCK = "synapse.config.lock";
    private static final String SYNAPSE_LIBS = "synapse-libs";
    private static final String SYNAPSE_LIBRARY_EXTENSION = "zip";

    private ConnectorDeployer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deployConnectorResources(List<String> connectorList) {
        for (int x = 0; x < connectorList.size(); ++x) {
            String javaTempTestDir = System.getProperty("java.io.tmpdir") + File.separator + "test";
            ConnectorDeployer.createDir(javaTempTestDir);
            FilterOutputStream out = null;
            try {
                byte[] decodedConnector = Base64.decode((String)connectorList.get(x));
                String connectorZip = javaTempTestDir + File.separator + "connector-" + x + ".zip";
                out = new BufferedOutputStream(new FileOutputStream(connectorZip), 4096);
                out.write(decodedConnector);
                LibDeployerUtils.createSynapseLibrary(connectorZip);
                SynapseConfiguration configuration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
                AxisConfiguration axisConfiguration = configuration.getAxisConfiguration();
                Deployer deployer = ConnectorDeployer.getSynapseLibraryDeployer(axisConfiguration);
                deployer.deploy(new DeploymentFileData(new File(connectorZip), deployer));
                try {
                    String artifactName = ConnectorDeployer.getArtifactName(connectorZip, axisConfiguration);
                    if (artifactName == null || configuration.getSynapseImports().get(artifactName) != null) continue;
                    String libName = artifactName.substring(artifactName.lastIndexOf("}") + 1);
                    String libraryPackage = artifactName.substring(1, artifactName.lastIndexOf("}"));
                    ConnectorDeployer.updateStatus(artifactName, libName, libraryPackage, "enabled", axisConfiguration);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Unable to update status for the synapse library : ", (Throwable)axisFault);
                }
                continue;
            }
            catch (DeploymentException e) {
                log.error((Object)"Error while deploying the synapse library : ", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                log.error((Object)"Error while writing the output stream of connector zip file", (Throwable)e);
                continue;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing the output stream of connector zip file", (Throwable)e);
                    }
                }
            }
        }
    }

    private static Deployer getSynapseLibraryDeployer(AxisConfiguration axisConfig) {
        try {
            String synapseLibraryPath = axisConfig.getRepository().getPath() + SYNAPSE_LIBS;
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            deploymentEngine.addDeployer((Deployer)new LibraryArtifactDeployer(), synapseLibraryPath, SYNAPSE_LIBRARY_EXTENSION);
            return deploymentEngine.getDeployer(synapseLibraryPath, SYNAPSE_LIBRARY_EXTENSION);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while getting the deployer");
            return null;
        }
    }

    private static String getArtifactName(String filePath, AxisConfiguration axisConfig) {
        SynapseArtifactDeploymentStore deploymentStore = ConnectorDeployer.getSynapseConfiguration(axisConfig).getArtifactDeploymentStore();
        return deploymentStore.getArtifactNameForFile(filePath);
    }

    private static boolean updateStatus(String libQName, String libName, String packageName, String status, AxisConfiguration axisConfig) throws AxisFault {
        try {
            SynapseConfiguration synapseConfiguration = ConnectorDeployer.getSynapseConfiguration(axisConfig);
            SynapseImport synapseImport = synapseConfiguration.getSynapseImports().get(libQName);
            if (synapseImport == null && libName != null && packageName != null) {
                ConnectorDeployer.addImport(libName, packageName, axisConfig);
                synapseImport = synapseConfiguration.getSynapseImports().get(libQName);
            }
            Library synLib = synapseConfiguration.getSynapseLibraries().get(libQName);
            if (libQName != null && synLib != null) {
                if ("enabled".equals(status)) {
                    synapseImport.setStatus(true);
                    synLib.setLibStatus(true);
                    synLib.loadLibrary();
                    ConnectorDeployer.deployingLocalEntries(synLib, synapseConfiguration, axisConfig);
                } else {
                    synapseImport.setStatus(false);
                    synLib.setLibStatus(false);
                    synLib.unLoadLibrary();
                    ConnectorDeployer.undeployingLocalEntries(synLib, synapseConfiguration, axisConfig);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to update status for :  " + libQName), (Throwable)e);
        }
        return true;
    }

    private static void undeployingLocalEntries(Library library, SynapseConfiguration config, AxisConfiguration axisConfig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Removing Local registry entries from the configuration");
        }
        for (Map.Entry<String, Object> libararyEntryMap : library.getLocalEntryArtifacts().entrySet()) {
            File localEntryFileObj = (File)libararyEntryMap.getValue();
            OMElement document = ConnectorDeployer.getOMElement(localEntryFileObj);
            ConnectorDeployer.deleteEntry(document.toString(), axisConfig);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End : Removing Local registry entries from the configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteEntry(String element, AxisConfiguration axisConfig) {
        Lock lock = ConnectorDeployer.getLock(axisConfig);
        String entryKey = null;
        try {
            OMElement elem;
            lock.lock();
            try {
                elem = ConnectorDeployer.nonCoalescingStringToOm(element);
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error while converting the file content : ", (Throwable)e);
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                entryKey = elem.getAttributeValue(new QName("key"));
                entryKey = entryKey.trim();
                log.debug((Object)("Adding local entry with key : " + entryKey));
                SynapseConfiguration synapseConfiguration = ConnectorDeployer.getSynapseConfiguration(axisConfig);
                Entry entry = synapseConfiguration.getDefinedEntries().get(entryKey);
                if (entry != null) {
                    synapseConfiguration.removeEntry(entryKey);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deleted local entry with key : " + entryKey));
                    }
                    boolean bl = true;
                    return bl;
                }
                log.warn((Object)("No entry exists by the key : " + entryKey));
                boolean bl = false;
                return bl;
            }
        }
        catch (SynapseException syne) {
            log.error((Object)("Unable to delete the local entry : " + entryKey), (Throwable)syne);
        }
        catch (Exception e) {
            log.error((Object)("Unable to delete the local entry : " + entryKey), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    private static void deployingLocalEntries(Library library, SynapseConfiguration config, AxisConfiguration axisConfig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Adding Local registry entries to the configuration");
        }
        for (Map.Entry<String, Object> libararyEntryMap : library.getLocalEntryArtifacts().entrySet()) {
            File localEntryFileObj = (File)libararyEntryMap.getValue();
            OMElement document = ConnectorDeployer.getOMElement(localEntryFileObj);
            ConnectorDeployer.addEntry(document.toString(), axisConfig);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End : Adding Local registry entries to the configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addEntry(String element, AxisConfiguration axisConfig) {
        Lock lock = ConnectorDeployer.getLock(axisConfig);
        try {
            OMElement elem;
            lock.lock();
            try {
                elem = ConnectorDeployer.nonCoalescingStringToOm(element);
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error while converting the file content : ", (Throwable)e);
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                String entryKey = elem.getAttributeValue(new QName("key"));
                entryKey = entryKey.trim();
                SynapseConfiguration synapseConfiguration = ConnectorDeployer.getSynapseConfiguration(axisConfig);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding local entry with key : " + entryKey));
                }
                if (synapseConfiguration.getLocalRegistry().containsKey(entryKey)) {
                    log.error((Object)("An Entry with key " + entryKey + " is already used within the configuration"));
                } else {
                    Entry entry = EntryFactory.createEntry(elem, synapseConfiguration.getProperties());
                    entry.setFileName(ConnectorDeployer.generateFileName(entry.getKey()));
                    synapseConfiguration.addEntry(entryKey, entry);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Local registry entry : " + entryKey + " added to the configuration"));
                }
                boolean bl = true;
                return bl;
            }
            log.warn((Object)"Error adding local entry. Invalid definition");
        }
        catch (SynapseException syne) {
            log.error((Object)"Unable to add local entry ", (Throwable)syne);
        }
        catch (OMException e) {
            log.error((Object)"Unable to add local entry. Invalid XML ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unable to add local entry. Invalid XML ", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    private static OMElement nonCoalescingStringToOm(String xmlStr) throws XMLStreamException {
        StringReader strReader = new StringReader(xmlStr);
        XMLInputFactory xmlInFac = XMLInputFactory.newInstance();
        xmlInFac.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader parser = xmlInFac.createXMLStreamReader(strReader);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private static Lock getLock(AxisConfiguration axisConfig) {
        Parameter parameter = axisConfig.getParameter(SYNAPSE_CONFIG_LOCK);
        if (parameter != null) {
            return (Lock)parameter.getValue();
        }
        log.warn((Object)"synapse.config.lock is null, Recreating a new lock");
        ReentrantLock lock = new ReentrantLock();
        try {
            axisConfig.addParameter(SYNAPSE_CONFIG_LOCK, (Object)lock);
            return lock;
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while setting synapse.config.lock", (Throwable)axisFault);
            return null;
        }
    }

    private static OMElement getOMElement(File file) {
        FileInputStream is;
        OMElement document = null;
        try {
            is = FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            log.error((Object)("Error while opening the file: " + file.getName() + " for reading"), (Throwable)e);
            return null;
        }
        try {
            document = new StAXOMBuilder((InputStream)is).getDocumentElement();
            document.build();
            is.close();
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while parsing the content of the file: " + file.getName()), (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)("Error while closing the input stream from the file: " + file.getName()), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error while building the content of the file: " + file.getName()), (Throwable)e);
        }
        return document;
    }

    private static SynapseConfiguration getSynapseConfiguration(AxisConfiguration axisConfig) {
        return (SynapseConfiguration)axisConfig.getParameter("synapse.config").getValue();
    }

    private static void addImport(String libName, String packageName, AxisConfiguration axisConfig) throws AxisFault {
        SynapseImport synImport = new SynapseImport();
        synImport.setLibName(libName);
        synImport.setLibPackage(packageName);
        OMElement impEl = SynapseImportSerializer.serializeImport(synImport);
        if (impEl != null) {
            try {
                ConnectorDeployer.addImport(impEl.toString(), axisConfig);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Could not add Synapse Import", (Throwable)axisFault);
            }
        } else {
            log.error((Object)("Could not add Synapse Import. Invalid import params for libName : " + libName + " packageName : " + packageName));
        }
    }

    private static void addImport(String xml, AxisConfiguration axisConfig) throws AxisFault {
        try {
            OMElement imprtElem = ConnectorDeployer.createElement(xml);
            SynapseImport synapseImport = SynapseImportFactory.createImport(imprtElem, null);
            if (synapseImport != null && synapseImport.getName() != null) {
                SynapseConfiguration synapseConfiguration = ConnectorDeployer.getSynapseConfiguration(axisConfig);
                String fileName = ConnectorDeployer.generateFileName(synapseImport.getName());
                synapseImport.setFileName(fileName);
                synapseConfiguration.addSynapseImport(synapseImport.getName(), synapseImport);
                String synImportQualfiedName = LibDeployerUtils.getQualifiedName(synapseImport);
                Library synLib = synapseConfiguration.getSynapseLibraries().get(synImportQualfiedName);
                if (synLib != null) {
                    LibDeployerUtils.loadLibArtifacts(synapseImport, synLib);
                }
            } else {
                log.error((Object)("Unable to create a Synapse Import for :  " + xml), null);
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)("Unable to create a Synapse Import for :  " + xml), (Throwable)e);
        }
    }

    private static OMElement createElement(String str) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }

    private static String generateFileName(String name) {
        return name.replaceAll("[\\/?*|:<> ]", "_") + ".xml";
    }

    private static void createDir(String path) {
        File temp = new File(path);
        if (!temp.exists() && !temp.mkdir()) {
            log.error((Object)("Error while creating directory : " + path));
        }
    }
}

