/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.deployers.APIDeployer;
import org.apache.synapse.deployers.EndpointDeployer;
import org.apache.synapse.deployers.LocalEntryDeployer;
import org.apache.synapse.deployers.ProxyServiceDeployer;
import org.apache.synapse.deployers.SequenceDeployer;
import org.apache.synapse.deployers.TemplateDeployer;
import org.apache.synapse.unittest.UnitTestingExecutor;

class ConfigurationDeployer {
    private Properties properties = new Properties();

    ConfigurationDeployer() {
    }

    Map.Entry<SynapseConfiguration, String> deploySequenceArtifact(OMElement inputElement, String fileName) throws AxisFault {
        SequenceDeployer sequenceDeployer = new SequenceDeployer();
        SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
        sequenceDeployer.init(this.createConfigurationContext(synapseConfiguration));
        String deployedArtifact = sequenceDeployer.deploySynapseArtifact(inputElement, fileName, this.properties);
        return new AbstractMap.SimpleEntry<SynapseConfiguration, String>(synapseConfiguration, deployedArtifact);
    }

    Map.Entry<SynapseConfiguration, String> deployProxyArtifact(OMElement inputElement, String fileName) throws AxisFault {
        ProxyServiceDeployer proxyServiceDeployer = new ProxyServiceDeployer();
        SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
        proxyServiceDeployer.init(this.createConfigurationContext(synapseConfiguration));
        String deployedArtifact = proxyServiceDeployer.deploySynapseArtifact(inputElement, fileName, this.properties);
        return new AbstractMap.SimpleEntry<SynapseConfiguration, String>(synapseConfiguration, deployedArtifact);
    }

    Map.Entry<SynapseConfiguration, String> deployApiArtifact(OMElement inputElement, String fileName) throws AxisFault {
        APIDeployer apiResourceDeployer = new APIDeployer();
        SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
        apiResourceDeployer.init(this.createConfigurationContext(synapseConfiguration));
        String deployedArtifact = apiResourceDeployer.deploySynapseArtifact(inputElement, fileName, this.properties);
        return new AbstractMap.SimpleEntry<SynapseConfiguration, String>(synapseConfiguration, deployedArtifact);
    }

    Map.Entry<SynapseConfiguration, String> deployEndpointArtifact(OMElement inputElement, String fileName) throws AxisFault {
        EndpointDeployer endpointDeployer = new EndpointDeployer();
        SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
        endpointDeployer.init(this.createConfigurationContext(synapseConfiguration));
        String deployedArtifact = endpointDeployer.deploySynapseArtifact(inputElement, fileName, this.properties);
        return new AbstractMap.SimpleEntry<SynapseConfiguration, String>(synapseConfiguration, deployedArtifact);
    }

    Map.Entry<SynapseConfiguration, String> deployLocalEntryArtifact(OMElement inputElement, String fileName) throws AxisFault {
        LocalEntryDeployer localEntryDeployer = new LocalEntryDeployer();
        SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
        localEntryDeployer.init(this.createConfigurationContext(synapseConfiguration));
        String deployedArtifact = localEntryDeployer.deploySynapseArtifact(inputElement, fileName, this.properties);
        return new AbstractMap.SimpleEntry<SynapseConfiguration, String>(synapseConfiguration, deployedArtifact);
    }

    Map.Entry<SynapseConfiguration, String> deployTemplateArtifact(OMElement inputElement, String fileName) throws AxisFault {
        TemplateDeployer templateDeployer = new TemplateDeployer();
        SynapseConfiguration synapseConfiguration = UnitTestingExecutor.getExecuteInstance().getSynapseConfiguration();
        templateDeployer.init(this.createConfigurationContext(synapseConfiguration));
        String deployedArtifact = templateDeployer.deploySynapseArtifact(inputElement, fileName, this.properties);
        return new AbstractMap.SimpleEntry<SynapseConfiguration, String>(synapseConfiguration, deployedArtifact);
    }

    private ConfigurationContext createConfigurationContext(SynapseConfiguration synapseConfiguration) throws AxisFault {
        AxisConfiguration axisConfiguration = synapseConfiguration.getAxisConfiguration();
        ConfigurationContext configurationContext = new ConfigurationContext(axisConfiguration);
        Axis2SynapseEnvironment synapseEnvironment = new Axis2SynapseEnvironment(configurationContext, synapseConfiguration);
        axisConfiguration.addParameter(new Parameter("synapse.env", (Object)synapseEnvironment));
        axisConfiguration.addParameter(new Parameter("synapse.config", (Object)synapseConfiguration));
        configurationContext.setAxisConfiguration(axisConfiguration);
        return configurationContext;
    }
}

