/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.synapse.unittest.MockServiceCreator;
import org.apache.synapse.unittest.testcase.data.classes.ServiceResource;
import org.apache.synapse.unittest.testcase.data.holders.MockServiceData;

public class ConfigModifier {
    private static Logger log = Logger.getLogger((String)ConfigModifier.class.getName());
    public static Map<String, Map<String, String>> unitTestMockEndpointMap = new HashMap<String, Map<String, String>>();

    private ConfigModifier() {
    }

    static String mockServiceLoader(MockServiceData mockServiceData) {
        ArrayList<Integer> mockServicePorts = new ArrayList<Integer>();
        for (int i = 0; i < mockServiceData.getMockServicesCount(); ++i) {
            String endpointName = mockServiceData.getMockServices(i).getServiceName();
            int serviceElementIndex = mockServiceData.getServiceNameIndex(endpointName);
            int port = mockServiceData.getMockServices(serviceElementIndex).getPort();
            String context = mockServiceData.getMockServices(serviceElementIndex).getContext();
            String cloneContext = context;
            if (cloneContext.equals("/")) {
                cloneContext = "";
            }
            String serviceURL = "http://localhost:" + port + cloneContext;
            HashMap<String, String> mockServiceResources = new HashMap<String, String>();
            for (ServiceResource resource : mockServiceData.getMockServices(serviceElementIndex).getResources()) {
                String resourcePath = resource.getSubContext();
                mockServiceResources.put(cloneContext + resourcePath, serviceURL + resourcePath);
            }
            mockServicePorts.add(port);
            unitTestMockEndpointMap.put(endpointName, mockServiceResources);
            log.info((Object)("Mock service creator ready to start service for " + endpointName));
            MockServiceCreator.startMockServiceServer(endpointName, "localhost", port, context, mockServiceData.getMockServices(serviceElementIndex).getResources());
        }
        if (!mockServicePorts.isEmpty()) {
            try {
                ConfigModifier.checkServiceStatus(mockServicePorts);
            }
            catch (IOException e) {
                log.error((Object)"Error occurred in checking services are ready to serve in given ports", (Throwable)e);
            }
        }
        return null;
    }

    private static void checkServiceStatus(ArrayList<Integer> mockServicePorts) throws IOException {
        log.info((Object)"Thread waiting for mock service(s) starting");
        for (int port : mockServicePorts) {
            boolean isAvailable = true;
            long timeoutExpiredMs = System.currentTimeMillis() + 5000L;
            while (isAvailable) {
                long waitMillis = timeoutExpiredMs - System.currentTimeMillis();
                isAvailable = ConfigModifier.checkPortAvailability(port);
                if (waitMillis > 0L) continue;
                throw new IOException("Connection refused for service in port - " + port);
            }
        }
        log.info((Object)"Mock service(s) are started with given ports");
    }

    private static boolean checkPortAvailability(int port) {
        boolean isAvailable;
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("localhost", port));
            isAvailable = false;
        }
        catch (IOException e) {
            isAvailable = true;
        }
        return isAvailable;
    }
}

