/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import com.google.gson.JsonParser;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.InputSource;

class CommonUtils {
    private CommonUtils() {
    }

    static String stackTraceToString(Throwable exception) {
        StringBuilder sb = new StringBuilder();
        sb.append(exception.getMessage());
        sb.append("\n");
        for (StackTraceElement element : exception.getStackTrace()) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    static String stackTraceToString(Throwable exception, String customErrorMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append(customErrorMessage);
        sb.append("\n");
        sb.append(exception.getMessage());
        sb.append("\n");
        for (StackTraceElement element : exception.getStackTrace()) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    static Map.Entry<String, String> checkInputStringFormat(String inputString) {
        String inputStringFormat;
        String trimedString = inputString.trim();
        if (trimedString.startsWith("<![CDATA[")) {
            int i = (trimedString = trimedString.substring(9)).indexOf("]]>");
            if (i == -1) {
                throw new IllegalStateException("argument starts with <![CDATA[ but cannot find pairing ]]>");
            }
            trimedString = trimedString.substring(0, i);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(trimedString)));
            inputStringFormat = "XML";
        }
        catch (Exception e) {
            try {
                new JsonParser().parse(trimedString).getAsJsonObject();
                inputStringFormat = "JSON";
            }
            catch (Exception exception) {
                inputStringFormat = "TEXT";
            }
        }
        return new AbstractMap.SimpleEntry<String, String>(inputStringFormat, trimedString);
    }
}

