/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.unittest;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.emulator.RequestProcessor;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.unittest.testcase.data.classes.AssertEqual;
import org.apache.synapse.unittest.testcase.data.classes.AssertNotNull;
import org.apache.synapse.unittest.testcase.data.classes.TestCase;
import org.apache.synapse.unittest.testcase.data.classes.TestCaseAssertionSummary;
import org.apache.synapse.unittest.testcase.data.classes.TestCaseSummary;

class Assertor {
    private static Logger log = Logger.getLogger((String)Assertor.class.getName());

    private Assertor() {
    }

    static void doAssertionSequence(TestCase currentTestCase, MessageContext mediateMsgCtxt, TestCaseSummary testCaseSummary) {
        List<AssertEqual> assertEquals = currentTestCase.getAssertEquals();
        List<AssertNotNull> assertNotNulls = currentTestCase.getAssertNotNull();
        String testCaseName = currentTestCase.getTestCaseName();
        if (!assertEquals.isEmpty()) {
            Assertor.startAssertEqualsForSequence(assertEquals, mediateMsgCtxt, testCaseSummary);
        }
        if (!assertNotNulls.isEmpty()) {
            Assertor.startAssertNotNullsForSequence(assertNotNulls, mediateMsgCtxt, testCaseSummary);
        }
        if (testCaseSummary.getTestCaseAssertionList().isEmpty()) {
            testCaseSummary.setAssertionStatus("PASSED");
            log.info((Object)("Unit testing passed for the test case - " + testCaseName));
        } else {
            testCaseSummary.setAssertionStatus("FAILED");
            log.error((Object)("Unit testing failed for the test case - " + testCaseName));
        }
    }

    static void doAssertionService(TestCase currentTestCase, Map.Entry<String, HttpResponse> response, TestCaseSummary testCaseSummary) {
        List<AssertEqual> assertEquals = currentTestCase.getAssertEquals();
        List<AssertNotNull> assertNotNulls = currentTestCase.getAssertNotNull();
        String testCaseName = currentTestCase.getTestCaseName();
        try {
            if (!assertEquals.isEmpty()) {
                Assertor.startAssertEqualsForServices(assertEquals, response, testCaseSummary);
            }
            if (!assertNotNulls.isEmpty()) {
                Assertor.startAssertNotNullsForServices(assertNotNulls, response, testCaseSummary);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while reading response from the service HttpResponse", (Throwable)e);
        }
        if (testCaseSummary.getTestCaseAssertionList().isEmpty()) {
            testCaseSummary.setAssertionStatus("PASSED");
            log.info((Object)("Unit testing passed for the test case - " + testCaseName));
        } else {
            testCaseSummary.setAssertionStatus("FAILED");
            log.error((Object)("Unit testing failed for the test case - " + testCaseName));
        }
    }

    private static void startAssertEqualsForSequence(List<AssertEqual> assertEquals, MessageContext messageContext, TestCaseSummary testCaseSummary) {
        log.info((Object)"AssertEquals - assert property for sequences started");
        for (AssertEqual assertItem : assertEquals) {
            TestCaseAssertionSummary testAssertion = new TestCaseAssertionSummary();
            AssertionPrerequisite.setAssertEqualPrerequisite(assertItem);
            String mediatedResult = "null";
            boolean isAssert = false;
            Axis2MessageContext axis2MessageContext = (Axis2MessageContext)messageContext;
            org.apache.axis2.context.MessageContext axis2MessageCtx = axis2MessageContext.getAxis2MessageContext();
            switch (AssertionPrerequisite.getExpressionPrefix()) {
                case "$body": {
                    try {
                        org.apache.axis2.context.MessageContext axis2MsgContxt = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
                        if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)axis2MsgContxt)) {
                            mediatedResult = JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)axis2MsgContxt) != null ? RequestProcessor.trimStrings((String)IOUtils.toString((InputStream)JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)axis2MsgContxt))) : "";
                        } else {
                            String omElement = messageContext.getEnvelope().getBody().getFirstElement().toString();
                            if (omElement.contains("http://ws.apache.org/commons/ns/payload")) {
                                OMElement omElementOfText = AXIOMUtil.stringToOM((String)omElement);
                                mediatedResult = RequestProcessor.trimStrings((String)omElementOfText.getText());
                            } else {
                                mediatedResult = RequestProcessor.trimStrings((String)omElement);
                            }
                        }
                    }
                    catch (XMLStreamException e) {
                        mediatedResult = "";
                        log.error((Object)"Exception while reading the text output from the message context", (Throwable)e);
                    }
                    catch (IOException e) {
                        mediatedResult = "";
                        log.error((Object)"Exception while reading the JSON output from the message context", (Throwable)e);
                    }
                    isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                    break;
                }
                case "$ctx": {
                    if (messageContext.getProperty(AssertionPrerequisite.getExpressionProperty()) == null) break;
                    mediatedResult = RequestProcessor.trimStrings((String)messageContext.getProperty(AssertionPrerequisite.getExpressionProperty()).toString());
                    isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                    break;
                }
                case "$axis2": {
                    if (axis2MessageCtx.getProperty(AssertionPrerequisite.getExpressionProperty()) == null) break;
                    mediatedResult = RequestProcessor.trimStrings((String)axis2MessageCtx.getProperty(AssertionPrerequisite.getExpressionProperty()).toString());
                    isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                    break;
                }
                case "$trp": {
                    Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                    Map headersMap = (Map)headers;
                    if (headersMap.get(AssertionPrerequisite.getExpressionProperty()) == null) break;
                    mediatedResult = RequestProcessor.trimStrings((String)headersMap.get(AssertionPrerequisite.getExpressionProperty()).toString());
                    isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                    break;
                }
                default: {
                    mediatedResult = "Received assert expression: " + AssertionPrerequisite.getAssertExpression() + " is not a valid operation type for sequences";
                    log.error((Object)mediatedResult);
                }
            }
            log.info((Object)("Sequence Assert Expression - " + AssertionPrerequisite.getAssertExpression()));
            log.info((Object)("Sequence mediated result for Actual - " + mediatedResult));
            log.info((Object)("Sequence Assert Expected - " + AssertionPrerequisite.getExpected()));
            if (isAssert) {
                log.info((Object)("Sequence assertEqual for " + AssertionPrerequisite.getAssertExpression() + " expression passed successfully"));
                continue;
            }
            testAssertion.setAssertionType("assertEquals");
            testAssertion.setAssertionExpression(AssertionPrerequisite.getAssertExpression());
            testAssertion.setAssertionExpectedValue(AssertionPrerequisite.getExpected());
            testAssertion.setAssertionActualValue(mediatedResult);
            testAssertion.setAssertionErrorMessage(AssertionPrerequisite.getMessage());
            testCaseSummary.addTestCaseAssertion(testAssertion);
            log.error((Object)("Sequence assertEqual for " + AssertionPrerequisite.getAssertExpression() + " expression failed with a message - " + AssertionPrerequisite.getMessage()));
        }
    }

    private static void startAssertNotNullsForSequence(List<AssertNotNull> assertNotNull, MessageContext messageContext, TestCaseSummary testCaseSummary) {
        log.info((Object)"Assert Not Null - assert property for sequences started");
        for (AssertNotNull assertItem : assertNotNull) {
            TestCaseAssertionSummary testAssertion = new TestCaseAssertionSummary();
            AssertionPrerequisite.setAssertNotNullPrerequisite(assertItem);
            boolean isAssertNull = true;
            String mediatedResult = "null";
            Axis2MessageContext axis2MessageContext = (Axis2MessageContext)messageContext;
            org.apache.axis2.context.MessageContext axis2MessageCtx = axis2MessageContext.getAxis2MessageContext();
            switch (AssertionPrerequisite.getExpressionPrefix()) {
                case "$body": {
                    isAssertNull = messageContext.getEnvelope().getBody().getFirstElement() == null;
                    break;
                }
                case "$ctx": {
                    isAssertNull = messageContext.getProperty(AssertionPrerequisite.getExpressionProperty()) == null;
                    break;
                }
                case "$axis2": {
                    isAssertNull = axis2MessageCtx.getProperty(AssertionPrerequisite.getExpressionProperty()) == null;
                    break;
                }
                case "$trp": {
                    Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                    Map headersMap = (Map)headers;
                    isAssertNull = headersMap.get(AssertionPrerequisite.getExpressionProperty()) == null;
                    break;
                }
                default: {
                    mediatedResult = "Received assert expression: " + AssertionPrerequisite.getAssertExpression() + " is not a valid operation type for sequences";
                    log.error((Object)mediatedResult);
                }
            }
            log.info((Object)("Sequence Assertion Expression - " + AssertionPrerequisite.getAssertExpression()));
            log.info((Object)("Sequence mediated result for assertNotNull is " + !isAssertNull));
            if (!isAssertNull) {
                log.info((Object)("Sequence assertNotNull for " + AssertionPrerequisite.getAssertExpression() + " expression passed successfully"));
                continue;
            }
            testAssertion.setAssertionType("assertNotNull");
            testAssertion.setAssertionExpression(AssertionPrerequisite.getAssertExpression());
            testAssertion.setAssertionActualValue(mediatedResult);
            testAssertion.setAssertionErrorMessage(AssertionPrerequisite.getMessage());
            testCaseSummary.addTestCaseAssertion(testAssertion);
            log.error((Object)("Sequence assertNotNull for " + AssertionPrerequisite.getAssertExpression() + " expression failed with a message - " + AssertionPrerequisite.getMessage()));
        }
    }

    private static void startAssertEqualsForServices(List<AssertEqual> assertEquals, Map.Entry<String, HttpResponse> response, TestCaseSummary testCaseSummary) throws IOException {
        log.info((Object)"Assert Equals - assert property for services started");
        for (AssertEqual assertItem : assertEquals) {
            TestCaseAssertionSummary testAssertion = new TestCaseAssertionSummary();
            AssertionPrerequisite.setAssertEqualPrerequisite(assertItem);
            String mediatedResult = "null";
            HttpResponse serviceResponse = response.getValue();
            HttpEntity responseEntity = serviceResponse.getEntity();
            boolean isAssert = false;
            block6 : switch (AssertionPrerequisite.getExpressionPrefix()) {
                case "$body": {
                    if (responseEntity == null) break;
                    mediatedResult = RequestProcessor.trimStrings((String)EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8"));
                    isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                    break;
                }
                case "$statusCode": {
                    if (serviceResponse.getStatusLine() == null) break;
                    mediatedResult = Integer.toString(serviceResponse.getStatusLine().getStatusCode());
                    isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                    break;
                }
                case "$httpVersion": {
                    if (serviceResponse.getStatusLine().getProtocolVersion() == null) break;
                    mediatedResult = serviceResponse.getStatusLine().getProtocolVersion().toString();
                    isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                    break;
                }
                case "$trp": {
                    Header[] responseHeaders = serviceResponse.getAllHeaders();
                    if (responseHeaders == null) break;
                    for (Header header : responseHeaders) {
                        if (header.getName() == null || !header.getName().equals(AssertionPrerequisite.getExpressionProperty())) continue;
                        if (header.getValue() == null) break block6;
                        mediatedResult = RequestProcessor.trimStrings((String)header.getValue());
                        isAssert = AssertionPrerequisite.getExpected().equals(mediatedResult);
                        break block6;
                    }
                    break;
                }
                default: {
                    mediatedResult = "Received assert expression: " + AssertionPrerequisite.getAssertExpression() + " is not a valid operation type for services";
                    log.error((Object)mediatedResult);
                }
            }
            log.info((Object)("Service Assert Expression - " + AssertionPrerequisite.getAssertExpression()));
            log.info((Object)("Service mediated result for Actual - " + mediatedResult));
            log.info((Object)("Service Assert Expected - " + AssertionPrerequisite.getExpected()));
            if (isAssert) {
                log.info((Object)("Service assertEquals for " + AssertionPrerequisite.getAssertExpression() + " expression passed successfully"));
                continue;
            }
            testAssertion.setAssertionType("assertEquals");
            testAssertion.setAssertionExpression(AssertionPrerequisite.getAssertExpression());
            testAssertion.setAssertionExpectedValue(AssertionPrerequisite.getExpected());
            testAssertion.setAssertionActualValue(mediatedResult);
            if (mediatedResult.equals("null")) {
                testAssertion.setAssertionDescription("Tested service url - " + response.getKey() + "\nReceived status code - " + (serviceResponse.getStatusLine() != null ? Integer.valueOf(serviceResponse.getStatusLine().getStatusCode()) : "null"));
            }
            testAssertion.setAssertionErrorMessage(AssertionPrerequisite.getMessage());
            testCaseSummary.addTestCaseAssertion(testAssertion);
            log.error((Object)("Service assertEquals for " + AssertionPrerequisite.getAssertExpression() + " expression failed with a message - " + AssertionPrerequisite.getMessage()));
        }
    }

    private static void startAssertNotNullsForServices(List<AssertNotNull> assertNotNull, Map.Entry<String, HttpResponse> response, TestCaseSummary testCaseSummary) {
        log.info((Object)"Assert Not Null - assert property for services started");
        for (AssertNotNull assertItem : assertNotNull) {
            TestCaseAssertionSummary testAssertion = new TestCaseAssertionSummary();
            AssertionPrerequisite.setAssertNotNullPrerequisite(assertItem);
            boolean isAssertNull = true;
            HttpResponse serviceResponse = response.getValue();
            String mediatedResult = "null";
            block6 : switch (AssertionPrerequisite.getExpressionPrefix()) {
                case "$body": {
                    isAssertNull = serviceResponse.getEntity() == null;
                    break;
                }
                case "$statusCode": {
                    isAssertNull = serviceResponse.getStatusLine() == null;
                    break;
                }
                case "$httpVersion": {
                    if (serviceResponse.getStatusLine() == null) break;
                    isAssertNull = serviceResponse.getStatusLine().getProtocolVersion() == null;
                    break;
                }
                case "$trp": {
                    Header[] responseHeaders = serviceResponse.getAllHeaders();
                    if (responseHeaders == null) break;
                    for (Header header : responseHeaders) {
                        if (!header.getName().equals(AssertionPrerequisite.getExpressionProperty())) continue;
                        isAssertNull = header.getValue() == null;
                        break block6;
                    }
                    break;
                }
                default: {
                    mediatedResult = "Received assert expression: " + AssertionPrerequisite.getAssertExpression() + " is not a valid operation type for services";
                    log.error((Object)mediatedResult);
                }
            }
            log.info((Object)("Service Assert Actual - " + AssertionPrerequisite.getAssertExpression()));
            log.info((Object)("Service mediated result for assertNotNull is - " + !isAssertNull));
            if (!isAssertNull) {
                log.info((Object)("Service assertNotNull for " + AssertionPrerequisite.getAssertExpression() + " expression passed successfully"));
                continue;
            }
            testAssertion.setAssertionType("assertNotNull");
            testAssertion.setAssertionExpression(AssertionPrerequisite.getAssertExpression());
            testAssertion.setAssertionActualValue(mediatedResult);
            testAssertion.setAssertionDescription("Tested service url - " + response.getKey() + "\nRecieved status code - " + (serviceResponse.getStatusLine() != null ? Integer.valueOf(serviceResponse.getStatusLine().getStatusCode()) : "null"));
            testAssertion.setAssertionErrorMessage(AssertionPrerequisite.getMessage());
            testCaseSummary.addTestCaseAssertion(testAssertion);
            log.error((Object)("Service assertNotNull for " + AssertionPrerequisite.getAssertExpression() + " expression failed with a message - " + AssertionPrerequisite.getMessage()));
        }
    }

    static class AssertionPrerequisite {
        private static String assertExpression;
        private static String message;
        private static String expected;
        private static String expressionPrefix;
        private static String expressionProperty;

        private AssertionPrerequisite() {
        }

        static void setAssertEqualPrerequisite(AssertEqual assertItem) {
            assertExpression = assertItem.getActual();
            message = assertItem.getMessage();
            expected = RequestProcessor.trimStrings((String)assertItem.getExpected());
            String[] expressionType = assertExpression.split(":", 2);
            expressionPrefix = expressionType[0];
            if (expressionType.length == 2) {
                expressionProperty = expressionType[1];
            }
        }

        static void setAssertNotNullPrerequisite(AssertNotNull assertItem) {
            assertExpression = assertItem.getActual();
            message = assertItem.getMessage();
            String[] expressionType = assertExpression.split(":", 2);
            expressionPrefix = expressionType[0];
            if (expressionType.length == 2) {
                expressionProperty = expressionType[1];
            }
        }

        static String getAssertExpression() {
            return assertExpression;
        }

        static String getMessage() {
            return message;
        }

        static String getExpressionPrefix() {
            return expressionPrefix;
        }

        static String getExpressionProperty() {
            return expressionProperty;
        }

        static String getExpected() {
            return expected;
        }
    }
}

