/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.tasks;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.InvokeMediator;
import org.apache.synapse.task.Task;

public class TemplateMessageExecutor
implements Task,
ManagedLifecycle {
    private SynapseEnvironment synapseEnvironment;
    private SequenceMediator seqMed;
    private String templateKey;
    private OMElement templateParams;
    private InvokeMediator invoker;

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
        this.invoker = new InvokeMediator();
        this.invoker.setTargetTemplate(this.templateKey);
        this.buildParameters(this.templateParams);
        if (se.getSynapseConfiguration().getSequence("_Hidden_Sequence_" + this.templateKey.hashCode()) != null) {
            se.getSynapseConfiguration().removeSequence("_Hidden_Sequence_" + this.templateKey.hashCode());
        }
        this.seqMed = new SequenceMediator();
        this.seqMed.setName("_Hidden_Sequence_" + this.templateKey.hashCode());
        this.seqMed.addChild(this.invoker);
        se.getSynapseConfiguration().addSequence(this.seqMed.getName(), this.seqMed);
    }

    @Override
    public void destroy() {
    }

    public void execute() {
        MessageContext mc = this.synapseEnvironment.createMessageContext();
        mc.pushFaultHandler(new MediatorFaultHandler(mc.getFaultSequence()));
        this.synapseEnvironment.injectAsync(mc, this.seqMed);
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    public OMElement getTemplateParams() {
        return this.templateParams;
    }

    public void setTemplateParams(OMElement templateParams) {
        this.templateParams = templateParams;
    }

    private void buildParameters(OMElement elem) {
        Iterator subElements = elem.getChildElements();
        while (subElements.hasNext()) {
            OMElement child = (OMElement)subElements.next();
            Value paramValue = new ValueFactory().createTextValue(child);
            this.invoker.addExpressionForParamName(child.getLocalName(), paramValue);
        }
    }
}

