/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.AbstractStartup;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import org.apache.synapse.task.SynapseTaskManager;
import org.apache.synapse.task.Task;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskManager;
import org.apache.synapse.task.TaskScheduler;

public class StartUpController
extends AbstractStartup {
    private static final Log logger = LogFactory.getLog((String)StartUpController.class.getName());
    private SynapseEnvironment synapseEnvironment;
    private TaskDescription taskDescription;
    private SynapseTaskManager synapseTaskManager;
    private Object task = null;

    @Override
    public QName getTagQName() {
        return SimpleQuartzFactory.TASK;
    }

    public void destroy(boolean removeTask) {
        if (!this.destroyTask()) {
            return;
        }
        if (!this.synapseTaskManager.isInitialized() && this.synapseEnvironment != null) {
            this.init(this.synapseEnvironment);
        }
        if (this.synapseTaskManager.isInitialized()) {
            TaskDescriptionRepository repository;
            TaskScheduler taskScheduler = this.synapseTaskManager.getTaskScheduler();
            if (taskScheduler != null && taskScheduler.isInitialized() && removeTask) {
                taskScheduler.deleteTask(this.taskDescription.getName(), this.taskDescription.getTaskGroup());
            }
            if ((repository = this.synapseTaskManager.getTaskDescriptionRepository()) != null) {
                repository.removeTaskDescription(this.taskDescription.getName());
            }
        }
    }

    @Override
    public void destroy() {
        this.destroy(true);
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        this.synapseEnvironment = synapseEnvironment;
        if (this.taskDescription == null) {
            StartUpController.handleException("Error while initializing the startup. TaskDescription is null.");
        }
        this.initSynapseTaskManager(synapseEnvironment);
        TaskDescriptionRepository repository = this.synapseTaskManager.getTaskDescriptionRepository();
        if (repository == null) {
            StartUpController.handleException("Task Description Repository cannot be found");
            return;
        }
        repository.addTaskDescription(this.taskDescription);
        if (!this.processPinnedServers(this.taskDescription, synapseEnvironment)) {
            return;
        }
        this.resolveTaskImpl(this.taskDescription, synapseEnvironment);
        this.loadTaskProperties();
        this.initializeTask(synapseEnvironment);
        if (this.taskDescription.getResource("Instance") == null || this.taskDescription.getResource("ClassName") == null) {
            this.taskDescription.addResource("Instance", this.task);
            this.taskDescription.addResource("ClassName", (Object)this.task.getClass().getName());
        }
        try {
            HashMap<String, SynapseEnvironment> map = new HashMap<String, SynapseEnvironment>();
            map.put("SynapseEnvironment", synapseEnvironment);
            TaskScheduler taskScheduler = this.synapseTaskManager.getTaskScheduler();
            TaskManager taskManager = this.synapseTaskManager.getTaskManagerImpl();
            if (taskManager == null) {
                logger.error((Object)"Could not initialize Start up controller. TaskManager not found.");
                return;
            }
            taskManager.setProperties(map);
            taskScheduler.init(synapseEnvironment.getSynapseConfiguration().getProperties(), taskManager);
            this.submitTask(taskScheduler, this.taskDescription);
            logger.debug((Object)("Submitted task [" + this.taskDescription.getName() + "] to Synapse task scheduler."));
        }
        catch (Exception e) {
            String msg = "Error starting up Scheduler : " + e.getLocalizedMessage();
            logger.fatal((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    private void initializeTask(SynapseEnvironment synapseEnvironment) {
        if (this.task instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.task).init(synapseEnvironment);
        }
    }

    private boolean destroyTask() {
        if (this.taskDescription == null) {
            logger.debug((Object)"No task found to delete.");
            return false;
        }
        if (this.task instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.task).destroy();
        }
        return true;
    }

    private void loadTaskProperties() {
        Set properties = this.taskDescription.getXmlProperties();
        for (Object property : properties) {
            OMElement prop = (OMElement)property;
            logger.debug((Object)("loaded task property : " + prop.toString()));
            PropertyHelper.setStaticProperty((OMElement)prop, (Object)this.task);
        }
    }

    private boolean initSynapseTaskManager(SynapseEnvironment synapseEnvironment) {
        this.synapseTaskManager = synapseEnvironment.getTaskManager();
        if (!this.synapseTaskManager.isInitialized()) {
            logger.warn((Object)"SynapseTaskManager is not properly initialized. Initializing now with default parameters.");
            this.synapseTaskManager.init(null, null, null);
        }
        return true;
    }

    private boolean submitTask(TaskScheduler taskScheduler, TaskDescription taskDescription) {
        if (taskDescription == null) {
            return false;
        }
        if (taskScheduler != null) {
            return taskScheduler.scheduleTask(taskDescription);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TaskScheduler cannot be found for :task_scheduler , therefore ignore scheduling of Task  " + taskDescription));
        }
        return false;
    }

    private boolean processPinnedServers(TaskDescription taskDescription, SynapseEnvironment synapseEnvironment) {
        String thisServerName = synapseEnvironment.getServerContextInformation().getServerConfigurationInformation().getServerName();
        if (thisServerName == null || thisServerName.equals("")) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                thisServerName = address.getHostName();
            }
            catch (UnknownHostException e) {
                logger.warn((Object)"Could not get the host name", (Throwable)e);
            }
            if (thisServerName == null || thisServerName.equals("")) {
                thisServerName = "localhost";
            }
        }
        logger.debug((Object)("Synapse server name : " + thisServerName));
        List pinnedServers = taskDescription.getPinnedServers();
        if (pinnedServers != null && !pinnedServers.isEmpty() && !pinnedServers.contains(thisServerName)) {
            logger.info((Object)("Server name not in pinned servers list. Not starting Task : " + this.getName()));
            return false;
        }
        return true;
    }

    private boolean resolveTaskImpl(TaskDescription taskDescription, SynapseEnvironment synapseEnvironment) {
        if (synapseEnvironment == null) {
            return false;
        }
        String taskImplClassName = taskDescription.getTaskImplClassName();
        if (taskImplClassName == null || taskImplClassName.isEmpty()) {
            taskImplClassName = "org.apache.synapse.startup.tasks.MessageInjector";
        }
        taskDescription.setTaskImplClassName(taskImplClassName);
        try {
            this.task = this.getClass().getClassLoader().loadClass(taskDescription.getTaskImplClassName()).newInstance();
            if (!(this.task instanceof Task)) {
                logger.warn((Object)"Task implementation is not a Synapse Task.");
            }
        }
        catch (Exception e) {
            StartUpController.handleException("Cannot instantiate task : " + taskDescription.getTaskImplClassName(), e);
        }
        return true;
    }

    private static void handleException(String message) {
        logger.error((Object)message);
        throw new SynapseException(message);
    }

    private static void handleException(String message, Exception e) {
        logger.error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }

    public TaskDescription getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(TaskDescription taskDescription) {
        this.taskDescription = taskDescription;
    }
}

