/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.StartupFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.startup.quartz.SimpleQuartzSerializer;
import org.apache.synapse.startup.quartz.StartUpController;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionFactory;

public class SimpleQuartzFactory
implements StartupFactory {
    public static final QName TASK = new QName("http://ws.apache.org/ns/synapse", "task");
    private static final Log log = LogFactory.getLog(SimpleQuartzFactory.class);

    @Override
    public Startup createStartup(OMElement el) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating StartUpController Task");
        }
        if (el.getQName().equals(TASK)) {
            StartUpController startUpController = new StartUpController();
            TaskDescription taskDescription = TaskDescriptionFactory.createTaskDescription((OMElement)el, (OMNamespace)XMLConfigConstants.SYNAPSE_OMNAMESPACE);
            if (taskDescription == null) {
                this.handleException("Invalid task - Task description can not be created  from :" + el);
                return null;
            }
            startUpController.setName(taskDescription.getName());
            startUpController.setTaskDescription(taskDescription);
            startUpController.setDescription(taskDescription.getTaskDescription());
            return startUpController;
        }
        this.handleException("Syntax error in the task : wrong QName for the task");
        return null;
    }

    public Class<SimpleQuartzSerializer> getSerializerClass() {
        return SimpleQuartzSerializer.class;
    }

    @Override
    public QName getTagQName() {
        return TASK;
    }

    private void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

