/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.quartz.SimpleQuartzJob;
import org.apache.synapse.task.DefaultTaskJobDetailFactory;
import org.apache.synapse.task.DefaultTaskTriggerFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.Task;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskJobDetailFactory;
import org.apache.synapse.task.TaskManager;
import org.apache.synapse.task.TaskManagerObserver;
import org.apache.synapse.task.TaskTriggerFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.utils.Key;

public class QuartzTaskManager
implements TaskManager {
    private static final Log logger = LogFactory.getLog((String)QuartzTaskManager.class.getName());
    private static final Object lock = new Object();
    private Scheduler scheduler;
    private boolean initialized = false;
    private TaskTriggerFactory triggerFactory = new DefaultTaskTriggerFactory();
    private TaskJobDetailFactory jobDetailFactory = new DefaultTaskJobDetailFactory();
    public static final String QUARTZ_CONF = "quartz.conf";
    private String name;
    protected final Properties configProperties = new Properties();
    private Map<String, Object> properties = new HashMap<String, Object>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(TaskDescription taskDescription) {
        block27: {
            Object className;
            JobDetail jobDetail;
            Trigger trigger;
            this.assertInitialized();
            this.assertStarted();
            if (taskDescription == null) {
                throw new SynapseTaskException("Task Description cannot be found", logger);
            }
            Object object = lock;
            synchronized (object) {
                if (this.triggerFactory == null) {
                    throw new SynapseTaskException("TriggerFactory cannot be found", logger);
                }
                if (this.jobDetailFactory == null) {
                    throw new SynapseTaskException("JobDetailFactory cannot be found", logger);
                }
                trigger = this.triggerFactory.createTrigger(taskDescription);
                if (trigger == null) {
                    throw new SynapseTaskException("Trigger cannot be created from : " + taskDescription, logger);
                }
                jobDetail = this.jobDetailFactory.createJobDetail(taskDescription, taskDescription.getResources(), SimpleQuartzJob.class);
                if (jobDetail == null) {
                    throw new SynapseTaskException("JobDetail cannot be created from : " + taskDescription + " and job class " + taskDescription.getTaskImplClassName(), logger);
                }
            }
            Object clsInstance = taskDescription.getResource("Instance");
            if (clsInstance == null) {
                className = (String)taskDescription.getProperty("ClassName");
                try {
                    clsInstance = Class.forName((String)className).newInstance();
                    if (clsInstance instanceof ManagedLifecycle) {
                        Object se = this.properties.get("SynapseEnvironment");
                        if (!(se instanceof SynapseEnvironment)) {
                            return false;
                        }
                        ((ManagedLifecycle)clsInstance).init((SynapseEnvironment)se);
                    }
                    for (Object property : taskDescription.getXmlProperties()) {
                        OMElement prop = (OMElement)property;
                        logger.debug((Object)("Found Property : " + prop.toString()));
                        PropertyHelper.setStaticProperty((OMElement)prop, (Object)clsInstance);
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)("Could not schedule task[" + this.name + "]."), (Throwable)e);
                    return false;
                }
                catch (InstantiationException e) {
                    logger.error((Object)("Could not schedule task[" + this.name + "]."), (Throwable)e);
                    return false;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)("Could not schedule task[" + this.name + "]."), (Throwable)e);
                    return false;
                }
            }
            if (!(clsInstance instanceof Task)) {
                logger.error((Object)("Could not schedule task[" + this.name + "]. Cannot load class org.apache.synapse.startup.quartz.SimpleQuartzJob"));
                return false;
            }
            jobDetail.getJobDataMap().put("Instance", clsInstance);
            jobDetail.getJobDataMap().put("ClassName", clsInstance.getClass().toString());
            jobDetail.getJobDataMap().put("SynapseEnvironment", this.getProperty("SynapseEnvironment"));
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("scheduling job : " + jobDetail + " with trigger " + trigger));
                }
                if (taskDescription.getCount() != 0 && !this.isTaskRunning(jobDetail.getKey())) {
                    try {
                        className = lock;
                        synchronized (className) {
                            this.scheduler.scheduleJob(jobDetail, trigger);
                            break block27;
                        }
                    }
                    catch (ObjectAlreadyExistsException e) {
                        logger.warn((Object)("did not schedule the job : " + jobDetail + ". the job is already running."));
                    }
                    break block27;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("did not schedule the job : " + jobDetail + ". count is zero."));
                }
            }
            catch (SchedulerException e) {
                throw new SynapseTaskException("Error scheduling job : " + jobDetail + " with trigger " + trigger);
            }
        }
        logger.info((Object)("Scheduled task [" + taskDescription.getName() + "::" + taskDescription.getTaskGroup() + "]"));
        return true;
    }

    public boolean reschedule(String name, TaskDescription taskDescription) {
        logger.error((Object)("reschedule not supported. Task name: " + name));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String nameGroup) {
        boolean deleteResult;
        if (nameGroup == null) {
            return false;
        }
        this.assertInitialized();
        this.assertStarted();
        String[] list = nameGroup.split("::");
        String name = list[0];
        String group = list[1];
        if (name == null || "".equals(name)) {
            throw new SynapseTaskException("Task name is null", logger);
        }
        if (group == null || "".equals(group)) {
            group = "synapse.simple.quartz";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Task group is null or empty , using default group :synapse.simple.quartz");
            }
        }
        try {
            Object object = lock;
            synchronized (object) {
                deleteResult = this.scheduler.deleteJob(new JobKey(name, group));
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Cannot delete task [" + name + "::" + group + "]");
        }
        logger.debug((Object)("Deleted task [" + name + "::" + group + "] [" + deleteResult + "]"));
        return true;
    }

    public boolean pause(String name) {
        logger.error((Object)("pause not supported. Task name : " + name));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseAll() {
        try {
            this.assertInitialized();
            this.assertStarted();
            Object object = lock;
            synchronized (object) {
                this.scheduler.pauseAll();
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error pausing tasks ", (Throwable)e, logger);
        }
        return true;
    }

    public boolean resume(String name) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeAll() {
        try {
            this.assertInitialized();
            this.assertStarted();
            Object object = lock;
            synchronized (object) {
                this.scheduler.resumeAll();
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error resuming tasks ", (Throwable)e, logger);
        }
        return true;
    }

    public TaskDescription getTask(String name) {
        return null;
    }

    public String[] getTaskNames() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Properties properties) {
        Object quartzConf;
        StdSchedulerFactory sf = new StdSchedulerFactory();
        if (properties != null) {
            quartzConf = properties.getProperty(QUARTZ_CONF);
            try {
                if (quartzConf != null && !"".equals(quartzConf)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Initiating a Scheduler with configuration : " + (String)quartzConf));
                    }
                    sf.initialize((String)quartzConf);
                }
            }
            catch (SchedulerException e) {
                throw new SynapseTaskException("Error initiating scheduler factory " + sf + "with configuration loaded from " + (String)quartzConf, (Throwable)e, logger);
            }
        }
        try {
            quartzConf = lock;
            synchronized (quartzConf) {
                if (this.name != null) {
                    this.scheduler = sf.getScheduler(this.name);
                }
                if (this.scheduler == null) {
                    this.scheduler = sf.getScheduler();
                }
                this.initialized = true;
                logger.info((Object)"initialized");
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error getting a  scheduler instance form scheduler factory " + sf, (Throwable)e, logger);
        }
        return true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        this.assertInitialized();
        try {
            Object object = lock;
            synchronized (object) {
                if (!this.scheduler.isStarted()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Starting a Scheduler : [ " + this.scheduler.getMetaData() + " ]"));
                    }
                    this.scheduler.start();
                }
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error starting scheduler ", (Throwable)e, logger);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        if (this.isInitialized()) {
            try {
                Object object = lock;
                synchronized (object) {
                    if (this.scheduler != null && this.scheduler.isStarted()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("ShuttingDown Task Scheduler : " + this.scheduler.getMetaData()));
                        }
                        this.scheduler.shutdown();
                    }
                    this.initialized = false;
                }
            }
            catch (SchedulerException e) {
                throw new SynapseTaskException("Error ShuttingDown task scheduler ", (Throwable)e, logger);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningTaskCount() {
        int runningTasks = 0;
        try {
            Object object = lock;
            synchronized (object) {
                if (this.scheduler != null) {
                    runningTasks = this.scheduler.getCurrentlyExecutingJobs().size();
                }
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"Error querying currently executing jobs", (Throwable)e);
        }
        return runningTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskRunning(Object taskKey) {
        if (!(taskKey instanceof JobKey)) {
            return false;
        }
        try {
            List currentJobs;
            Object object = lock;
            synchronized (object) {
                currentJobs = this.scheduler.getCurrentlyExecutingJobs();
            }
            for (JobExecutionContext jobCtx : currentJobs) {
                JobKey currentJobKey = jobCtx.getJobDetail().getKey();
                if (currentJobKey.compareTo((Key)((JobKey)taskKey)) != 0) continue;
                logger.warn((Object)"the job is already running");
                return true;
            }
        }
        catch (SchedulerException e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProperties(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            Object object = lock;
            synchronized (object) {
                this.properties.put(key, properties.get(key));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProperty(String name, Object property) {
        Object object = lock;
        synchronized (object) {
            if ("Q_TASK_TRIGGER_FACTORY".equals(name) && property instanceof TaskTriggerFactory) {
                this.triggerFactory = (TaskTriggerFactory)property;
            }
            if ("Q_TASK_JOB_DETAIL_FACTORY".equals(name) && property instanceof TaskJobDetailFactory) {
                this.jobDetailFactory = (TaskJobDetailFactory)property;
            }
            this.properties.put(name, property);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        if (name == null) {
            return null;
        }
        Object object = lock;
        synchronized (object) {
            return this.properties.get(name);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderClass() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConfigurationProperties() {
        Object object = lock;
        synchronized (object) {
            return this.configProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationProperties(Properties properties) {
        Object object = lock;
        synchronized (object) {
            this.configProperties.putAll((Map<?, ?>)properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInitialized() {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                throw new SynapseTaskException("Scheduler has not been initialled yet", logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertStarted() {
        try {
            Object object = lock;
            synchronized (object) {
                if (!this.scheduler.isStarted()) {
                    throw new SynapseTaskException("Scheduler has not been started yet", logger);
                }
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error determine start state of the scheduler ", (Throwable)e, logger);
        }
    }

    public void addObserver(TaskManagerObserver o) {
    }

    public boolean isTaskDeactivated(String taskName) {
        return false;
    }

    public boolean isTaskBlocked(String taskName) {
        return false;
    }

    public boolean isTaskRunning(String taskName) {
        return false;
    }

    public void sendClusterMessage(Callable<Void> task) {
    }

    public boolean isTaskExist(String arg0) {
        return false;
    }
}

