/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.resequencer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.store.impl.jdbc.JDBCMessageStore;
import org.apache.synapse.message.store.impl.jdbc.StoreException;
import org.apache.synapse.message.store.impl.jdbc.util.Statement;

public class ResequenceMessageStore
extends JDBCMessageStore {
    private static final Log log = LogFactory.getLog(ResequenceMessageStore.class);
    private static final int MILLISECONDS = 1000;
    private long nextSequenceId = 0L;
    private SynapsePath xPath;
    private long gapTimeoutInterval;
    private long nextElapsedTime;
    private boolean hasStarted = false;
    private ConcurrentHashMap<String, Long> sequenceIdMapper = new ConcurrentHashMap();

    private List<Map> startIdSelectionResult(ResultSet resultSet) throws SQLException {
        ArrayList<Map> elements = new ArrayList<Map>();
        while (resultSet.next()) {
            HashMap<String, Long> rowData = new HashMap<String, Long>();
            long sequenceId = resultSet.getLong("seq_id");
            rowData.put("seq_id", sequenceId);
            elements.add(rowData);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("DB returned " + sequenceId + " as the result"));
        }
        return elements;
    }

    private long readStartId() {
        Long sequenceId = 0L;
        boolean minimumRowCount = false;
        String storeName = this.getName();
        String lastProcessIdSelectStatement = "SELECT seq_id FROM tbl_lastprocessid WHERE statement=\"" + storeName + "\"";
        Statement statement = new Statement(lastProcessIdSelectStatement){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                return ResequenceMessageStore.this.startIdSelectionResult(resultSet);
            }
        };
        List<Map> processedRows = this.getProcessedRows(statement);
        if (processedRows.size() > 0) {
            boolean firstIndex = false;
            Map processedRowMap = processedRows.get(0);
            sequenceId = (Long)processedRowMap.get("seq_id");
            log.info((Object)("Starting sequence id recorded as:" + sequenceId));
        }
        return sequenceId;
    }

    private void initResequenceParams(Map<String, Object> parameters) {
        this.xPath = (SynapsePath)((Object)parameters.get("store.resequence.id.path"));
        this.gapTimeoutInterval = Integer.parseInt((String)parameters.get("store.resequence.timeout"));
        if (this.gapTimeoutInterval >= 0L) {
            this.gapTimeoutInterval *= 1000L;
            this.nextElapsedTime = System.currentTimeMillis() + this.gapTimeoutInterval;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resequencer initialized with xpath:" + this.xPath.expression + ",the waiting count configured:" + this.gapTimeoutInterval));
            }
        } else {
            this.nextElapsedTime = -1L;
        }
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.initResequenceParams(parameters);
        super.setParameters(parameters);
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        super.init(synapseEnvironment);
        this.nextSequenceId = this.readStartId() + 1L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Next sequence which will be processed:" + this.nextSequenceId));
        }
    }

    private Long getMessageSequenceId(MessageContext message) throws StoreException {
        String sequenceIdValue = this.xPath.stringValueOf(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sequence id extracted from the incoming message " + message.getMessageID() + " is:" + sequenceIdValue));
        }
        return Long.parseLong(sequenceIdValue);
    }

    private MessageContext getNextMessage() {
        MessageContext msg = null;
        boolean firstRowIndex = false;
        try {
            String tableName = this.getJdbcConfiguration().getTableName();
            String selectMessageStatement = "SELECT message FROM " + tableName + " WHERE " + "seq_id" + "= ?";
            Statement statement = new Statement(selectMessageStatement){

                @Override
                public List<Map> getResult(ResultSet resultSet) throws SQLException {
                    return ResequenceMessageStore.this.messageContentResultSet(resultSet, this.getStatement());
                }
            };
            statement.addParameter(this.nextSequenceId);
            List<Map> processedRows = this.getProcessedRows(statement);
            if (!processedRows.isEmpty()) {
                msg = this.getMessageContext(processedRows, 0);
                ++this.nextSequenceId;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Message with id " + msg.getMessageID() + " returned for sequence " + this.nextSequenceId));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Sequences not returned from DB, next sequence will be:" + this.nextSequenceId));
            }
        }
        catch (SynapseException ex) {
            throw new SynapseException("Error while peek the message", ex);
        }
        return msg;
    }

    @Override
    protected List<Statement> removeMessageStatement(String msgId) {
        Long messageSequenceId = this.sequenceIdMapper.remove(msgId);
        String messageStoreName = this.getName();
        if (messageSequenceId == null) {
            log.error((Object)("The message with id " + msgId + " is not tracked within the memory."));
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        String deleteMessageStatement = "DELETE FROM " + this.getJdbcConfiguration().getTableName() + " WHERE msg_id=?";
        String insertLastProcessIdStatement = "INSERT INTO tbl_lastprocessid (statement,seq_id) VALUES (?,?) ON DUPLICATE KEY UPDATE seq_id = ?";
        Statement sequenceIdUpdateStatement = new Statement("INSERT INTO tbl_lastprocessid (statement,seq_id) VALUES (?,?) ON DUPLICATE KEY UPDATE seq_id = ?"){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                throw new UnsupportedOperationException();
            }
        };
        Statement deleteMessage = new Statement(deleteMessageStatement){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                throw new UnsupportedOperationException();
            }
        };
        deleteMessage.addParameter(msgId);
        sequenceIdUpdateStatement.addParameter(messageStoreName);
        sequenceIdUpdateStatement.addParameter(messageSequenceId);
        sequenceIdUpdateStatement.addParameter(messageSequenceId);
        statements.add(deleteMessage);
        statements.add(sequenceIdUpdateStatement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing message with id:" + msgId + " and last process id:" + messageSequenceId));
        }
        return statements;
    }

    private MessageContext getMessageContext(List<Map> processedRows, int rowIndex) {
        Map map = processedRows.get(rowIndex);
        return (MessageContext)map.get("message");
    }

    private long getSequenceId(List<Map> processedRows, int rowIndex) {
        Map map = processedRows.get(rowIndex);
        return (Long)map.get("seq_id");
    }

    private List<Map> getMessageWithMinimumId(ResultSet resultSet, String statement) throws SQLException {
        ArrayList<Map> elements = new ArrayList<Map>();
        while (resultSet.next()) {
            try {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                byte[] msgObj = resultSet.getBytes("message");
                MessageContext responseMessageContext = this.deserializeMessage(msgObj);
                rowData.put("message", responseMessageContext);
                long sequenceId = resultSet.getLong("seq_id");
                rowData.put("seq_id", sequenceId);
                elements.add(rowData);
            }
            catch (SQLException e) {
                String message = "Error executing statement : " + statement + " against DataSource : " + this.getJdbcConfiguration().getDSName();
                throw new SynapseException(message, e);
            }
        }
        return elements;
    }

    private MessageContext getMessageWithMinimumSequence() {
        String tableName = this.getJdbcConfiguration().getTableName();
        String selectMinimumSequenceIdStatement = "SELECT message,seq_id FROM " + tableName + " WHERE " + "seq_id" + "=(SELECT min(" + "seq_id" + ") from " + tableName + ")";
        Statement stmt = new Statement(selectMinimumSequenceIdStatement){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                return ResequenceMessageStore.this.getMessageWithMinimumId(resultSet, this.getStatement());
            }
        };
        MessageContext msg = null;
        boolean firstRowIndex = false;
        try {
            List<Map> processedRows = this.getProcessedRows(stmt);
            if (!processedRows.isEmpty()) {
                msg = this.getMessageContext(processedRows, 0);
                long sequenceId = this.getSequenceId(processedRows, 0);
                this.nextSequenceId = sequenceId + 1L;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Message with id " + msg.getMessageID() + " returned as the minimum, the minimum sequence will be marked as " + this.nextSequenceId));
                }
            }
        }
        catch (SynapseException ex) {
            throw new SynapseException("Error while peek the message", ex);
        }
        return msg;
    }

    @Override
    protected Statement getStoreMessageStatement(MessageContext context, Long sequenceId) throws StoreException {
        sequenceId = this.getMessageSequenceId(context);
        Statement storeMessageStatement = super.getStoreMessageStatement(context, sequenceId);
        return storeMessageStatement;
    }

    private boolean shouldWait() {
        long currentTime = System.currentTimeMillis();
        return this.nextElapsedTime < 0L || currentTime <= this.nextElapsedTime;
    }

    @Override
    public MessageContext peek() throws SynapseException {
        MessageContext msg;
        if (!this.hasStarted) {
            this.nextSequenceId = this.readStartId() + 1L;
            this.hasStarted = true;
        }
        if (null == (msg = this.getNextMessage()) && !this.shouldWait()) {
            msg = this.getMessageWithMinimumSequence();
        }
        if (null != msg) {
            long currentSequenceId = this.nextSequenceId - 1L;
            String messageId = msg.getMessageID();
            this.sequenceIdMapper.put(messageId, currentSequenceId);
            if (this.nextElapsedTime > 0L) {
                this.nextElapsedTime = System.currentTimeMillis() + this.gapTimeoutInterval;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message with sequence " + currentSequenceId + " and message id " + messageId + " will be returned to the processor."));
                log.debug((Object)("Next elapsed time would be marked as:" + this.nextElapsedTime));
            }
        }
        return msg;
    }
}

