/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.rabbitmq;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.store.AbstractMessageStore;
import org.apache.synapse.message.store.impl.rabbitmq.RabbitMQConsumer;
import org.apache.synapse.message.store.impl.rabbitmq.RabbitMQProducer;

public class RabbitMQStore
extends AbstractMessageStore {
    private static final Log log = LogFactory.getLog((String)RabbitMQStore.class.getName());
    public static final String USERNAME = "store.rabbitmq.username";
    public static final String PASSWORD = "store.rabbitmq.password";
    public static final String HOST_NAME = "store.rabbitmq.host.name";
    public static final String HOST_PORT = "store.rabbitmq.host.port";
    public static final String VIRTUAL_HOST = "store.rabbitmq.virtual.host";
    public static final String QUEUE_NAME = "store.rabbitmq.queue.name";
    public static final String ROUTING_KEY = "store.rabbitmq.route.key";
    public static final String EXCHANGE_NAME = "store.rabbitmq.exchange.name";
    public static final String RETRY_INTERVAL = "rabbitmq.connection.retry.interval";
    public static final String RETRY_COUNT = "rabbitmq.connection.retry.count";
    public static final String PUBLISHER_CONFIRMS = "store.producer.guaranteed.delivery.enable";
    public static final int DEFAULT_RETRY_INTERVAL = 30000;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final String SSL_ENABLED = "rabbitmq.connection.ssl.enabled";
    public static final String SSL_KEYSTORE_LOCATION = "rabbitmq.connection.ssl.keystore.location";
    public static final String SSL_KEYSTORE_TYPE = "rabbitmq.connection.ssl.keystore.type";
    public static final String SSL_KEYSTORE_PASSWORD = "rabbitmq.connection.ssl.keystore.password";
    public static final String SSL_TRUSTSTORE_LOCATION = "rabbitmq.connection.ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_TYPE = "rabbitmq.connection.ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_PASSWORD = "rabbitmq.connection.ssl.truststore.password";
    public static final String SSL_VERSION = "rabbitmq.connection.ssl.version";
    public static final String AMQ_PREFIX = "amq.";
    private String queueName;
    private String routingKey;
    private String exchangeName;
    private ConnectionFactory connectionFactory;
    private Connection producerConnection;
    private Address[] addresses;
    private int retryInterval;
    private int retryCount;
    private boolean publisherConfirmsEnabled;

    @Override
    public void init(SynapseEnvironment se) {
        if (se == null) {
            log.error((Object)("Cannot initialize store [" + this.getName() + "]..."));
        }
        super.init(se);
        this.initConnectionFactory();
        this.publisherConfirmsEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.parameters.get(PUBLISHER_CONFIRMS))), (boolean)false);
        this.producerConnection = this.createConnection();
        if (this.producerConnection != null) {
            try (Channel channel = this.producerConnection.createChannel();){
                this.queueName = (String)this.parameters.get(QUEUE_NAME);
                this.routingKey = (String)this.parameters.get(ROUTING_KEY);
                this.exchangeName = (String)this.parameters.get(EXCHANGE_NAME);
                if (StringUtils.isEmpty((String)this.queueName)) {
                    this.queueName = this.getName();
                }
                if (StringUtils.isEmpty((String)this.routingKey)) {
                    this.routingKey = this.queueName;
                }
                this.declareQueue(channel, this.queueName);
                this.declareExchange(channel, this.exchangeName, this.queueName, this.routingKey);
                log.info((Object)(this.nameString() + ". Initialized... "));
            }
            catch (IOException | TimeoutException e) {
                log.error((Object)(this.nameString() + ". Initialization failed..."), (Throwable)e);
            }
        } else {
            log.error((Object)(this.nameString() + ". Initialization failed..."));
        }
    }

    private void initConnectionFactory() {
        String[] portArray;
        String hostnames = StringUtils.defaultIfEmpty((String)((String)this.parameters.get(HOST_NAME)), (String)"localhost");
        String ports = StringUtils.defaultIfEmpty((String)((String)this.parameters.get(HOST_PORT)), (String)String.valueOf(5672));
        String username = StringUtils.defaultIfEmpty((String)((String)this.parameters.get(USERNAME)), (String)"guest");
        String password = StringUtils.defaultIfEmpty((String)((String)this.parameters.get(PASSWORD)), (String)"guest");
        String virtualHost = StringUtils.defaultIfEmpty((String)((String)this.parameters.get(VIRTUAL_HOST)), (String)"/");
        boolean sslEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.parameters.get(SSL_ENABLED))), (boolean)false);
        this.retryInterval = NumberUtils.toInt((String)((String)this.parameters.get(RETRY_INTERVAL)), (int)30000);
        this.retryCount = NumberUtils.toInt((String)((String)this.parameters.get(RETRY_COUNT)), (int)3);
        String[] hostnameArray = hostnames.split(",");
        if (hostnameArray.length == (portArray = ports.split(",")).length) {
            this.addresses = new Address[hostnameArray.length];
            for (int i = 0; i < hostnameArray.length; ++i) {
                try {
                    this.addresses[i] = new Address(hostnameArray[i].trim(), Integer.parseInt(portArray[i].trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SynapseException("Number format error in port number", e);
                }
            }
        } else {
            throw new SynapseException("The number of hostnames must be equal to the number of ports");
        }
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setUsername(username);
        this.connectionFactory.setPassword(password);
        this.connectionFactory.setVirtualHost(virtualHost);
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.setTopologyRecoveryEnabled(true);
        this.setSSL(sslEnabled);
    }

    private void setSSL(boolean sslEnabled) {
        try {
            if (sslEnabled) {
                String keyStoreLocation = (String)this.parameters.get(SSL_KEYSTORE_LOCATION);
                String keyStoreType = (String)this.parameters.get(SSL_KEYSTORE_TYPE);
                String keyStorePassword = (String)this.parameters.get(SSL_KEYSTORE_PASSWORD);
                String trustStoreLocation = (String)this.parameters.get(SSL_TRUSTSTORE_LOCATION);
                String trustStoreType = (String)this.parameters.get(SSL_TRUSTSTORE_TYPE);
                String trustStorePassword = (String)this.parameters.get(SSL_TRUSTSTORE_PASSWORD);
                String sslVersion = (String)this.parameters.get(SSL_VERSION);
                if (StringUtils.isEmpty((String)keyStoreLocation) || StringUtils.isEmpty((String)keyStoreType) || StringUtils.isEmpty((String)keyStorePassword) || StringUtils.isEmpty((String)trustStoreLocation) || StringUtils.isEmpty((String)trustStoreType) || StringUtils.isEmpty((String)trustStorePassword)) {
                    log.info((Object)"Trustore and keystore information is not provided");
                    if (StringUtils.isNotEmpty((String)sslVersion)) {
                        this.connectionFactory.useSslProtocol(sslVersion);
                    } else {
                        log.info((Object)"Proceeding with default SSL configuration");
                        this.connectionFactory.useSslProtocol();
                    }
                } else {
                    char[] keyPassphrase = keyStorePassword.toCharArray();
                    KeyStore ks = KeyStore.getInstance(keyStoreType);
                    ks.load(new FileInputStream(keyStoreLocation), keyPassphrase);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, keyPassphrase);
                    char[] trustPassphrase = trustStorePassword.toCharArray();
                    KeyStore tks = KeyStore.getInstance(trustStoreType);
                    tks.load(new FileInputStream(trustStoreLocation), trustPassphrase);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    tmf.init(tks);
                    SSLContext c = SSLContext.getInstance(sslVersion);
                    c.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                    this.connectionFactory.useSslProtocol(c);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Format error in SSL enabled value. Proceeding without enabling SSL", (Throwable)e);
        }
    }

    public Connection createConnection() {
        Connection connection;
        block3: {
            connection = null;
            try {
                connection = this.connectionFactory.newConnection(this.addresses);
                log.info((Object)(this.nameString() + " Successfully connected to RabbitMQ Broker"));
            }
            catch (TimeoutException e) {
                log.error((Object)"Error occurred while creating a connection.", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)(this.nameString() + " Error creating connection to RabbitMQ Broker. Reattempting to connect."), (Throwable)e);
                connection = this.retry(connection);
                if (connection != null) break block3;
                throw new SynapseException(this.nameString() + " Could not connect to RabbitMQ Broker. Error while creating connection", e);
            }
        }
        return connection;
    }

    public Channel createChannel(Connection connection) {
        Channel channel = null;
        try {
            channel = connection.createChannel();
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while creating a channel.", (Throwable)e);
        }
        return channel;
    }

    private Connection retry(Connection connection) {
        int retryC = 0;
        while (connection == null && (this.retryCount == -1 || retryC < this.retryCount)) {
            ++retryC;
            log.info((Object)(this.nameString() + " Attempting to create connection to RabbitMQ Broker in " + this.retryInterval + " ms"));
            try {
                Thread.sleep(this.retryInterval);
                connection = this.connectionFactory.newConnection(this.addresses);
                log.info((Object)(this.nameString() + " Successfully connected to RabbitMQ Broker"));
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e1) {
                log.error((Object)"Error occurred while creating a connection", (Throwable)e1);
            }
            catch (IOException e1) {
                log.error((Object)(this.nameString() + " Error while trying to reconnect to RabbitMQ Broker"), (Throwable)e1);
            }
        }
        return connection;
    }

    private void declareQueue(Channel channel, String queueName) throws IOException {
        channel.queueDeclare(queueName, true, false, false, new HashMap());
    }

    private void declareExchange(Channel channel, String exchangeName, String queueName, String routingKey) throws IOException {
        if (StringUtils.isNotEmpty((String)exchangeName)) {
            if (!exchangeName.startsWith(AMQ_PREFIX)) {
                channel.exchangeDeclare(exchangeName, BuiltinExchangeType.DIRECT, true, false, new HashMap());
            }
            if (StringUtils.isNotEmpty((String)queueName) && StringUtils.isNotEmpty((String)routingKey)) {
                channel.queueBind(queueName, exchangeName, routingKey);
            } else if (StringUtils.isNotEmpty((String)queueName) && StringUtils.isEmpty((String)routingKey)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No routing key specified. The queue name is using as the routing key.");
                }
                channel.queueBind(queueName, exchangeName, routingKey);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.producerConnection != null) {
            this.producerConnection.abort();
        }
        this.producerConnection = null;
        super.destroy();
    }

    @Override
    public MessageProducer getProducer() {
        RabbitMQProducer producer = new RabbitMQProducer(this);
        producer.setId(this.nextProducerId());
        producer.setExchangeName(this.exchangeName);
        producer.setRoutingKey(this.routingKey);
        if (this.producerConnection == null) {
            this.producerConnection = this.createConnection();
        } else if (!this.producerConnection.isOpen()) {
            this.producerConnection.abort();
            this.producerConnection = this.createConnection();
        }
        producer.setConnection(this.producerConnection);
        producer.setPublisherConfirmsEnabled(this.publisherConfirmsEnabled);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.nameString() + " created message producer " + producer.getId()));
        }
        return producer;
    }

    @Override
    public MessageConsumer getConsumer() {
        RabbitMQConsumer consumer = new RabbitMQConsumer(this);
        consumer.setId(this.nextConsumerId());
        consumer.setQueueName(this.queueName);
        Connection connection = this.createConnection();
        consumer.setConnection(connection);
        consumer.setChannel(this.createChannel(connection));
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.nameString() + " created message consumer " + consumer.getId()));
        }
        return consumer;
    }

    public org.apache.axis2.context.MessageContext newAxis2Mc() {
        return ((Axis2SynapseEnvironment)this.synapseEnvironment).getAxis2ConfigurationContext().createMessageContext();
    }

    public MessageContext newSynapseMc(org.apache.axis2.context.MessageContext msgCtx) {
        SynapseConfiguration configuration = this.synapseEnvironment.getSynapseConfiguration();
        return new Axis2MessageContext(msgCtx, configuration, this.synapseEnvironment);
    }

    @Override
    public MessageContext remove() throws NoSuchElementException {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public MessageContext remove(String messageID) {
        return null;
    }

    @Override
    public MessageContext get(int index) {
        return null;
    }

    @Override
    public List<MessageContext> getAll() {
        return null;
    }

    @Override
    public MessageContext get(String messageId) {
        return null;
    }

    private String nameString() {
        return "Store [" + this.getName() + "]";
    }
}

