/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MessageProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.store.impl.commons.MessageConverter;
import org.apache.synapse.message.store.impl.commons.StorableMessage;
import org.apache.synapse.message.store.impl.rabbitmq.RabbitMQStore;

public class RabbitMQProducer
implements MessageProducer {
    private static final Log log = LogFactory.getLog((String)RabbitMQProducer.class.getName());
    private static final int DEFAULT_PRIORITY = 0;
    private Connection connection;
    private RabbitMQStore store;
    private String routingKey;
    private String exchangeName;
    private boolean isInitialized = false;
    private String idString;
    private boolean publisherConfirmsEnabled;

    public RabbitMQProducer(RabbitMQStore store) {
        if (store == null) {
            log.error((Object)("Cannot initialize producer: " + this.getId()));
            return;
        }
        this.store = store;
        this.isInitialized = true;
    }

    @Override
    public boolean storeMessage(MessageContext synCtx) {
        if (synCtx == null) {
            return false;
        }
        if (this.connection == null) {
            log.error((Object)(this.getId() + " cannot proceed. RabbitMQ Connection is null. Ignored MessageId: " + synCtx.getMessageID()));
            return false;
        }
        boolean result = false;
        try (Channel channel = this.connection.createChannel();){
            if (this.publisherConfirmsEnabled) {
                channel.confirmSelect();
            }
            StorableMessage storableMessage = MessageConverter.toStorableMessage(synCtx);
            byte[] message = this.serializeMessage(storableMessage);
            AMQP.BasicProperties basicProperties = this.getBasicProperties(synCtx, storableMessage);
            this.publishMessage(channel, this.exchangeName, this.routingKey, basicProperties, message);
            result = this.publisherConfirmsEnabled ? channel.waitForConfirms() : true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getId() + ". Stored MessageId: " + synCtx.getMessageID()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException | TimeoutException e) {
            String errorMsg = this.getId() + ". Ignored MessageId: " + synCtx.getMessageID() + ". Could not store message to store [" + this.store.getName() + "]. Error:" + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
        this.store.enqueued();
        return result;
    }

    private byte[] serializeMessage(StorableMessage storableMessage) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputStream);
        objectOutput.writeObject(storableMessage);
        return outputStream.toByteArray();
    }

    private AMQP.BasicProperties getBasicProperties(MessageContext synCtx, StorableMessage storableMessage) {
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
        builder.messageId(synCtx.getMessageID());
        builder.deliveryMode(MessageProperties.MINIMAL_PERSISTENT_BASIC.getDeliveryMode());
        builder.priority(Integer.valueOf(storableMessage.getPriority(0)));
        return builder.build();
    }

    private void publishMessage(Channel channel, String exchangeName, String routingKey, AMQP.BasicProperties basicProperties, byte[] messageBody) throws IOException {
        if (StringUtils.isNotEmpty((String)exchangeName)) {
            channel.basicPublish(exchangeName, routingKey, basicProperties, messageBody);
        } else {
            channel.basicPublish("", routingKey, basicProperties, messageBody);
        }
    }

    @Override
    public boolean cleanup() {
        return true;
    }

    @Override
    public String getId() {
        return this.idString;
    }

    @Override
    public void setId(int id) {
        this.idString = "[" + this.store.getName() + "-P-" + id + "]";
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setPublisherConfirmsEnabled(boolean publisherConfirmsEnabled) {
        this.publisherConfirmsEnabled = publisherConfirmsEnabled;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

