/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.store.impl.commons.MessageConverter;
import org.apache.synapse.message.store.impl.commons.StorableMessage;
import org.apache.synapse.message.store.impl.rabbitmq.RabbitMQStore;

public class RabbitMQConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog((String)RabbitMQConsumer.class.getName());
    private Connection connection;
    private Channel channel;
    private RabbitMQStore store;
    private String queueName;
    private String idString;
    private CachedMessage cachedMessage;

    public RabbitMQConsumer(RabbitMQStore store) {
        if (store == null) {
            log.error((Object)("Cannot initialize consumer: " + this.getId()));
            return;
        }
        this.store = store;
        this.cachedMessage = new CachedMessage();
    }

    @Override
    public MessageContext receive() {
        if (this.isAlive()) {
            GetResponse delivery = null;
            try {
                delivery = this.channel.basicGet(this.queueName, false);
                if (delivery != null) {
                    StorableMessage storableMessage = this.deserializeMessage(delivery);
                    org.apache.axis2.context.MessageContext axis2Mc = this.store.newAxis2Mc();
                    MessageContext synapseMc = this.store.newSynapseMc(axis2Mc);
                    synapseMc = MessageConverter.toMessageContext(storableMessage, axis2Mc, synapseMc);
                    this.updateCache(delivery, delivery.getProps().getMessageId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.getId() + " Received MessageId: " + delivery.getProps().getMessageId()));
                    }
                    return synapseMc;
                }
            }
            catch (ShutdownSignalException | IOException e) {
                log.error((Object)(this.getId() + " connection error when receiving messages."), e);
                this.cleanup();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)(this.getId() + "unable to read the stored message."), (Throwable)e);
                try {
                    this.channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                }
                catch (IOException ex) {
                    log.error((Object)(this.getId() + "unable to acknowledge the stored message."), (Throwable)e);
                }
            }
        } else {
            log.warn((Object)"The connection and channel to the RabbitMQ broker are unhealthy.");
            this.cleanup();
            this.setConnection(this.store.createConnection());
            this.setChannel(this.store.createChannel(this.connection));
        }
        return null;
    }

    private StorableMessage deserializeMessage(GetResponse delivery) throws IOException, ClassNotFoundException {
        StorableMessage storableMessage;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(delivery.getBody());
             ObjectInputStream objectInput = new ObjectInputStream(inputStream);){
            storableMessage = (StorableMessage)objectInput.readObject();
        }
        return storableMessage;
    }

    @Override
    public boolean ack() {
        boolean result = this.cachedMessage.ack();
        if (result) {
            this.store.dequeued();
        }
        return result;
    }

    @Override
    public boolean cleanup() {
        if (this.connection != null) {
            this.connection.abort();
        }
        this.channel = null;
        this.connection = null;
        return true;
    }

    @Override
    public boolean isAlive() {
        return this.connection != null && this.connection.isOpen() && this.channel != null && this.channel.isOpen();
    }

    @Override
    public void setAlive(boolean isAlive) {
    }

    @Override
    public String getId() {
        return this.idString;
    }

    @Override
    public void setId(int id) {
        this.idString = "[" + this.store.getName() + "-C-" + id + "]";
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    private void updateCache(GetResponse delivery, String messageId) {
        this.cachedMessage.setMessage(delivery);
        this.cachedMessage.setId(messageId);
    }

    private final class CachedMessage {
        private GetResponse message = null;
        private String id = "";

        private CachedMessage() {
        }

        public void setMessage(GetResponse message) {
            this.message = message;
        }

        public boolean ack() {
            if (this.message != null && RabbitMQConsumer.this.channel != null && RabbitMQConsumer.this.channel.isOpen()) {
                try {
                    RabbitMQConsumer.this.channel.basicAck(this.message.getEnvelope().getDeliveryTag(), false);
                    return true;
                }
                catch (IOException e) {
                    log.error((Object)(this.getId() + " cannot ack last read message. Error: " + e.getLocalizedMessage()), (Throwable)e);
                    return false;
                }
            }
            return false;
        }

        public GetResponse getMessage() {
            return this.message;
        }

        public CachedMessage setId(String id) {
            this.id = id;
            return this;
        }

        public String getId() {
            return this.id;
        }
    }
}

