/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.store.AbstractMessageStore;
import org.apache.synapse.message.store.impl.memory.InMemoryConsumer;
import org.apache.synapse.message.store.impl.memory.InMemoryProducer;

public class InMemoryStore
extends AbstractMessageStore {
    private static final Log logger = LogFactory.getLog((String)InMemoryStore.class.getName());
    private Queue<MessageContext> queue = new ConcurrentLinkedQueue<MessageContext>();
    private final Object queueLock = new Object();

    @Override
    public MessageProducer getProducer() {
        InMemoryProducer producer = new InMemoryProducer(this);
        producer.setId(this.nextProducerId());
        producer.setDestination(this.queue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + " created a new In Memory Message Producer."));
        }
        return producer;
    }

    @Override
    public MessageConsumer getConsumer() {
        InMemoryConsumer consumer = new InMemoryConsumer(this);
        consumer.setId(this.nextConsumerId());
        consumer.setDestination(this.queue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + " created a new In Memory Message Consumer."));
        }
        return consumer;
    }

    @Override
    public int getType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.queueLock;
        synchronized (object) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext remove() throws NoSuchElementException {
        MessageContext message;
        Object object = this.queueLock;
        synchronized (object) {
            message = this.queue.remove();
        }
        if (message != null) {
            this.dequeued();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.nameString() + " removed MessageID:" + message.getMessageID() + " => true"));
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.queueLock;
        synchronized (object) {
            while (!this.queue.isEmpty()) {
                this.remove();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + " cleared InMemoryStore..."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext remove(String messageID) {
        MessageContext message = null;
        Object object = this.queueLock;
        synchronized (object) {
            for (MessageContext m : this.queue) {
                if (!m.getMessageID().equals(messageID)) continue;
                message = m;
                break;
            }
            if (message != null) {
                boolean result = this.queue.remove(message);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.nameString() + " removed MessageID:" + message.getMessageID() + " => " + result));
                }
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext get(int index) {
        if (index < 0 || index >= this.queue.size()) {
            return null;
        }
        MessageContext message = null;
        Object object = this.queueLock;
        synchronized (object) {
            int i = 0;
            for (MessageContext m : this.queue) {
                if (i == index) {
                    message = m;
                    break;
                }
                ++i;
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageContext> getAll() {
        ArrayList<MessageContext> list = new ArrayList<MessageContext>();
        Object object = this.queueLock;
        synchronized (object) {
            list.addAll(this.queue);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext get(String messageId) {
        MessageContext message = null;
        Object object = this.queueLock;
        synchronized (object) {
            for (MessageContext m : this.queue) {
                if (!m.getMessageID().equals(messageId)) continue;
                message = m;
                break;
            }
        }
        return message;
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (se == null) {
            logger.error((Object)"Cannot initialize store.");
            return;
        }
        super.init(se);
        logger.info((Object)("Initialized " + this.nameString() + "..."));
    }

    @Override
    public void destroy() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Destroying " + this.nameString() + "..."));
        }
        super.destroy();
    }

    public Object getQLock() {
        return this.queueLock;
    }

    private String nameString() {
        return "Store [" + this.getName() + "]";
    }
}

