/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.memory;

import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.store.impl.memory.InMemoryStore;

public class InMemoryProducer
implements MessageProducer {
    private static final Log logger = LogFactory.getLog((String)InMemoryProducer.class.getName());
    private Queue<MessageContext> queue;
    private final InMemoryStore store;
    private String idString;
    private final Object queueLock;

    public InMemoryProducer(InMemoryStore store) {
        this.store = store;
        this.queueLock = store.getQLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeMessage(MessageContext synCtx) {
        boolean result = false;
        if (synCtx != null) {
            synCtx.getEnvelope().buildWithAttachments();
            Object object = this.queueLock;
            synchronized (object) {
                result = this.queue.offer(synCtx);
            }
            if (!result) {
                logger.warn((Object)(this.getId() + " ignored MessageID : " + synCtx.getMessageID()));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getId() + " stored MessageID: " + synCtx.getMessageID()));
        }
        if (result) {
            this.store.enqueued();
        }
        return result;
    }

    @Override
    public boolean cleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getId() + " cleanup"));
        }
        return true;
    }

    @Override
    public void setId(int id) {
        this.idString = "[" + this.store.getName() + "-P-" + id + "]";
    }

    @Override
    public String getId() {
        return this.idString;
    }

    public InMemoryProducer setDestination(Queue<MessageContext> queue) {
        this.queue = queue;
        return this;
    }
}

