/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.memory;

import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.store.impl.memory.InMemoryStore;

public class InMemoryConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog((String)InMemoryConsumer.class.getName());
    private Queue<MessageContext> queue;
    private final InMemoryStore store;
    private String idString;
    private MessageContext lastMessage;
    private final Object queueLock;

    public InMemoryConsumer(InMemoryStore store) {
        this.store = store;
        this.queueLock = store.getQLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext receive() {
        MessageContext message;
        Object object = this.queueLock;
        synchronized (object) {
            message = this.queue.peek();
            if (logger.isDebugEnabled() && message != null) {
                logger.debug((Object)(this.getId() + " received MessageID : " + message.getMessageID()));
            }
            this.lastMessage = message;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ack() {
        if (logger.isDebugEnabled() && this.lastMessage != null) {
            logger.debug((Object)(this.getId() + " ack"));
        }
        Object object = this.queueLock;
        synchronized (object) {
            MessageContext o = this.queue.poll();
            if (o != null) {
                this.store.dequeued();
            }
            this.lastMessage = null;
        }
        return true;
    }

    @Override
    public boolean cleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getId() + " cleanup"));
        }
        return true;
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public void setAlive(boolean isAlive) {
    }

    @Override
    public void setId(int id) {
        this.idString = "[" + this.store.getName() + "-C-" + id + "]";
    }

    @Override
    public String getId() {
        return this.idString;
    }

    public InMemoryConsumer setDestination(Queue<MessageContext> queue) {
        this.queue = queue;
        return this;
    }
}

