/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.jms;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.StoreForwardException;
import org.apache.synapse.message.store.AbstractMessageStore;
import org.apache.synapse.message.store.impl.jms.JmsConsumer;
import org.apache.synapse.message.store.impl.jms.JmsProducer;
import org.apache.synapse.util.resolver.SecureVaultResolver;

public class JmsStore
extends AbstractMessageStore {
    protected static final Log log = LogFactory.getLog(JmsStore.class);
    public static final String USERNAME = "store.jms.username";
    public static final String PASSWORD = "store.jms.password";
    public static final String CACHE = "store.jms.cache.connection";
    public static final String DESTINATION = "store.jms.destination";
    public static final String JMS_VERSION = "store.jms.JMSSpecVersion";
    public static final String CONSUMER_TIMEOUT = "store.jms.ConsumerReceiveTimeOut";
    public static final String CONN_FACTORY = "store.jms.connection.factory";
    public static final String NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
    public static final String CONNECTION_STRING = "connectionfactory.QueueConnectionFactory";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String QUEUE_PREFIX = "queue.";
    public static final String GUARANTEED_DELIVERY_ENABLE = "store.producer.guaranteed.delivery.enable";
    private final Properties connectionProperties = new Properties();
    private String userName;
    private String password;
    private String destination;
    private String destinationType = "queue";
    private static final Log logger = LogFactory.getLog((String)JmsStore.class.getName());
    private int cacheLevel = 0;
    public static final String JMS_SPEC_11 = "1.1";
    private boolean isVersion11 = true;
    private Context context;
    private ConnectionFactory connectionFactory;
    private Destination queue;
    private final Object queueLock = new Object();
    private Connection producerConnection;
    private final Object producerLock = new Object();
    private long retryTime = -1L;
    private boolean isGuaranteedDeliveryEnable = false;
    private MessageProducer cachedProducer;
    private MessageProducer producer = null;
    private SynapseEnvironment synapseEnvironment;
    private static final String SECURE_VAULT_REGEX = "\\{(wso2:vault-lookup\\('(.*?)'\\))\\}";
    private Pattern queueLookupPattern = Pattern.compile("\\{(wso2:vault-lookup\\('(.*?)'\\))\\}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageProducer getProducer() {
        block17: {
            if (this.cacheLevel == 1 && this.cachedProducer != null) {
                return this.cachedProducer;
            }
            if (this.producer != null) {
                return this.producer;
            }
            this.producer = new JmsProducer(this);
            this.producer.setId(this.nextProducerId());
            Session session = null;
            try {
                Object object = this.producerLock;
                synchronized (object) {
                    if (this.producerConnection == null) {
                        this.newWriteConnection();
                    }
                }
                if (((JmsProducer)this.producer).getSession() != null) break block17;
                try {
                    session = this.newSession(this.producerConnection(), 1, true);
                }
                catch (JMSException e) {
                    this.newWriteConnection();
                    session = this.newSession(this.producerConnection(), 1, true);
                }
                javax.jms.MessageProducer messageProducer = this.newProducer(session);
                ((JmsProducer)this.producer).setConnection(this.producerConnection()).setSession(session).setProducer(messageProducer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.nameString() + " created message producer " + this.producer.getId()));
                }
                if (this.cacheLevel == 1) {
                    this.cachedProducer = this.producer;
                }
            }
            catch (Throwable t) {
                String errorMsg = "Could not create a Message Producer for " + this.nameString();
                logger.error((Object)errorMsg, t);
                Object object = this.producerLock;
                synchronized (object) {
                    try {
                        this.cleanup(this.producerConnection, session);
                    }
                    catch (JMSException e) {
                        throw new SynapseException("Error while cleaning up connection for message store " + this.nameString(), e);
                    }
                    this.producerConnection = null;
                }
            }
        }
        return this.producer;
    }

    @Override
    public MessageConsumer getConsumer() throws SynapseException {
        JmsConsumer consumer = new JmsConsumer(this);
        consumer.setId(this.nextConsumerId());
        try {
            Connection connection = this.newConnection();
            Session session = this.newSession(connection, 2, false);
            javax.jms.MessageConsumer jmsConsumer = this.newConsumer(session);
            consumer.setConnection(connection).setSession(session).setConsumer(jmsConsumer);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.nameString() + " created message consumer " + consumer.getId()));
            }
        }
        catch (JMSException | StoreForwardException e) {
            throw new SynapseException("Could not create a Message Consumer for " + this.nameString(), e);
        }
        return consumer;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public MessageContext remove() throws NoSuchElementException {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public MessageContext remove(String messageID) {
        return null;
    }

    @Override
    public MessageContext get(int index) {
        return null;
    }

    @Override
    public List<MessageContext> getAll() {
        return null;
    }

    @Override
    public MessageContext get(String messageId) {
        return null;
    }

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
        if (se == null) {
            logger.error((Object)"Cannot initialize store.");
            return;
        }
        try {
            this.initme();
        }
        catch (JMSException | StoreForwardException e) {
            logger.info((Object)(this.nameString() + ". Initialization failed..."), e);
        }
        super.init(se);
        logger.info((Object)(this.nameString() + ". Initialized... "));
    }

    @Override
    public void destroy() throws SynapseException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Destroying " + this.nameString() + "..."));
        }
        try {
            this.closeWriteConnection();
        }
        catch (JMSException e) {
            throw new SynapseException("Error while closing JMS connection at " + this.nameString(), e);
        }
        super.destroy();
    }

    public Connection newConnection() throws JMSException, StoreForwardException {
        Connection connection;
        if (this.connectionFactory == null) {
            throw new StoreForwardException("Cannot create a connection to JMS provider as connectionFactory == null");
        }
        if (this.isVersion11) {
            connection = this.userName != null && this.password != null ? this.connectionFactory.createConnection(this.userName, this.password) : this.connectionFactory.createConnection();
        } else {
            QueueConnectionFactory connectionFactory = (QueueConnectionFactory)this.connectionFactory;
            connection = this.userName != null && this.password != null ? connectionFactory.createQueueConnection(this.userName, this.password) : connectionFactory.createQueueConnection();
        }
        connection.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + ". Created JMS Connection."));
        }
        return connection;
    }

    public Session newSession(Connection connection, int mode, boolean isProducerSession) throws JMSException, StoreForwardException {
        if (connection == null) {
            throw new StoreForwardException("Cannot Create JMS session on null connection ");
        }
        Object session = this.isVersion11 ? (this.isGuaranteedDeliveryEnable && isProducerSession ? connection.createSession(true, 0) : connection.createSession(false, mode)) : (this.isGuaranteedDeliveryEnable && isProducerSession ? ((QueueConnection)connection).createQueueSession(true, 0) : ((QueueConnection)connection).createQueueSession(false, mode));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + ". Created JMS Session."));
        }
        return session;
    }

    public javax.jms.MessageProducer newProducer(Session session) throws JMSException, StoreForwardException {
        if (session == null) {
            throw new StoreForwardException("Cannot create a JMS consumer on null session");
        }
        this.createDestIfAbsent(session);
        Object producer = this.isVersion11 ? session.createProducer(this.queue) : ((QueueSession)session).createSender((Queue)this.queue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + " created JMS Message Producer to destination [" + this.queue.toString() + "]."));
        }
        return producer;
    }

    public javax.jms.MessageConsumer newConsumer(Session session) throws JMSException, StoreForwardException {
        if (session == null) {
            throw new StoreForwardException("Cannot create a JMS consumer on null session");
        }
        this.createDestIfAbsent(session);
        Object consumer = this.isVersion11 ? session.createConsumer(this.queue) : ((QueueSession)session).createReceiver((Queue)this.queue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + " created JMS Message Consumer to destination [" + this.queue.toString() + "]."));
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newWriteConnection() throws StoreForwardException, JMSException {
        Object object = this.producerLock;
        synchronized (object) {
            if (this.producerConnection != null) {
                this.closeConnection(this.producerConnection);
            }
            this.producerConnection = this.newConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWriteConnection() throws JMSException {
        Object object = this.producerLock;
        synchronized (object) {
            if (this.producerConnection != null) {
                this.closeConnection(this.producerConnection);
            }
        }
    }

    public Connection producerConnection() {
        return this.producerConnection;
    }

    public void closeConnection(Connection connection) throws JMSException {
        connection.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + " closed connection to JMS broker."));
        }
    }

    public void reset(Connection connection, Session session) throws JMSException {
        this.cleanup(connection, session);
    }

    public void cleanup(Connection connection, Session session) throws JMSException {
        this.cachedProducer = null;
        if (session != null) {
            session.close();
        }
        if (connection != null) {
            connection.close();
        }
    }

    public org.apache.axis2.context.MessageContext newAxis2Mc() {
        return ((Axis2SynapseEnvironment)this.synapseEnvironment).getAxis2ConfigurationContext().createMessageContext();
    }

    public MessageContext newSynapseMc(org.apache.axis2.context.MessageContext msgCtx) {
        SynapseConfiguration configuration = this.synapseEnvironment.getSynapseConfiguration();
        return new Axis2MessageContext(msgCtx, configuration, this.synapseEnvironment);
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            throw new SynapseException("Cannot initialize JMS Store [" + this.getName() + "]. Required parameters are not available.");
        }
        super.setParameters(parameters);
    }

    public void setCachedProducer(MessageProducer cachedProducer) {
        this.cachedProducer = cachedProducer;
    }

    private boolean initme() throws StoreForwardException, JMSException {
        String destination;
        Set mapSet = this.parameters.entrySet();
        for (Map.Entry e : mapSet) {
            Object value = e.getValue();
            if (!(value instanceof String)) continue;
            if (CONNECTION_STRING.equals(e.getKey())) {
                value = this.resolveConnectionStringValues(value);
            }
            this.connectionProperties.put(e.getKey(), value);
        }
        this.userName = (String)this.parameters.get(USERNAME);
        this.password = SecureVaultResolver.resolve(this.synapseEnvironment, (String)this.parameters.get(PASSWORD));
        String conCaching = (String)this.parameters.get(CACHE);
        if ("true".equals(conCaching)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.nameString() + " enabling connection Caching"));
            }
            this.cacheLevel = 1;
        }
        if ((destination = (String)this.parameters.get(DESTINATION)) != null) {
            this.destination = destination;
        } else {
            String name = this.getName();
            String defaultDest = name != null && !name.isEmpty() ? name + "_Queue" : "JmsStore_" + System.currentTimeMillis() + "_Queue";
            logger.warn((Object)(this.nameString() + ". Destination not provided. Setting default destination to [" + defaultDest + "]."));
            this.destination = defaultDest;
        }
        this.destinationType = "queue";
        String version = (String)this.parameters.get(JMS_VERSION);
        if (version != null && !JMS_SPEC_11.equals(version)) {
            this.isVersion11 = false;
        }
        if (this.parameters != null && !this.parameters.isEmpty() && this.parameters.get(GUARANTEED_DELIVERY_ENABLE) != null) {
            this.isGuaranteedDeliveryEnable = Boolean.valueOf(this.parameters.get(GUARANTEED_DELIVERY_ENABLE).toString());
        }
        String consumerReceiveTimeOut = (String)this.parameters.get(CONSUMER_TIMEOUT);
        int consumerReceiveTimeOutI = 6000;
        if (consumerReceiveTimeOut != null) {
            try {
                consumerReceiveTimeOutI = Integer.parseInt(consumerReceiveTimeOut);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String connectionFac = null;
        try {
            this.context = new InitialContext(this.connectionProperties);
            connectionFac = (String)this.parameters.get(CONN_FACTORY);
            if (connectionFac == null) {
                connectionFac = "QueueConnectionFactory";
            }
            this.connectionFactory = this.lookup(this.context, ConnectionFactory.class, connectionFac);
            if (this.connectionFactory == null) {
                throw new StoreForwardException(this.nameString() + " could not initialize JMS Connection Factory. Connection factory not found : " + connectionFac);
            }
            this.createDestIfAbsent(null);
            if (this.queue == null) {
                logger.warn((Object)(this.nameString() + ". JMS Destination [" + destination + "] does not exist."));
            }
        }
        catch (NamingException e) {
            logger.error((Object)(this.nameString() + ". Could not initialize JMS Message Store. Error:" + e.getLocalizedMessage() + ". Initial Context Factory:[" + this.parameters.get(NAMING_FACTORY_INITIAL) + "]; Provider URL:[" + this.parameters.get(PROVIDER_URL) + "]; Connection Factory:[" + connectionFac + "]."), (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)(this.nameString() + ". Could not initialize JMS Message Store. Error:" + t.getMessage() + ". Initial Context Factory:[" + this.parameters.get(NAMING_FACTORY_INITIAL) + "]; Provider URL:[" + this.parameters.get(PROVIDER_URL) + "]; Connection Factory:[" + connectionFac + "]."), t);
        }
        this.newWriteConnection();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination getDestination(Session session) throws JMSException, StoreForwardException {
        Destination dest = this.queue;
        if (dest != null) {
            return dest;
        }
        String destinationLookupFailureReason = "";
        try {
            dest = this.lookup(this.context, Destination.class, this.destination);
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.nameString() + ". Could not lookup destination [" + this.destination + "]. Message: " + e.getLocalizedMessage()));
            }
            InitialContext newContext = this.newContext();
            try {
                dest = this.lookup(newContext, Destination.class, this.destination);
            }
            catch (Throwable t) {
                destinationLookupFailureReason = this.nameString() + ". Destination [" + this.destination + "] not defined in JNDI context. Message:" + t.getLocalizedMessage();
            }
        }
        if (dest == null) {
            if (session == null) {
                throw new StoreForwardException(this.nameString() + "cannot create Destination" + this.destination + ". JMS Session cannot be null");
            }
            try {
                dest = session.createQueue(this.destination);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.nameString() + " created destination [" + this.destination + "] from session object."));
                }
            }
            catch (JMSException e) {
                String error = this.nameString() + " could not create destination [" + this.destination + "]. from session or by JNDI context lookup. ";
                error.concat("create by session error: " + (Object)((Object)e));
                if (!destinationLookupFailureReason.isEmpty()) {
                    error.concat(" create by lookup error: " + destinationLookupFailureReason);
                }
                throw new StoreForwardException(error, e);
            }
        }
        Object object = this.queueLock;
        synchronized (object) {
            this.queue = dest;
        }
        return dest;
    }

    private InitialContext newContext() {
        InitialContext newContext;
        Properties properties = new Properties();
        try {
            Hashtable<?, ?> env = this.context.getEnvironment();
            Object o = env.get(NAMING_FACTORY_INITIAL);
            if (o != null) {
                properties.put(NAMING_FACTORY_INITIAL, o);
            }
            if ((o = env.get(CONNECTION_STRING)) != null) {
                properties.put(CONNECTION_STRING, o);
            }
            if ((o = env.get(PROVIDER_URL)) != null) {
                properties.put(PROVIDER_URL, o);
            }
            properties.put(QUEUE_PREFIX + this.destination, this.destination);
            newContext = new InitialContext(properties);
        }
        catch (NamingException e) {
            logger.info((Object)(this.nameString() + " could not create a new Context. Message:" + e.getLocalizedMessage()));
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.nameString() + " Created a new Context."));
        }
        return newContext;
    }

    private <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        if (context == null) {
            logger.error((Object)(this.nameString() + ". Cannot perform JNDI lookup. Invalid context."));
            return null;
        }
        if (name == null || "".equals(name)) {
            logger.error((Object)(this.nameString() + ". Cannot perform JNDI lookup. Invalid name."));
            return null;
        }
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException e) {
            logger.error((Object)(this.nameString() + ". Cannot perform JNDI lookup for the name [" + name + "]."), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destinationNonNull() {
        Object object = this.queueLock;
        synchronized (object) {
            return this.queue != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDestIfAbsent(Session session) throws JMSException, StoreForwardException {
        Object object = this.queueLock;
        synchronized (object) {
            return this.getDestination(session) != null;
        }
    }

    private String nameString() {
        return "Store [" + this.getName() + "]";
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    private String resolveConnectionStringValues(Object param) {
        String paramString = param.toString();
        Matcher lookupMatcher = this.queueLookupPattern.matcher(paramString);
        while (lookupMatcher.find()) {
            for (int i = 0; i < lookupMatcher.groupCount(); ++i) {
                paramString = paramString.replace(lookupMatcher.group(i), SecureVaultResolver.resolve(this.synapseEnvironment, lookupMatcher.group(i)));
            }
        }
        return paramString;
    }
}

