/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.store.impl.commons.MessageConverter;
import org.apache.synapse.message.store.impl.commons.StorableMessage;
import org.apache.synapse.message.store.impl.jms.JmsStore;

public class JmsProducer
implements MessageProducer {
    private static final String JMS_PROD_TIME_TO_LIVE = "JMS_PROD_TIME_TO_LIVE";
    private static final String JMS_PROD_DISABLE_MSG_TIMESTAMP = "JMS_PROD_DISABLE_MSG_TIMESTAMP";
    private static final String JMS_PROD_DELIVERY_MODE = "JMS_PROD_DELIVERY_MODE";
    private static final String JMS_PROD_DISABLE_MSG_ID = "JMS_PROD_DISABLE_MSG_ID";
    private static final String JMS_PROD_PRIORITY = "JMS_PROD_PRIORITY";
    private static final int DEFAULT_PRIORITY = 4;
    private static final String JMS_MSG_P = "JMS_MSG_P_";
    private static final Log logger = LogFactory.getLog((String)JmsProducer.class.getName());
    private static final String OriginalMessageID = "OrigMessageID";
    private Connection connection;
    private Session session;
    private javax.jms.MessageProducer producer;
    private JmsStore store;
    private String idString;
    private boolean isConnectionError = false;
    private boolean isInitialized = false;

    public JmsProducer(JmsStore store) {
        if (store == null) {
            logger.error((Object)"Cannot initialize.");
            return;
        }
        this.store = store;
        this.isInitialized = true;
    }

    @Override
    public boolean storeMessage(MessageContext synCtx) {
        Throwable throwable;
        boolean error;
        block18: {
            if (synCtx == null) {
                return false;
            }
            if (!this.checkConnection()) {
                logger.warn((Object)(this.getId() + ". Ignored MessageID : " + synCtx.getMessageID()));
                this.store.setCachedProducer(null);
                this.store.setProducer(null);
                return false;
            }
            StorableMessage message = MessageConverter.toStorableMessage(synCtx);
            error = false;
            throwable = null;
            try {
                ObjectMessage objectMessage = this.session.createObjectMessage((Serializable)message);
                objectMessage.setStringProperty(OriginalMessageID, synCtx.getMessageID());
                this.setPriority(this.producer, objectMessage, message);
                this.setJmsProducerProperties(this.producer, synCtx);
                this.setJmsMessageProperties((Message)objectMessage, synCtx);
                this.setTransportHeaders((Message)objectMessage, synCtx);
                this.producer.send((Message)objectMessage);
                if (this.session.getTransacted()) {
                    this.session.commit();
                }
            }
            catch (JMSException e) {
                throwable = e;
                error = true;
                this.isConnectionError = true;
                try {
                    if (this.session.getTransacted()) {
                        this.session.rollback();
                    }
                }
                catch (JMSException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Fail to rollback message [" + synCtx.getMessageID() + "] from the message store :" + this.store.getName()), (Throwable)ex);
                    }
                }
            }
            catch (Throwable t) {
                throwable = t;
                error = true;
                try {
                    if (this.session.getTransacted()) {
                        this.session.rollback();
                    }
                }
                catch (JMSException e) {
                    if (!logger.isDebugEnabled()) break block18;
                    logger.debug((Object)("Fail to rollback message [" + synCtx.getMessageID() + "] from the message store :" + this.store.getName()), (Throwable)e);
                }
            }
        }
        if (error) {
            String errorMsg = this.getId() + ". Ignored MessageID : " + synCtx.getMessageID() + ". Could not store message to store [" + this.store.getName() + "]. Error:" + throwable.getLocalizedMessage();
            logger.error((Object)errorMsg, throwable);
            try {
                this.store.closeWriteConnection();
            }
            catch (JMSException e) {
                logger.error((Object)("Error while closing connection  to store " + this.store.getName()), (Throwable)e);
            }
            this.connection = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getId() + ". Ignored MessageID : " + synCtx.getMessageID()));
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getId() + ". Stored MessageID : " + synCtx.getMessageID()));
        }
        this.store.enqueued();
        return true;
    }

    @Override
    public boolean cleanup() {
        try {
            this.store.cleanup(null, this.session);
            return true;
        }
        catch (JMSException e) {
            throw new SynapseException("Error while cleaning up connection to store " + this.store.getName(), e);
        }
    }

    public JmsProducer setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public JmsProducer setSession(Session session) {
        this.session = session;
        return this;
    }

    public JmsProducer setProducer(javax.jms.MessageProducer producer) {
        this.producer = producer;
        return this;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void setId(int id) {
        this.idString = "[" + this.store.getName() + "-P-" + id + "]";
    }

    @Override
    public String getId() {
        return this.getIdAsString();
    }

    private String getIdAsString() {
        if (this.idString == null) {
            return "[unknown-producer]";
        }
        return this.idString;
    }

    private boolean checkConnection() {
        if (this.producer == null) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)(this.getId() + " cannot proceed. Message producer is null."));
            }
            return false;
        }
        if (this.session == null) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)(this.getId() + " cannot proceed. JMS Session is null."));
            }
            return false;
        }
        if (this.connection == null) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)(this.getId() + " cannot proceed. JMS Connection is null."));
            }
            return false;
        }
        return true;
    }

    private void setPriority(javax.jms.MessageProducer producer, ObjectMessage objectMessage, StorableMessage message) {
        if (message.getPriority(4) != 4) {
            try {
                producer.setPriority(message.getPriority(4));
            }
            catch (JMSException e) {
                logger.warn((Object)(this.getId() + " could not set priority [" + message.getPriority(4) + "]"));
            }
        } else {
            try {
                producer.setPriority(4);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private void setJmsProducerProperties(javax.jms.MessageProducer producer, MessageContext synCtx) {
        block17: {
            Object prop = synCtx.getProperty(JMS_PROD_TIME_TO_LIVE);
            long ttl = 0L;
            if (prop instanceof String) {
                ttl = Long.parseLong((String)prop);
            } else if (prop instanceof Long || prop instanceof Integer) {
                ttl = Long.parseLong(prop.toString());
            }
            prop = synCtx.getProperty(JMS_PROD_DISABLE_MSG_TIMESTAMP);
            boolean disableMessageTimestamp = false;
            if (prop instanceof String) {
                disableMessageTimestamp = Boolean.parseBoolean((String)prop);
            } else if (prop instanceof Boolean) {
                disableMessageTimestamp = (Boolean)prop;
            }
            prop = synCtx.getProperty(JMS_PROD_DELIVERY_MODE);
            int deliveryMode = 2;
            if (prop instanceof Integer) {
                deliveryMode = (Integer)prop;
            } else if (prop instanceof String) {
                deliveryMode = Integer.parseInt((String)prop);
            }
            prop = synCtx.getProperty(JMS_PROD_DISABLE_MSG_ID);
            boolean disableMessageId = false;
            if (prop instanceof String) {
                disableMessageId = Boolean.parseBoolean((String)prop);
            } else if (prop instanceof Boolean) {
                disableMessageId = (Boolean)prop;
            }
            prop = synCtx.getProperty(JMS_PROD_PRIORITY);
            int priority = 4;
            if (prop instanceof Integer) {
                priority = (Integer)prop;
            } else if (prop instanceof String) {
                priority = Integer.parseInt((String)prop);
            }
            try {
                producer.setTimeToLive(ttl);
                producer.setDisableMessageTimestamp(disableMessageTimestamp);
                producer.setDeliveryMode(deliveryMode);
                producer.setDisableMessageID(disableMessageId);
                producer.setPriority(priority);
            }
            catch (JMSException e) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug((Object)("Could not save Producer property: " + e.getLocalizedMessage()));
            }
        }
    }

    private void setJmsMessageProperties(Message message, MessageContext synCtx) {
        Set properties = synCtx.getPropertyKeySet();
        for (String prop : properties) {
            if (!prop.startsWith(JMS_MSG_P)) continue;
            Object value = synCtx.getProperty(prop);
            String key = prop.substring(JMS_MSG_P.length());
            try {
                if (value instanceof String) {
                    message.setStringProperty(key, (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    message.setLongProperty(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    message.setIntProperty(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    message.setBooleanProperty(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Double) {
                    message.setDoubleProperty(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Float) {
                    message.setFloatProperty(key, ((Float)value).floatValue());
                    continue;
                }
                if (!(value instanceof Short)) continue;
                message.setShortProperty(key, ((Short)value).shortValue());
            }
            catch (JMSException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Could not save Message property: " + e.getLocalizedMessage()));
            }
        }
    }

    private void setTransportHeaders(Message message, MessageContext synCtx) {
        Map headerMap = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        if (headerMap != null) {
            for (Object headerName : headerMap.keySet()) {
                String name = (String)headerName;
                Object value = headerMap.get(name);
                try {
                    if (value instanceof String) {
                        message.setStringProperty(name, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        message.setBooleanProperty(name, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (value instanceof Integer) {
                        message.setIntProperty(name, ((Integer)value).intValue());
                        continue;
                    }
                    if (value instanceof Long) {
                        message.setLongProperty(name, ((Long)value).longValue());
                        continue;
                    }
                    if (value instanceof Double) {
                        message.setDoubleProperty(name, ((Double)value).doubleValue());
                        continue;
                    }
                    if (!(value instanceof Float)) continue;
                    message.setFloatProperty(name, ((Float)value).floatValue());
                }
                catch (JMSException ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Could not save Message property: " + ex.getLocalizedMessage()));
                }
            }
        }
    }

    public Session getSession() {
        return this.session;
    }
}

