/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.jms;

import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.StoreForwardException;
import org.apache.synapse.message.store.impl.commons.MessageConverter;
import org.apache.synapse.message.store.impl.commons.StorableMessage;
import org.apache.synapse.message.store.impl.jms.JmsStore;

public class JmsConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog((String)JmsConsumer.class.getName());
    private Connection connection;
    private Session session;
    private javax.jms.MessageConsumer consumer;
    private JmsStore store;
    private String idString;
    private boolean isInitialized;
    private CachedMessage cachedMessage;
    private boolean isReceiveError;
    private boolean isAlive;

    public JmsConsumer(JmsStore store) {
        if (store == null) {
            logger.error((Object)"Cannot initialize.");
            return;
        }
        this.store = store;
        this.cachedMessage = new CachedMessage();
        this.isReceiveError = false;
        this.isInitialized = true;
        this.isAlive = true;
    }

    @Override
    public MessageContext receive() {
        if (this.isAlive) {
            boolean connectionSuccess = this.checkAndTryConnect();
            if (!connectionSuccess) {
                throw new SynapseException(this.idString + "Error while connecting to JMS provider. " + "STORE_CONNECTION_ERROR");
            }
            try {
                Message message = this.consumer.receive(1000L);
                if (message == null) {
                    return null;
                }
                if (!(message instanceof ObjectMessage)) {
                    logger.warn((Object)("JMS Consumer " + this.getId() + " did not receive a javax.jms.ObjectMessage"));
                    message.acknowledge();
                    return null;
                }
                ObjectMessage msg = (ObjectMessage)message;
                String messageId = msg.getStringProperty("OrigMessageID");
                if (!(msg.getObject() instanceof StorableMessage)) {
                    logger.warn((Object)("JMS Consumer " + this.getId() + " did not receive a valid message."));
                    message.acknowledge();
                    return null;
                }
                StorableMessage storableMessage = (StorableMessage)msg.getObject();
                org.apache.axis2.context.MessageContext axis2Mc = this.store.newAxis2Mc();
                MessageContext synapseMc = this.store.newSynapseMc(axis2Mc);
                synapseMc = MessageConverter.toMessageContext(storableMessage, axis2Mc, synapseMc);
                this.updateCache(message, synapseMc, messageId, false);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getId() + " Received MessageId:" + messageId + " priority:" + message.getJMSPriority()));
                }
                return synapseMc;
            }
            catch (JMSException e) {
                logger.error((Object)("Cannot fetch messages from Store " + this.store.getName()));
                this.updateCache(null, null, "", true);
                this.cleanup();
                return this.receive();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to receive messages from a consumer that is not alive. Id: " + this.getId() + ", store: " + this.store.getName()));
        }
        return null;
    }

    @Override
    public boolean ack() {
        boolean result = this.cachedMessage.ack();
        if (result) {
            this.store.dequeued();
        }
        return result;
    }

    @Override
    public boolean cleanup() throws SynapseException {
        this.isAlive = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getId() + " cleaning up..."));
        }
        try {
            this.store.cleanup(this.connection, this.session);
            boolean bl = true;
            return bl;
        }
        catch (JMSException e) {
            throw new SynapseException("Error while connecting to store to close created connections. JMS provider might not be accessible " + this.store.getName() + " " + "STORE_CONNECTION_ERROR", e);
        }
        finally {
            this.connection = null;
            this.session = null;
            this.consumer = null;
        }
    }

    @Override
    public boolean isAlive() {
        if (this.isAlive) {
            try {
                this.session.getAcknowledgeMode();
            }
            catch (JMSException e) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public JmsConsumer setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public Session getSession() {
        return this.session;
    }

    public JmsConsumer setSession(Session session) {
        this.session = session;
        return this;
    }

    public javax.jms.MessageConsumer getConsumer() {
        return this.consumer;
    }

    public JmsConsumer setConsumer(javax.jms.MessageConsumer consumer) {
        this.consumer = consumer;
        return this;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void setId(int id) {
        this.idString = "[" + this.store.getName() + "-C-" + id + "]";
    }

    public void setStringId(String idString) {
        this.idString = idString;
    }

    @Override
    public String getId() {
        return this.getIdAsString();
    }

    private String getIdAsString() {
        if (this.idString == null) {
            return "[unknown-consumer]";
        }
        return this.idString;
    }

    private boolean checkAndTryConnect() {
        boolean connectionSuccess = false;
        if (this.consumer != null && this.session != null && this.connection != null) {
            connectionSuccess = true;
        } else {
            try {
                this.reconnect();
                connectionSuccess = true;
            }
            catch (SynapseException | StoreForwardException e) {
                logger.error((Object)"Error while connecting to JMS store and initializing consumer", (Throwable)e);
            }
        }
        return connectionSuccess;
    }

    private void writeToFileSystem() {
    }

    private void updateCache(Message message, MessageContext synCtx, String messageId, boolean receiveError) {
        this.isReceiveError = receiveError;
        this.cachedMessage.setMessage(message);
        this.cachedMessage.setMc(synCtx);
        this.cachedMessage.setId(messageId);
    }

    private void reconnect() throws StoreForwardException {
        logger.info((Object)("Trying to reconnect to JMS store " + this.store.getName()));
        JmsConsumer consumer = (JmsConsumer)this.store.getConsumer();
        logger.info((Object)("Successfully connected to JMS store " + this.store.getName()));
        if (consumer.getConsumer() == null && logger.isDebugEnabled()) {
            logger.debug((Object)(this.getId() + " could not reconnect to the broker."));
        }
        this.connection = consumer.getConnection();
        this.session = consumer.getSession();
        this.consumer = consumer.getConsumer();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getId() + " ===> " + consumer.getId()));
        }
    }

    private final class CachedMessage {
        private Message message = null;
        private MessageContext mc = null;
        private String id = "";

        private CachedMessage() {
        }

        public CachedMessage setMessage(Message message) {
            this.message = message;
            return this;
        }

        public boolean ack() {
            try {
                if (this.message != null) {
                    this.message.acknowledge();
                }
            }
            catch (IllegalStateException e) {
                logger.warn((Object)"JMS Session is in an illegal state. Recovering session.");
                try {
                    JmsConsumer.this.getSession().recover();
                    logger.warn((Object)"JMS Session recovered.");
                }
                catch (JMSException e1) {
                    logger.error((Object)("Error occurred while recovering session: " + e.getLocalizedMessage()), (Throwable)e);
                    return false;
                }
                return false;
            }
            catch (JMSException e) {
                logger.error((Object)(this.getId() + " cannot ack last read message. Error:" + e.getLocalizedMessage()), (Throwable)e);
                return false;
            }
            return true;
        }

        public Message getMessage() {
            return this.message;
        }

        public CachedMessage setMc(MessageContext mc) {
            this.mc = mc;
            return this;
        }

        public CachedMessage setId(String id) {
            this.id = id;
            return this;
        }

        public String getId() {
            return this.id;
        }
    }
}

