/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.datasource.DataSourceFinder;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceRepositoryHolder;
import org.apache.synapse.commons.datasource.RepositoryBasedDataSourceFinder;
import org.apache.synapse.commons.datasource.factory.DataSourceFactory;
import org.wso2.securevault.secret.SecretInformation;
import org.wso2.securevault.secret.SecretManager;

public class JDBCConfiguration {
    private static final Log log = LogFactory.getLog(JDBCConfiguration.class);
    private DataSourceInformation dataSourceInformation;
    private String dataSourceName;
    private Properties jndiProperties = new Properties();
    private DataSource dataSource;
    private String tableName;

    public void buildDataSource(Map<String, Object> parameters) {
        try {
            if (parameters.get("store.jdbc.dsName") != null) {
                this.readLookupConfig(parameters);
                this.dataSource = this.lookupDataSource();
            } else if (parameters.get("store.jdbc.driver") != null) {
                this.readCustomDataSourceConfig(parameters);
                this.dataSource = this.createCustomDataSource();
            } else {
                this.handleException("The DataSource connection information must be specified for using a custom DataSource connection pool or for a JNDI lookup");
            }
            this.tableName = parameters.get("store.jdbc.table") != null ? (String)parameters.get("store.jdbc.table") : "jdbc_message_store";
        }
        catch (Exception e) {
            log.error((Object)"Error looking up DataSource connection information: ", (Throwable)e);
        }
    }

    private void readLookupConfig(Map<String, Object> parameters) {
        String dataSourceName = (String)parameters.get("store.jdbc.dsName");
        this.setDataSourceName(dataSourceName);
        if (parameters.get("store.jdbc.icClass") != null) {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", parameters.get("store.jdbc.icClass"));
            props.put("java.naming.provider.url", parameters.get("store.jdbc.connection.url"));
            props.put("java.naming.security.principal", parameters.get("store.jdbc.username"));
            props.put("java.naming.security.credentials", parameters.get("store.jdbc.password"));
            this.setJndiProperties(props);
        }
    }

    private void readCustomDataSourceConfig(Map<String, Object> parameters) {
        DataSourceInformation dataSourceInformation = new DataSourceInformation();
        dataSourceInformation.setDriver((String)parameters.get("store.jdbc.driver"));
        dataSourceInformation.setUrl((String)parameters.get("store.jdbc.connection.url"));
        SecretInformation secretInformation = new SecretInformation();
        secretInformation.setUser((String)parameters.get("store.jdbc.username"));
        secretInformation.setAliasSecret((String)parameters.get("store.jdbc.password"));
        dataSourceInformation.setSecretInformation(secretInformation);
        this.setDataSourceInformation(dataSourceInformation);
    }

    private DataSource lookupDataSource() {
        DataSource dataSource = null;
        RepositoryBasedDataSourceFinder finder = DataSourceRepositoryHolder.getInstance().getRepositoryBasedDataSourceFinder();
        if (finder.isInitialized()) {
            dataSource = finder.find(this.dataSourceName);
        }
        if (dataSource == null) {
            String password = this.jndiProperties.getProperty("java.naming.security.credentials");
            if (password != null && !"".equals(password)) {
                this.jndiProperties.put("java.naming.security.credentials", this.getActualPassword(password));
            }
            if ((dataSource = DataSourceFinder.find((String)this.dataSourceName, (Properties)this.jndiProperties)) == null) {
                this.handleException("Cannot find a DataSource " + this.dataSourceName + " for given JNDI properties :" + this.jndiProperties);
            }
        }
        if (dataSource != null) {
            log.info((Object)("Successfully looked up datasource " + this.dataSourceName));
        }
        return dataSource;
    }

    protected DataSource createCustomDataSource() {
        DataSource dataSource = DataSourceFactory.createDataSource((DataSourceInformation)this.dataSourceInformation);
        if (dataSource != null) {
            log.info((Object)("Successfully created data source for " + this.dataSourceInformation.getUrl()));
        }
        return dataSource;
    }

    private String getActualPassword(String aliasPassword) {
        SecretManager secretManager = SecretManager.getInstance();
        if (secretManager.isInitialized()) {
            return secretManager.getSecret(aliasPassword);
        }
        return aliasPassword;
    }

    public Connection getConnection() throws SQLException {
        Connection con = this.getDataSource().getConnection();
        if (con == null) {
            String msg = "Connection from DataSource " + this.getDSName() + " is null.";
            throw new SynapseException(msg);
        }
        return con;
    }

    public String getDSName() {
        if (this.dataSourceName != null) {
            return this.dataSourceName;
        }
        if (this.dataSourceInformation != null) {
            String name = this.dataSourceInformation.getUrl();
            if (name == null) {
                name = this.dataSourceInformation.getDatasourceName();
            }
            return name;
        }
        return null;
    }

    public void setDataSourceInformation(DataSourceInformation dataSourceInformation) {
        this.dataSourceInformation = dataSourceInformation;
    }

    public void setJndiProperties(Properties jndiProperties) {
        this.jndiProperties = jndiProperties;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    private void handleException(Object o) {
        log.error(o);
    }
}

