/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.store.impl.jdbc.JDBCMessageStore;

public class JDBCProducer
implements MessageProducer {
    private static final Log logger = LogFactory.getLog((String)JDBCProducer.class.getName());
    private JDBCMessageStore store;
    private String producerId;

    public JDBCProducer(JDBCMessageStore store) {
        this.store = store;
    }

    @Override
    public boolean storeMessage(MessageContext synCtx) {
        boolean success = false;
        try {
            success = this.store.store(synCtx);
            this.store.enqueued();
        }
        catch (SynapseException e) {
            logger.error((Object)("Error while storing message : " + synCtx.getMessageID()), (Throwable)e);
        }
        return success;
    }

    @Override
    public boolean cleanup() {
        return true;
    }

    @Override
    public void setId(int id) {
        this.producerId = "[" + this.store.getName() + "-P-" + id + "]";
    }

    @Override
    public String getId() {
        if (this.producerId == null) {
            return "[unknown-producer]";
        }
        return this.producerId;
    }
}

