/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.store.AbstractMessageStore;
import org.apache.synapse.message.store.impl.commons.MessageConverter;
import org.apache.synapse.message.store.impl.commons.StorableMessage;
import org.apache.synapse.message.store.impl.jdbc.JDBCConsumer;
import org.apache.synapse.message.store.impl.jdbc.JDBCProducer;
import org.apache.synapse.message.store.impl.jdbc.StoreException;
import org.apache.synapse.message.store.impl.jdbc.util.JDBCConfiguration;
import org.apache.synapse.message.store.impl.jdbc.util.Statement;

public class JDBCMessageStore
extends AbstractMessageStore {
    private JDBCConfiguration jdbcConfiguration;
    private static final Log logger = LogFactory.getLog((String)JDBCMessageStore.class.getName());
    private final ReentrantLock removeLock = new ReentrantLock();
    private final ReentrantLock cleanUpOfferLock = new ReentrantLock();
    private final AtomicBoolean cleaningFlag = new AtomicBoolean(false);
    protected static final String MESSAGE_COLUMN_NAME = "message";

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing JDBC Message Store");
        }
        super.init(synapseEnvironment);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing Datasource and Properties");
        }
        this.jdbcConfiguration = new JDBCConfiguration();
        this.jdbcConfiguration.buildDataSource(this.parameters);
    }

    protected JDBCConfiguration getJdbcConfiguration() {
        return this.jdbcConfiguration;
    }

    @Override
    public MessageProducer getProducer() {
        JDBCProducer producer = new JDBCProducer(this);
        producer.setId(this.nextProducerId());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getNameString() + " created a new JDBC Message Producer."));
        }
        return producer;
    }

    @Override
    public MessageConsumer getConsumer() {
        JDBCConsumer consumer = new JDBCConsumer(this);
        consumer.setId(this.nextConsumerId());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getNameString() + " created a new JDBC Message Consumer."));
        }
        return consumer;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        super.setParameters(parameters);
        if (this.jdbcConfiguration != null) {
            this.jdbcConfiguration.buildDataSource(parameters);
        }
    }

    private MessageContext getResultMessageContextFromDatabase(Statement statement) throws SynapseException {
        List<Map> processedRows = this.getProcessedRows(statement);
        boolean firstRowIndex = false;
        MessageContext messageContext = null;
        if (processedRows.size() > 0) {
            Map messageContentRow = processedRows.get(0);
            messageContext = (MessageContext)messageContentRow.get(MESSAGE_COLUMN_NAME);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Number of rows processed:" + processedRows + " calling the statement " + statement.getStatement()));
                logger.debug((Object)("Message content with mid:" + messageContext.getMessageID() + " will be returned"));
            }
        }
        return messageContext;
    }

    protected List<Map> getProcessedRows(Statement statement) {
        List<Map> elements;
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            con = this.jdbcConfiguration.getConnection();
            ps = con.prepareStatement(statement.getStatement());
            int index = 1;
            for (Object param : statement.getParameters()) {
                if (param instanceof String) {
                    ps.setString(index, (String)param);
                } else if (param instanceof Long) {
                    ps.setLong(index, (Long)param);
                } else if (param instanceof Integer) {
                    ps.setInt(index, (Integer)param);
                }
                ++index;
            }
            rs = ps.executeQuery();
            elements = statement.getResult(rs);
            this.close(con, ps, rs);
        }
        catch (SQLException e) {
            try {
                throw new SynapseException("Processing Statement failed : " + statement.getStatement() + " against DataSource : " + this.jdbcConfiguration.getDSName(), e);
            }
            catch (Throwable throwable) {
                this.close(con, ps, rs);
                throw throwable;
            }
        }
        return elements;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MessageContext deserializeMessage(byte[] msgObj) {
        MessageContext messageContext = null;
        if (msgObj == null) throw new SynapseException("Retrieved Object is null");
        ObjectInputStream ios = null;
        try {
            ios = new ObjectInputStream(new ByteArrayInputStream(msgObj));
            Object msg = ios.readObject();
            if (msg instanceof StorableMessage) {
                StorableMessage jdbcMsg = (StorableMessage)msg;
                org.apache.axis2.context.MessageContext axis2Mc = this.newAxis2Mc();
                MessageContext synapseMc = this.newSynapseMc(axis2Mc);
                messageContext = MessageConverter.toMessageContext(jdbcMsg, axis2Mc, synapseMc);
            }
            if (ios == null) return messageContext;
            this.closeStream(ios);
            return messageContext;
        }
        catch (IOException e) {
            try {
                throw new SynapseException("Error reading object input stream", e);
                catch (ClassNotFoundException e2) {
                    throw new SynapseException("Could not find the class", e2);
                }
            }
            catch (Throwable throwable) {
                if (ios == null) throw throwable;
                this.closeStream(ios);
                throw throwable;
            }
        }
    }

    private void closeStream(ObjectInputStream ios) {
        try {
            ios.close();
        }
        catch (IOException e) {
            logger.error((Object)"Error while closing object input stream", (Throwable)e);
        }
    }

    private org.apache.axis2.context.MessageContext newAxis2Mc() {
        return ((Axis2SynapseEnvironment)this.synapseEnvironment).getAxis2ConfigurationContext().createMessageContext();
    }

    private MessageContext newSynapseMc(org.apache.axis2.context.MessageContext msgCtx) {
        SynapseConfiguration configuration = this.synapseEnvironment.getSynapseConfiguration();
        return new Axis2MessageContext(msgCtx, configuration, this.synapseEnvironment);
    }

    private void rollback(Connection connection, String task) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.warn((Object)("Rollback failed on " + task), (Throwable)e);
            }
        }
    }

    private boolean processNonResultingStatement(List<Statement> statements) throws SynapseException {
        boolean result;
        Connection connection = null;
        java.sql.Statement preparedStatement = null;
        try {
            connection = this.jdbcConfiguration.getConnection();
            connection.setAutoCommit(false);
            for (Statement statement : statements) {
                preparedStatement = connection.prepareStatement(statement.getStatement());
                int index = 1;
                for (Object param : statement.getParameters()) {
                    if (param instanceof String) {
                        preparedStatement.setString(index, (String)param);
                    } else if (param instanceof Long) {
                        preparedStatement.setLong(index, (Long)param);
                    } else if (param instanceof StorableMessage) {
                        preparedStatement.setBytes(index, this.serialize(param));
                    }
                    ++index;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing statement:" + preparedStatement));
                }
                preparedStatement.execute();
            }
            connection.commit();
            result = true;
        }
        catch (IOException | SQLException e) {
            this.rollback(connection, "deleting message");
            throw new SynapseException("Processing Statement failed against DataSource : " + this.jdbcConfiguration.getDSName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Error while closing prepared statement", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Error while closing connection", (Throwable)e);
                }
            }
        }
        return result;
    }

    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(obj);
        return b.toByteArray();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.jdbcConfiguration = null;
    }

    public boolean store(MessageContext messageContext) throws SynapseException {
        if (messageContext == null) {
            logger.error((Object)"Message is null, can't store into database");
            return false;
        }
        boolean cleaningState = false;
        try {
            if (this.cleaningFlag.get()) {
                try {
                    this.cleanUpOfferLock.lock();
                    cleaningState = true;
                }
                catch (Exception e) {
                    logger.error((Object)"Message Cleanup lock released unexpectedly", (Throwable)e);
                }
            }
            ArrayList<Statement> statements = new ArrayList<Statement>();
            Statement statement = this.getStoreMessageStatement(messageContext, null);
            statements.add(statement);
            boolean bl = this.processNonResultingStatement(statements);
            return bl;
        }
        catch (Exception e) {
            throw new SynapseException("Error while creating StorableMessage", e);
        }
        finally {
            if (cleaningState) {
                this.cleanUpOfferLock.unlock();
            }
        }
    }

    protected Statement getStoreMessageStatement(MessageContext messageContext, Long sequenceId) throws StoreException {
        Statement statement;
        StorableMessage persistentMessage = MessageConverter.toStorableMessage(messageContext);
        String msgId = persistentMessage.getAxis2message().getMessageID();
        if (null == sequenceId) {
            String insertMessageStatement = "INSERT INTO " + this.jdbcConfiguration.getTableName() + " (msg_id,message) VALUES (?,?)";
            statement = new Statement(insertMessageStatement){

                @Override
                public List<Map> getResult(ResultSet resultSet) {
                    throw new UnsupportedOperationException();
                }
            };
            statement.addParameter(msgId);
            statement.addParameter(persistentMessage);
        } else {
            String insertMessageWithSequenceIdStatement = "INSERT INTO " + this.jdbcConfiguration.getTableName() + " (msg_id,seq_id,message) VALUES (?,?,?)";
            statement = new Statement(insertMessageWithSequenceIdStatement){

                @Override
                public List<Map> getResult(ResultSet resultSet) {
                    throw new UnsupportedOperationException();
                }
            };
            statement.addParameter(msgId);
            statement.addParameter(sequenceId);
            statement.addParameter(persistentMessage);
        }
        return statement;
    }

    public MessageContext peek() throws SynapseException {
        MessageContext msg;
        try {
            Statement statement = new Statement("SELECT message FROM " + this.jdbcConfiguration.getTableName() + " WHERE indexId=(SELECT min(indexId) from " + this.jdbcConfiguration.getTableName() + ")"){

                @Override
                public List<Map> getResult(ResultSet resultSet) throws SQLException {
                    return JDBCMessageStore.this.messageContentResultSet(resultSet, this.getStatement());
                }
            };
            msg = this.getResultMessageContextFromDatabase(statement);
        }
        catch (SynapseException se) {
            throw new SynapseException("Error while peek the message", se);
        }
        return msg;
    }

    @Override
    public MessageContext remove() throws NoSuchElementException {
        MessageContext messageContext = this.peek();
        if ((messageContext = this.remove(messageContext.getMessageID())) != null) {
            return messageContext;
        }
        throw new NoSuchElementException("First element not found and remove failed !");
    }

    @Override
    public MessageContext remove(String msgId) throws SynapseException {
        MessageContext result;
        boolean cleaningState = false;
        try {
            if (this.cleaningFlag.get()) {
                try {
                    this.removeLock.lock();
                    cleaningState = true;
                }
                catch (Exception ie) {
                    logger.error((Object)"Message Cleanup lock released unexpectedly", (Throwable)ie);
                }
            }
            result = this.get(msgId);
            List<Statement> statements = this.removeMessageStatement(msgId);
            this.processNonResultingStatement(statements);
        }
        catch (Exception e) {
            throw new SynapseException("Removing message with id = " + msgId + " failed !", e);
        }
        finally {
            if (cleaningState) {
                this.removeLock.unlock();
            }
        }
        return result;
    }

    protected List<Statement> removeMessageStatement(String msgId) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        Statement statement = new Statement("DELETE FROM " + this.jdbcConfiguration.getTableName() + " WHERE msg_id=?"){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                throw new UnsupportedOperationException();
            }
        };
        statement.addParameter(msgId);
        statements.add(statement);
        return statements;
    }

    @Override
    public void clear() {
        try {
            logger.warn((Object)(this.getNameString() + "deleting all entries"));
            this.removeLock.lock();
            this.cleanUpOfferLock.lock();
            this.cleaningFlag.set(true);
            Statement statement = new Statement("DELETE FROM " + this.jdbcConfiguration.getTableName()){

                @Override
                public List<Map> getResult(ResultSet resultSet) throws SQLException {
                    throw new UnsupportedOperationException();
                }
            };
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(statement);
            this.processNonResultingStatement(statements);
        }
        catch (Exception e) {
            logger.error((Object)"Clearing store failed !", (Throwable)e);
        }
        finally {
            this.cleaningFlag.set(false);
            this.removeLock.unlock();
            this.cleanUpOfferLock.unlock();
        }
    }

    @Override
    public MessageContext get(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Index:" + position + " out of table bound");
        }
        Statement statement = new Statement("SELECT message FROM " + this.jdbcConfiguration.getTableName() + " ORDER BY indexId ASC LIMIT ?,1 "){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                return JDBCMessageStore.this.messageContentResultSet(resultSet, this.getStatement());
            }
        };
        statement.addParameter(position);
        return this.getResultMessageContextFromDatabase(statement);
    }

    @Override
    public List<MessageContext> getAll() {
        Statement statement;
        MessageContext result;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getNameString() + " retrieving all messages from the store."));
        }
        if ((result = this.getResultMessageContextFromDatabase(statement = new Statement("SELECT message FROM " + this.jdbcConfiguration.getTableName()){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                return JDBCMessageStore.this.messageContentResultSet(resultSet, this.getStatement());
            }
        })) != null) {
            ArrayList<MessageContext> msgs = new ArrayList<MessageContext>();
            msgs.add(result);
            return msgs;
        }
        return null;
    }

    @Override
    public MessageContext get(String msgId) {
        Statement statement = new Statement("SELECT indexId,message FROM " + this.jdbcConfiguration.getTableName() + " WHERE msg_id=?"){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                return JDBCMessageStore.this.messageContentResultSet(resultSet, this.getStatement());
            }
        };
        statement.addParameter(msgId);
        return this.getResultMessageContextFromDatabase(statement);
    }

    protected List<Map> messageContentResultSet(ResultSet resultSet, String statement) throws SQLException {
        ArrayList<Map> elements = new ArrayList<Map>();
        while (resultSet.next()) {
            try {
                HashMap<String, MessageContext> rowData = new HashMap<String, MessageContext>();
                byte[] msgObj = resultSet.getBytes(MESSAGE_COLUMN_NAME);
                MessageContext responseMessageContext = this.deserializeMessage(msgObj);
                rowData.put(MESSAGE_COLUMN_NAME, responseMessageContext);
                elements.add(rowData);
            }
            catch (SQLException e) {
                String message = "Error executing statement : " + statement + " against DataSource : " + this.jdbcConfiguration.getDSName();
                throw new SynapseException(message, e);
            }
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        int size = 0;
        Statement statement = new Statement("SELECT COUNT(*) FROM " + this.jdbcConfiguration.getTableName()){

            @Override
            public List<Map> getResult(ResultSet resultSet) throws SQLException {
                return JDBCMessageStore.this.messageContentResultSet(resultSet, this.getStatement());
            }
        };
        try {
            con = this.jdbcConfiguration.getConnection();
            ps = con.prepareStatement(statement.getStatement());
            rs = ps.executeQuery();
            while (rs.next()) {
                try {
                    size = rs.getInt(1);
                }
                catch (Exception e) {
                    logger.error((Object)("Error executing statement : " + statement.getStatement() + " against DataSource : " + this.jdbcConfiguration.getDSName()), (Throwable)e);
                    break;
                }
            }
            this.close(con, ps, rs);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("Error executing statement : " + statement.getStatement() + " against DataSource : " + this.jdbcConfiguration.getDSName()), (Throwable)e);
                this.close(con, ps, rs);
            }
            catch (Throwable throwable) {
                this.close(con, ps, rs);
                throw throwable;
            }
        }
        return size;
    }

    private String getNameString() {
        return "Store [" + this.getName() + "]";
    }

    private void close(Connection con, PreparedStatement ps, ResultSet rs) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                logger.error((Object)"Error while closing prepared statement", (Throwable)e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)"Error while closing result set", (Throwable)e);
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                logger.error((Object)"Error while closing connection", (Throwable)e);
            }
        }
    }
}

