/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.store.impl.jdbc.JDBCMessageStore;

public class JDBCConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog((String)JDBCConsumer.class.getName());
    private JDBCMessageStore store;
    private String consumerId;
    private String currentMessageId;
    private boolean isAlive;

    public JDBCConsumer(JDBCMessageStore store) {
        this.store = store;
        this.isAlive = true;
    }

    @Override
    public MessageContext receive() {
        if (this.isAlive()) {
            MessageContext msg = null;
            try {
                msg = this.store.peek();
                if (msg != null) {
                    this.currentMessageId = msg.getMessageID();
                }
            }
            catch (SynapseException e) {
                logger.error((Object)"Can't receive message ", (Throwable)e);
            }
            return msg;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Trying to receive messages from a consumer that is not alive.");
        }
        return null;
    }

    @Override
    public boolean ack() {
        MessageContext msg = this.store.remove(this.currentMessageId);
        if (msg != null) {
            this.store.dequeued();
            return true;
        }
        return false;
    }

    @Override
    public boolean cleanup() {
        this.currentMessageId = null;
        return true;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    @Override
    public void setId(int id) {
        this.consumerId = "[" + this.store.getName() + "-C-" + id + "]";
    }

    @Override
    public String getId() {
        if (this.consumerId == null) {
            return "[unknown-consumer]";
        }
        return this.consumerId;
    }
}

