/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store.impl.commons;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.message.store.impl.commons.Axis2Message;
import org.apache.synapse.message.store.impl.commons.StorableMessage;
import org.apache.synapse.message.store.impl.commons.SynapseMessage;
import org.apache.synapse.util.UUIDGenerator;

public final class MessageConverter {
    private static final String ABSTRACT_MC_PROPERTIES = "ABSTRACT_MC_PROPERTIES";
    private static final String JMS_PRIORITY = "JMS_PRIORITY";
    private static final String HEADER_STRING = "Header";
    private static final String OM_ELEMENT_PREFIX = "OM_ELEMENT_PREFIX_";
    private static final Log logger = LogFactory.getLog((String)MessageConverter.class.getName());
    private static final Replace RS_HYPHEN = new Replace("-", "__HYPHEN__");
    private static final Replace RS_EQUAL = new Replace("=", "__EQUAL__");
    private static final Replace RS_SLASH = new Replace("/", "__SLASH__");
    private static final Replace RS_COMMA = new Replace(",", "__COMMA__");
    private static final Replace RS_SPACE = new Replace(" ", "__SPACE__");
    private static final Replace RS_COLON = new Replace(":", "__COLON__");
    private static final Replace RS_SEMICOLON = new Replace(";", "__SEMICOLON__");

    private MessageConverter() {
    }

    public static MessageContext toMessageContext(StorableMessage message, org.apache.axis2.context.MessageContext axis2Ctx, MessageContext synCtx) {
        if (message == null) {
            logger.error((Object)"Cannot create Message Context. Message is null.");
            return null;
        }
        AxisConfiguration axisConfig = axis2Ctx.getConfigurationContext().getAxisConfiguration();
        if (axisConfig == null) {
            logger.warn((Object)"Cannot create AxisConfiguration. AxisConfiguration is null.");
            return null;
        }
        Axis2Message axis2Msg = message.getAxis2message();
        try {
            Object value;
            AxisService axisService;
            SOAPEnvelope envelope = MessageConverter.getSoapEnvelope(axis2Msg.getSoapEnvelope());
            axis2Ctx.setEnvelope(envelope);
            axis2Ctx.getOptions().setAction(axis2Msg.getAction());
            if (axis2Msg.getRelatesToMessageId() != null) {
                axis2Ctx.addRelatesTo(new RelatesTo(axis2Msg.getRelatesToMessageId()));
            }
            axis2Ctx.setMessageID(axis2Msg.getMessageID());
            axis2Ctx.getOptions().setAction(axis2Msg.getAction());
            axis2Ctx.setDoingREST(axis2Msg.isDoingPOX());
            axis2Ctx.setDoingMTOM(axis2Msg.isDoingMTOM());
            axis2Ctx.setDoingSwA(axis2Msg.isDoingSWA());
            if (axis2Msg.getService() != null && (axisService = axisConfig.getServiceForActivation(axis2Msg.getService())) != null) {
                AxisOperation axisOperation = axisService.getOperation(axis2Msg.getOperationName());
                axis2Ctx.setFLOW(axis2Msg.getFLOW());
                ArrayList executionChain = new ArrayList();
                if (axis2Msg.getFLOW() == 2) {
                    executionChain.addAll(axisOperation.getPhasesOutFlow());
                    executionChain.addAll(axisConfig.getOutFlowPhases());
                } else if (axis2Msg.getFLOW() == 4) {
                    executionChain.addAll(axisOperation.getPhasesOutFaultFlow());
                    executionChain.addAll(axisConfig.getOutFlowPhases());
                }
                axis2Ctx.setExecutionChain(executionChain);
                ConfigurationContext configurationContext = axis2Ctx.getConfigurationContext();
                axis2Ctx.setAxisService(axisService);
                ServiceGroupContext serviceGroupContext = configurationContext.createServiceGroupContext(axisService.getAxisServiceGroup());
                ServiceContext serviceContext = serviceGroupContext.getServiceContext(axisService);
                OperationContext operationContext = serviceContext.createOperationContext(axis2Msg.getOperationName());
                axis2Ctx.setServiceContext(serviceContext);
                axis2Ctx.setOperationContext(operationContext);
                axis2Ctx.setAxisService(axisService);
                axis2Ctx.setAxisOperation(axisOperation);
            } else if (axis2Ctx.getOperationContext() == null) {
                axis2Ctx.setOperationContext(new OperationContext((AxisOperation)new InOutAxisOperation(), new ServiceContext()));
            }
            if (axis2Msg.getReplyToAddress() != null) {
                axis2Ctx.setReplyTo(new EndpointReference(axis2Msg.getReplyToAddress().trim()));
            }
            if (axis2Msg.getFaultToAddress() != null) {
                axis2Ctx.setFaultTo(new EndpointReference(axis2Msg.getFaultToAddress().trim()));
            }
            if (axis2Msg.getFromAddress() != null) {
                axis2Ctx.setFrom(new EndpointReference(axis2Msg.getFromAddress().trim()));
            }
            if (axis2Msg.getToAddress() != null) {
                axis2Ctx.getOptions().setTo(new EndpointReference(axis2Msg.getToAddress().trim()));
            }
            Object map = axis2Msg.getProperties().get(ABSTRACT_MC_PROPERTIES);
            axis2Msg.getProperties().remove(ABSTRACT_MC_PROPERTIES);
            axis2Ctx.setProperties(axis2Msg.getProperties());
            axis2Ctx.setTransportIn(axisConfig.getTransportIn(axis2Msg.getTransportInName()));
            axis2Ctx.setTransportOut(axisConfig.getTransportOut(axis2Msg.getTransportOutName()));
            Object headers = axis2Msg.getProperties().get("TRANSPORT_HEADERS");
            if (headers instanceof Map) {
                MessageConverter.setTransportHeaders(axis2Ctx, (Map)headers);
            }
            if (map instanceof Map) {
                Map abstractMCProperties = (Map)map;
                for (String property : abstractMCProperties.keySet()) {
                    value = abstractMCProperties.get(property);
                    axis2Ctx.setProperty(property, value);
                }
            }
            if (axis2Msg.getJsonStream() != null) {
                JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)axis2Ctx, (InputStream)new ByteArrayInputStream(axis2Msg.getJsonStream()), (boolean)true, (boolean)true);
            }
            SynapseMessage synMsg = message.getSynapseMessage();
            synCtx.setTracingState(synMsg.getTracingState());
            synCtx.setMessageFlowTracingState(synMsg.getMessageFlowTracingState());
            for (String key : synMsg.getProperties().keySet()) {
                value = synMsg.getProperties().get(key);
                synCtx.setProperty(key, value);
            }
            for (String key : synMsg.getPropertyObjects().keySet()) {
                byte[] value2 = synMsg.getPropertyObjects().get(key);
                if (!key.startsWith(OM_ELEMENT_PREFIX)) continue;
                String originalKey = key.substring(OM_ELEMENT_PREFIX.length(), key.length());
                ByteArrayInputStream is = new ByteArrayInputStream(value2);
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)is);
                OMElement omElement = builder.getDocumentElement();
                synCtx.setProperty(originalKey, omElement);
            }
            synCtx.setFaultResponse(synMsg.isFaultResponse());
            synCtx.setResponse(synMsg.isResponse());
            return synCtx;
        }
        catch (Exception e) {
            logger.error((Object)("Cannot create Message Context. Error:" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    public static StorableMessage toStorableMessage(MessageContext synCtx) {
        StorableMessage message = new StorableMessage();
        Axis2Message axis2msg = new Axis2Message();
        SynapseMessage synMsg = new SynapseMessage();
        if (synCtx instanceof Axis2MessageContext) {
            Object value;
            Axis2MessageContext axis2MessageContext = (Axis2MessageContext)synCtx;
            org.apache.axis2.context.MessageContext msgCtx = axis2MessageContext.getAxis2MessageContext();
            axis2msg.setMessageID(UUIDGenerator.getUUID());
            if (msgCtx.getAxisOperation() != null) {
                axis2msg.setOperationAction(msgCtx.getAxisOperation().getSoapAction());
                axis2msg.setOperationName(msgCtx.getAxisOperation().getName());
            }
            if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)msgCtx)) {
                axis2msg.setJsonStream(JsonUtil.jsonPayloadToByteArray((org.apache.axis2.context.MessageContext)msgCtx));
            }
            axis2msg.setAction(msgCtx.getOptions().getAction());
            if (msgCtx.getAxisService() != null) {
                axis2msg.setService(msgCtx.getAxisService().getName());
            }
            if (msgCtx.getRelatesTo() != null) {
                axis2msg.setRelatesToMessageId(msgCtx.getRelatesTo().getValue());
            }
            if (msgCtx.getReplyTo() != null) {
                axis2msg.setReplyToAddress(msgCtx.getReplyTo().getAddress());
            }
            if (msgCtx.getFaultTo() != null) {
                axis2msg.setFaultToAddress(msgCtx.getFaultTo().getAddress());
            }
            if (msgCtx.getTo() != null) {
                axis2msg.setToAddress(msgCtx.getTo().getAddress());
            }
            axis2msg.setDoingPOX(msgCtx.isDoingREST());
            axis2msg.setDoingMTOM(msgCtx.isDoingMTOM());
            axis2msg.setDoingSWA(msgCtx.isDoingSwA());
            String soapEnvelope = msgCtx.getEnvelope().toString();
            axis2msg.setSoapEnvelope(soapEnvelope);
            axis2msg.setFLOW(msgCtx.getFLOW());
            if (msgCtx.getTransportIn() != null) {
                axis2msg.setTransportInName(msgCtx.getTransportIn().getName());
            }
            if (msgCtx.getTransportOut() != null) {
                axis2msg.setTransportOutName(msgCtx.getTransportOut().getName());
            }
            Iterator abstractMCProperties = msgCtx.getPropertyNames();
            HashMap<String, Object> copy = new HashMap<String, Object>(msgCtx.getProperties().size());
            while (abstractMCProperties.hasNext()) {
                String propertyName = (String)abstractMCProperties.next();
                Object propertyValue = msgCtx.getProperty(propertyName);
                if (propertyValue instanceof String || propertyValue instanceof Boolean || propertyValue instanceof Integer || propertyValue instanceof Double || propertyValue instanceof Character) {
                    copy.put(propertyName, propertyValue);
                }
                if (!JMS_PRIORITY.equals(propertyName)) continue;
                if (propertyValue instanceof Integer) {
                    message.setPriority((Integer)propertyValue);
                    continue;
                }
                if (!(propertyValue instanceof String)) continue;
                try {
                    int value2 = Integer.parseInt((String)propertyValue);
                    message.setPriority(value2);
                }
                catch (NumberFormatException value2) {}
            }
            axis2msg.addProperty(ABSTRACT_MC_PROPERTIES, copy);
            if (msgCtx.getProperties().containsKey("INTERNAL_TRANSACTION_COUNTED")) {
                axis2msg.addProperty("INTERNAL_TRANSACTION_COUNTED", msgCtx.getProperty("INTERNAL_TRANSACTION_COUNTED"));
            }
            Map<String, String> transportHeaders = MessageConverter.getTransportHeaders(msgCtx);
            axis2msg.addProperty("TRANSPORT_HEADERS", transportHeaders);
            for (String key : msgCtx.getProperties().keySet()) {
                value = msgCtx.getProperty(key);
                if (!(value instanceof String)) continue;
                axis2msg.addProperty(key, value);
            }
            message.setAxis2message(axis2msg);
            synMsg.setFaultResponse(synCtx.isFaultResponse());
            synMsg.setTracingState(synCtx.getTracingState());
            synMsg.setMessageFlowTracingState(synCtx.getMessageFlowTracingState());
            synMsg.setResponse(synCtx.isResponse());
            for (String key : synCtx.getPropertyKeySet()) {
                if (MessageConverter.isExcludedMessageStoreProperty(key)) {
                    if (!"proxy.name".equals(key) && !"SYNAPSE_REST_API".equals(key) || !((value = synCtx.getProperty(key)) instanceof String)) continue;
                    synMsg.addProperty("service.logger.name", (String)value);
                    continue;
                }
                value = synCtx.getProperty(key);
                if (value instanceof String) {
                    synMsg.addProperty(key, (String)value);
                }
                if (!(value instanceof ArrayList) || ((ArrayList)value).size() <= 0 || !(((ArrayList)value).get(0) instanceof OMElement)) continue;
                OMElement elem = (OMElement)((ArrayList)value).get(0);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    elem.serialize((OutputStream)bos);
                    byte[] bytes = bos.toByteArray();
                    synMsg.addPropertyObject(OM_ELEMENT_PREFIX + key, bytes);
                }
                catch (XMLStreamException e) {
                    logger.error((Object)"Error while converting OMElement to byte array", (Throwable)e);
                }
            }
        } else {
            throw new SynapseException("Cannot store message to store.");
        }
        message.setSynapseMessage(synMsg);
        return message;
    }

    private static boolean isExcludedMessageStoreProperty(String property) {
        return "proxy.name".equals(property) || "SYNAPSE_REST_API".equals(property) || "SYNAPSE_RESOURCE".equals(property);
    }

    private static SOAPEnvelope getSoapEnvelope(String soapEnvelpe) {
        OMElement response;
        try {
            response = AXIOMUtil.stringToOM((String)soapEnvelpe);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot create SOAP Envelop. Error:" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
        String soapNamespace = response.getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        if (response.getFirstElement().getLocalName().contains(HEADER_STRING)) {
            SOAPHeader header = soapEnvelope.getHeader();
            SOAPFactory fac = (SOAPFactory)soapEnvelope.getOMFactory();
            Iterator headers = response.getFirstElement().getChildElements();
            while (headers.hasNext()) {
                OMElement soapHeader = (OMElement)headers.next();
                SOAPHeaderBlock hb = header.addHeaderBlock(soapHeader.getLocalName(), fac.createOMNamespace(soapHeader.getNamespace().getNamespaceURI(), soapHeader.getNamespace().getPrefix()));
                hb.setText(soapHeader.getText());
                Iterator elements = soapHeader.getChildElements();
                while (elements.hasNext()) {
                    hb.addChild((OMNode)elements.next());
                }
            }
            response.getFirstElement().detach();
        }
        if (response.getFirstElement().getFirstElement() != null) {
            soapEnvelope.getBody().addChild((OMNode)response.getFirstElement().getFirstElement());
        }
        return soapEnvelope;
    }

    private static byte[] getUTF8Bytes(String soapEnvelpe) {
        byte[] bytes;
        try {
            bytes = soapEnvelpe.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("Unable to extract bytes in UTF-8 encoding. Extracting bytes in the system default encoding" + e.getMessage()));
            bytes = soapEnvelpe.getBytes();
        }
        return bytes;
    }

    private static Map<String, String> getTransportHeaders(org.apache.axis2.context.MessageContext messageContext) {
        Object headers = messageContext.getProperty("TRANSPORT_HEADERS");
        if (!(headers instanceof Map)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> httpHeaders = new TreeMap<String, String>();
        for (Map.Entry headerStr : ((Map)headers).entrySet()) {
            String fieldName = String.valueOf(headerStr.getKey());
            String fieldValue = String.valueOf(headerStr.getValue());
            fieldName = fieldName.replaceAll(MessageConverter.RS_HYPHEN.CHAR, MessageConverter.RS_HYPHEN.STRING);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_HYPHEN.CHAR, MessageConverter.RS_HYPHEN.STRING);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_EQUAL.CHAR, MessageConverter.RS_EQUAL.STRING);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_SLASH.CHAR, MessageConverter.RS_SLASH.STRING);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_COMMA.CHAR, MessageConverter.RS_COMMA.STRING);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_SPACE.CHAR, MessageConverter.RS_SPACE.STRING);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_COLON.CHAR, MessageConverter.RS_COLON.STRING);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_SEMICOLON.CHAR, MessageConverter.RS_SEMICOLON.STRING);
            httpHeaders.put(fieldName, fieldValue);
        }
        return httpHeaders;
    }

    private static void setTransportHeaders(org.apache.axis2.context.MessageContext msgCtx, Map headers) {
        if (headers == null || msgCtx == null) {
            return;
        }
        TreeMap<String, String> httpHeaders = new TreeMap<String, String>();
        for (Map.Entry headerEntry : headers.entrySet()) {
            String fieldName = (String)headerEntry.getKey();
            fieldName = fieldName.replaceAll(MessageConverter.RS_HYPHEN.STRING, MessageConverter.RS_HYPHEN.CHAR);
            String fieldValue = (String)headerEntry.getValue();
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_HYPHEN.STRING, MessageConverter.RS_HYPHEN.CHAR);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_EQUAL.STRING, MessageConverter.RS_EQUAL.CHAR);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_SLASH.STRING, MessageConverter.RS_SLASH.CHAR);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_COMMA.STRING, MessageConverter.RS_COMMA.CHAR);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_SPACE.STRING, MessageConverter.RS_SPACE.CHAR);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_COLON.STRING, MessageConverter.RS_COLON.CHAR);
            fieldValue = fieldValue.replaceAll(MessageConverter.RS_SEMICOLON.STRING, MessageConverter.RS_SEMICOLON.CHAR);
            httpHeaders.put(fieldName, fieldValue);
        }
        msgCtx.setProperty("TRANSPORT_HEADERS", httpHeaders);
    }

    private static final class Replace {
        public String CHAR;
        public String STRING;

        public Replace(String c, String string) {
            this.CHAR = c;
            this.STRING = string;
        }
    }
}

